﻿function contrastFilter(currentImageSource, contrast) {
    var canvas = document.createElement("canvas");
    canvas.setAttribute("height", canvasHeight);
    canvas.setAttribute("width", canvasWidth);
    var context = canvas.getContext("2d");

    var image = new Image();
    image.src = currentImageSource;

    image.onload = function() {
        context.drawImage(image, 0, 0, canvasWidth, canvasHeight);
        var imageData = context.getImageData(0, 0, canvas.width, canvas.height);
        var pixels = imageData.data;

        var factor = (259 * (contrast + 255)) / (255 * (259 - contrast));

        for (var i = 0; i < pixels.length; i += 4) {
            pixels[i] = factor * (pixels[i] - 128) + 128;
            pixels[i + 1] = factor * (pixels[i + 1] - 128) + 128;
            pixels[i + 2] = factor * (pixels[i + 2] - 128) + 128;
        }
        context.putImageData(imageData, 0, 0);
        drawFilteredImage(canvas);
    };
}