﻿function graySacaleFilter(currentImageSource) {

    var canvas = document.createElement("canvas");
    canvas.setAttribute("height", canvasHeight);
    canvas.setAttribute("width", canvasWidth);
    var context = canvas.getContext("2d");

    var image = new Image();
    image.src = currentImageSource;

    image.onload = function () {
        context.drawImage(image, 0, 0, canvasWidth, canvasHeight);

        var imageData = context.getImageData(0, 0, canvas.width, canvas.height);
        var pixels = imageData.data;
        for (var i = 0; i < pixels.length; i += 4) {
            var r = pixels[i];
            var g = pixels[i + 1];
            var b = pixels[i + 2];

            var v = 0.2126 * r + 0.7152 * g + 0.0722 * b;
            pixels[i] = pixels[i + 1] = pixels[i + 2] = v;
        }

        context.putImageData(imageData, 0, 0);
        drawFilteredImage(canvas);
    };
}
