﻿function histogramFilter(currentImageSource) {
     var canvas = document.createElement("canvas");
    canvas.setAttribute("height", canvasHeight);
    canvas.setAttribute("width", canvasWidth);
    var context = canvas.getContext("2d");

    var image = new Image();
    image.src = currentImageSource;

    image.onload = function () {
        context.drawImage(image, 0, 0, canvasWidth, canvasHeight);
        var imageData = context.getImageData(0, 0, canvas.width, canvas.height);

        var data = imageData.data;


        var rvals = array256(0);
        var gvals = array256(0);
        var bvals = array256(0);



        var p = canvas.width * canvas.height;
        var pix = p * 4;
        while (p--) {
            rvals[data[pix -= 4]]++;
            gvals[data[pix + 1]]++;
            bvals[data[pix + 2]]++;
        }


        
            var ctx = context;
            var vals = [rvals, gvals, bvals];
            for (var v = 0; v < 3; v++) {
                var yoff = (v + 1) * canvas.height / 3;
                var maxValue = 0;
                var i;
                for (i = 0; i < 256; i++) {
                    if (vals[v][i] > maxValue)
                        maxValue = vals[v][i];
                }
                var heightScale = canvas.height / 3 / maxValue;
                var widthScale = canvas.width / 256;
                if (v == 0) ctx.fillStyle = "rgba(255,0,0,0.5)";
                else if (v == 1) ctx.fillStyle = "rgba(0,255,0,0.5)";
                else if (v == 2) ctx.fillStyle = "rgba(0,0,255,0.5)";
                for (i = 0; i < 256; i++) {
                    ctx.fillRect(
							i * widthScale, canvas.height - heightScale * vals[v][i] - canvas.height + yoff,
							widthScale, vals[v][i] * heightScale
						);
                }
            }
            
            drawFilteredImage(canvas);

    };
}

function array256(defaultValue) {
    var arr = [];
    for (var i = 0; i < 256; i++) { arr[i] = defaultValue; }
    return arr;
}