﻿function sharpnessFilter(currentImageSource, strength) {
    var canvas = document.createElement("canvas");
    canvas.setAttribute("height", canvasHeight);
    canvas.setAttribute("width", canvasWidth);
    var context = canvas.getContext("2d");

    var image = new Image();
    image.src = currentImageSource;

    image.onload = function() {
        context.drawImage(image, 0, 0, canvasWidth, canvasHeight);
        var imageData = context.getImageData(0, 0, canvas.width, canvas.height);
        var data = imageData.data;
        var dataCopy = new window.Uint8ClampedArray(imageData.data);
        var mul = 15;
        var mulOther = 1 + 3 * strength;

        var kernel = [
				[0, -mulOther, 0],
				[-mulOther, mul, -mulOther],
				[0, -mulOther, 0]
			];

        var weight = 0;
        for (var i = 0; i < 3; i++) {
            for (var j = 0; j < 3; j++) {
                weight += kernel[i][j];
            }
        }

        weight = 1 / weight;


        var w = canvas.width;
        var h = canvas.height;

        mul *= weight;
        mulOther *= weight;

        var w4 = w * 4;
        var y = h;
        do {
            var offsetY = (y - 1) * w4;

            var nextY = (y == h) ? y - 1 : y;
            var prevY = (y == 1) ? 0 : y - 2;

            var offsetYPrev = prevY * w4;
            var offsetYNext = nextY * w4;

            var x = w;
            do {
                var offset = offsetY + (x * 4 - 4);

                var offsetPrev = offsetYPrev + ((x == 1) ? 0 : x - 2) * 4;
                var offsetNext = offsetYNext + ((x == w) ? x - 1 : x) * 4;

                var r = ((
						-dataCopy[offsetPrev]
						- dataCopy[offset - 4]
						- dataCopy[offset + 4]
						- dataCopy[offsetNext]) * mulOther
						+ dataCopy[offset] * mul
						);

                var g = ((
						-dataCopy[offsetPrev + 1]
						- dataCopy[offset - 3]
						- dataCopy[offset + 5]
						- dataCopy[offsetNext + 1]) * mulOther
						+ dataCopy[offset + 1] * mul
						);

                var b = ((
						-dataCopy[offsetPrev + 2]
						- dataCopy[offset - 2]
						- dataCopy[offset + 6]
						- dataCopy[offsetNext + 2]) * mulOther
						+ dataCopy[offset + 2] * mul
						);


                if (r < 0) r = 0;
                if (g < 0) g = 0;
                if (b < 0) b = 0;
                if (r > 255) r = 255;
                if (g > 255) g = 255;
                if (b > 255) b = 255;

                data[offset] = r;
                data[offset + 1] = g;
                data[offset + 2] = b;

            } while (--x);
        } while (--y);
        context.putImageData(imageData, 0, 0);
        drawFilteredImage(canvas);
    };
}