﻿function solarizeFilter(currentImageSource) {

var canvas = document.createElement("canvas");
    canvas.setAttribute("height", canvasHeight);
    canvas.setAttribute("width", canvasWidth);
    var context = canvas.getContext("2d");

    var image = new Image();
    image.src = currentImageSource;

    image.onload = function () {
        context.drawImage(image, 0, 0, canvasWidth, canvasHeight);
        var imageData = context.getImageData(0, 0, canvas.width, canvas.height);
        var pixels = imageData.data;
        for (var i = 0; i < pixels.length; i += 4) {

            if (pixels[i] > 127) pixels[i] = 255 - pixels[i];
            if (pixels[i + 1] > 127) pixels[i + 1] = 255 - pixels[i + 1];
            if (pixels[i + 2] > 127) pixels[i + 2] = 255 - pixels[i + 2];
        }

        context.putImageData(imageData, 0, 0);
        drawFilteredImage(canvas);
    };

}