// File Saver JS for Firefox OS

$(document).ready(function(){

	$('#save_button').on('click', function(){
		updateFileTitle();

		confirmBox("show");
	});



	$('#final-cancel').on('click', function(){
		cancelFile();
	});

	$('#final-save').on('click', function(){
		saveFile();
		navigator.vibrate(["200"]);
		confirmBox("hide");
	});


	$('#final-saveshare').on('click', function(){
		saveFile(true);
		navigator.vibrate(["200"]);
		confirmBox("hide");
	});




	$('#img_quality').on('change', function(){
		$('.quality_view').text($(this).val());
	});


	$('select[name=_SAVE_ext]').on('change', function(){
		if ($(this).val() == 'png') {
			$('.img-quality-range').hide();
		}

		else {
			$('.img-quality-range').show();
		}
	});

});

function updateFileTitle() {
	// Update the file Title
	var path = "Resized_Pics/";
	var nameGen = RandomName(path);
	$('input[name=_SAVE_name]').val(nameGen);
}



function cancelFile() {
	confirmBox('hide');
}

function saveFile(share) {
	var fileTitle;
	var fileType;
	var imageBlob;

	
	/* The file Extention */
	var file_ext = $('#file_saver_form select[name=_SAVE_ext]')[0].value;
	fileType = "image/" + file_ext;


	/* The file Name */
	var _file_n = $('input[name=_SAVE_name]').val();
	fileTitle = _file_n + "." + file_ext;


	// Create the file here
	var ext = $('#file_saver_form select[name=_SAVE_ext]').val();


	// Show a success/error message



	// Quality and type
	if (file_ext !== "png") {
	    var saveType = "image/" + file_ext;
	    var quality = $('#img_quality').val();
	    quality = parseFloat(quality);
    }
    else {
    	var saveType = null;
	    var quality = null;
    }


	// Saving Process
	var cnv = document.getElementById('myCanvas');
    cnv.toBlob(function (blob) {

     //var sdcard = navigator.getDeviceStorage("pictures");
     var sdcard = navigator.getDeviceStorage("sdcard");
     var request = sdcard.delete(fileTitle);
     //try to delete in case it exists
     request.onsuccess = function () {
         saveFileBlob(blob, fileTitle, fileType, share);

         // Notify
         awesomeNotif("File saved successfully: " + fileTitle, "success");

     }

     request.onerror = function () {
         alert("There was an error saving the file.");
     }


   }, saveType, quality);


	// Hide the confirm box
}


function saveFileBlob(blob, name, type, share) {
	 var shareThis = share;

     var sdcard = navigator.getDeviceStorage("sdcard");
     var request = sdcard.addNamed(blob, name);

     // Just file name (no path)
     var name_2 = name.split("/");
     name_2 = name[name.length - 1];


     //could just share the blob instead of saving
     request.onsuccess = function () {
     	if (share) {
         var sharingImage = new MozActivity({
             name: "share",
             data: {
                 type: "image/*",
                 number: 1,
                 blobs: [blob],
                 filenames: [name_2],
                 filepaths: [name]
             }
         });
       }

       console.log("The file: " + name_2 + " saved successfully");
     }

     // An error could occur if a file with the same name already exist
     request.onerror = function () {
         console.log('Unable to write the file: ' + this.error.name);
     }

}




function saveFileShare(){
	saveFile();
}

function shareFile(name, path, blob) {
	var sharingImage = new MozActivity({
             name: "share",
             data: {
                 type: "image/*",
                 number: 1,
                 blobs: [blob],
                 filenames: ["mycanvas.png"],
                 filepaths: ["test/mycanvas.png"]
             }
     });
}




function confirmBox(state){
	var state = state.toLowerCase();
	if (state == "hide") {
	    $('.file-save-confirm').fadeOut();
	    return true;
    }

    else if (state == "show") {
    	$('.file-save-confirm').fadeIn();
    	return true;
    }

    else {
    	console.warn("You need to pass at least one argument to the function. Either 'Hide' or 'Show'");
    	return true;
    }
}



/* Notification */
function awesomeNotif(text, type) {

	var randomId =  "notif_" + (Date.now());

	// Clear the HTML first
	$(_awesomeNotif).html('');

	// Notif. Box HTML
	var htmlNotif = "<div class='awesomeNotif notifBox "+ type +"' id='"+ randomId +"'><div class='box-Inner'><span class='message-text'>"+ text +"</span></div>";

    $('#_awesomeNotif').html(htmlNotif);

	// Show
	$('#_awesomeNotif').fadeIn(200);

	// FadeOut after 4 seconds
	var hideIt = setTimeout(function(){
		$('#_awesomeNotif').fadeOut(200);
	}, 4 * 1000);

}


function RandomName(path) {
	if (path) {
	    var filePath = path;
    }
    else {
    	var filePath = "";
    }

	var finalName = "";
	var randomFour = "";
	var alpha = "abcdefghijklmnopqrstuvwxyz";
	var date = new Date();
	var _date = {
		"month": date.getMonth() + 1,
		"date": date.getDate(),
		"hr"  : date.getHours(),
		"min" : date.getMinutes(),
		"msc" : date.getMilliseconds()
	}

	for (i = 0; i < 4; i++) {
		var idx = getRandomInt(0, (alpha.length - 1));
		randomFour += alpha[idx]; 
	}



	finalName += filePath + "PIC-" + randomFour + "_" + _date["date"] + "-" + _date["month"] + "-" + _date["msc"];

    return finalName;
}



function getRandomInt(min, max) {
    return Math.floor(Math.random() * (max - min + 1)) + min;
}
