
var elmHeight;
var blobUrl;
var targetResult;
var debugVar;

$(document).ready(function(){

  /***********************
   UI Setup
  ***********************/
  toMedium(1600, 10);

  window.onload = function(){
      elmHeight = {
        'window'  : $(window).outerHeight(),
        'header'  : $('#header').outerHeight(),
        'screens' : ($(window).outerHeight() - $('#header').outerHeight()) - (10*2),
      } 

      // Automatically set the height for the elements
      $('.screens article.screen').css({'height': elmHeight['screens']});
  }


  // File selector click
  $('#select_img_form .icon_select').on('click', function(){
    $('#_selected_img').click();
  });

  $('#_selected_img').on('change', function(){
    imageLoad();
  });


  // Range and Number Sync
  $('#range_size').on('change', function(){
    var valNow = $(this).val();
    $('#number_size').val(valNow);
  });

  $('#number_size').on('change', function(){
    var valNow = $(this).val();
    $('#range_size').val(valNow);
  });


  $('#size_input').on('change', function(){
    $('.resize_px_').text(range_size.value + "px");
  });

});



/* File Selection */
$(document).ready(function(){

  $('#select_img_form').on('change', function(){
    imageLoad();
  });

  $('input[name=img_size]').on('change', function(){
    imageLoad();
  });

});




// Just functions

function twoDec(num){
  return Math.round(num * 100) / 100;
}

function toMedium(max, min) {
  var medium = max / 2 + (min / 2);
  medium = parseInt(medium, 10);

  $('input[name="img_size"]').val(medium);
}


function changeValues(){
  var range_old = range_size.value;
  var number_old = number_size.value;
}


function sdSize(n) {
    var reslt;

    if (n < 1024) {
      reslt = twoDec((n / 1024)) + " byte";
    }

    else if (n >= 1024 && n < 1024 * 1024) {
      reslt = twoDec((n / 1024)) + " kb";
    }

    else if (n >= 1024 * 1024) {
      reslt = twoDec((n / 1024 / 1024)) + " mb";
    }

    return reslt;
}





// SFX
$(document).ready(function(){

  // Screen touch move
   window.addEventListener('touchmove', function(e){
      var fromTop = e.changedTouches[0].screenY;
 
      var a = fromTop - $(window).height();
      $('body').css({'background-position': '0px ' + a + 'px'});
      console.log(e);
   }, true);

});








