
function WinImageBrowserController(win, info) {
	var me = this;
	var storageName = 'sdcard';
	
	this.onItemClicked = function(item) {
		var filename = item.getValueOf("ui-color-tile");
		var image = item.getHtmlImageByType(C_SHAPE_IMAGE_ALL);

		me.image = image;
		me.filename = filename;

		win.setValueOf("ui-edit-filename", filename);

		return;
	}

	this.onOK = function() {
		var me = this;
		var result = {};
		var filename = win.getValueOf("ui-edit-filename");
	
		if(!filename) {
			return;
		}

		result.filename = filename;
		if(info.action == "save") {
			this.deleteFile(storageName, filename, function() {
				me.saveFile(storageName, filename, info.data);
			});
		}
		else {
			result.image = me.image;
		}

		win.closeWindow(result);

		return;
	}

	this.deleteFile = function(storageName, filename, onDone) {
		var sdcard = navigator.getDeviceStorage(storageName);
		var request = sdcard.delete(filename);
		
		request.onsuccess = function () {
			onDone();	
			console.log("File deleted: " + filename);
		}
		
		request.onerror = function () {
			onDone();	
			console.log("Unable to delete the file: " + this.error);
		}

		return;
	}

	this.saveFile = function(storageName, filename, blob) {
		var file = blob;
		var sdcard = navigator.getDeviceStorage(storageName);

		var request = sdcard.addNamed(file, filename);

		request.onsuccess = function () {
		  var name = this.result;
		  console.log('File "' + name + '" successfully wrote on the sdcard storage area');
		}

		request.onerror = function () {
		  console.log('write file: ' + this.error);
		}

		return;
	}

	this.showFiles = function() {
		var me = this;
		var gridView = win.findChildByName("ui-grid-view", true);

		var files = navigator.getDeviceStorage(storageName);
		var cursor = files.enumerate();

		var data = {children:[]};
		gridView.bindData(data, null, true);

		cursor.onsuccess = function () {
			var file = this.result;
			if (file != null) {
				var name = file.name;
				var type = file.type;
    			var str = file.name + "," + file.lastModifiedDate + "," + file.type + "," + file.size;

				if(type.indexOf("image") >= 0) {
					var item = {children:[]};
					var url = window.URL.createObjectURL(file);

					item.image = url;
					item.children.push({text:file.name});
					data.children.push(item);
				}

				//me.deleteFile(storageName, name, function() {});
    			this.done = false;
    		}
    		else {
    			gridView.bindData(data, null, true);
    			this.done = true;
    		}
    		
    		if (!this.done) {
    			this.continue();
    		}
    	}

		return;
	}

	this.init = function() {
		var filename = info.filename ? info.filename : "";
		var edit = win.findChildByName("ui-edit-filename", true);
		var action = win.findChildByName("ui-label-action", true);

		edit.setText(filename);
		if(info.action == "save") {
			action.setText("Save");
		}
		else {
			action.setText("Open");
		}

		this.showFiles();
	}

	this.init();

	return this;
}

function createWinImageBrowserController(win, initData) {
	win.controller = new WinImageBrowserController(win, initData);

	return win.controller;
}

