window.onload = function() {
	frame			= document.getElementById("frame"),
	imageFrame		= document.getElementById("image-frame"),
	ctx				= frame.getContext("2d"),
	ctx1			= imageFrame.getContext("2d"),
	imageFile		= document.getElementById("image-file"),
	updateImage		= document.getElementById("update-image"),
	watermarkText	= document.getElementById("watermark-text"),
	downloadImage	= document.getElementById("download-image"),
	uploadImage		= document.getElementById("upload-image");

	var img = new Image;
	img.src = "http://placehold.it/"+frame.width+"x"+frame.height+"/f2f2f2/aaa&text=Select%20Your%20Image";
	img.addEventListener("load", function() {
		ctx.drawImage(img, 0, 0, img.width, img.height);
	});

	imageFile.addEventListener("change", function(e) {
		file		= e.target.files[0],
		filename	= file.name,
		image 		= new Image;
		
		image.src = URL.createObjectURL(file);

		image.addEventListener("load", function() {
			hratio	= frame.width/image.width,
			vratio	= frame.height/image.height,
			ratio	= Math.min(hratio, vratio),
			centerX	= (frame.width-image.width*ratio)/2,
			centerY	= (frame.height-image.height*ratio)/2;

			console.log("centerX: "+centerX+", centerY: "+centerY+" width: "+frame.width+", height: "+frame.height);

			ctx.clearRect(0 , 0, frame.width, frame.height);
			ctx.drawImage(image, 0, 0, image.width, image.height,
								 centerX, centerY, image.width*ratio, image.height*ratio);

			imageFrame.width = image.width;
			imageFrame.height = image.height;

			ctx1.clearRect(0 , 0, imageFrame.width, imageFrame.height);
			ctx1.drawImage(image, 0, 0, imageFrame.width, imageFrame.height);
		});

		updateImage.addEventListener("click", function() {
			ctx.clearRect(0 , 0, frame.width, frame.height);
			ctx.drawImage(image, 0, 0, image.width, image.height,
								 centerX, centerY, image.width*ratio, image.height*ratio);

			ctx1.clearRect(0 , 0, imageFrame.width, imageFrame.height);
			ctx1.drawImage(image, 0, 0, image.width, image.height);

			ctx.rect(centerX, frame.height-20, image.width*ratio, frame.height-20);
			ctx.fillStyle = 'rgba(0, 0, 0, 0.5)';
      		ctx.fill();
      		ctx.font = "12px Lobster";
      		ctx.fillStyle = "#fff";
      		ctx.fillText(watermarkText.value, centerX+5, frame.height-6);

      		ctx1.rect(0, imageFrame.height-40, image.width, imageFrame.height-40);
			ctx1.fillStyle = 'rgba(0, 0, 0, 0.5)';
      		ctx1.fill();
      		ctx1.font = "18px Lobster";
      		ctx1.fillStyle = "#fff";
      		ctx1.fillText(watermarkText.value, 15, imageFrame.height-15);
		});

		downloadImage.addEventListener("click", function() {
			this.href = imageFrame.toDataURL(image);
			this.download = filename;
		});
	});
};