//Copyright Claudio Mariano Carrazana © 2013 email:mariano@poweredbylinux.es
function loadSynth()
{
env = T(Type, {d:Decay, s:Hold, a:Attack, r:Release});
env.plot({target:Env});
synth = T(Generator, {mul:0.25, poly:Poly}).play();
if(mobile==false){
	synth.def = function(opts) {
  var op1 = T(Phase, {freq:opts.freq*7, fb:0.5, mul:0.9});
  var op2 = T(Wave, {freq:opts.freq, phase:op1, mul:opts.velocity/150});
  //var op3 = T("delay", {time:100, fb:0.5, mix:0.0}, op2);

  //var op6 = T("comp", {thresh:-48, knee:30, ratio:24, gain:18}, op5);
  //var op7 = T("phaser", {freq:opts.freq, Q:1, steps:8}, op6);
  var op3 = T("dist", {pre:effect.Pre, post:effect.Post, cutoff:effect.Cutoff}, op2);
  var op4 = T("chorus", {delay:effect.Delay, rate:effect.Rate, depth:effect.Depth, fb:effect.Feedback, mix:effect.MixC}, op3);
  var op5 = T("reverb", {room:effect.Room, damp:effect.Damp, mix:effect.Mix}, op4);
  op2.plot({target:wave1});op1.plot({target:wave2});
  return env.clone().append(op5).on("ended", opts.doneAction).bang()}
  }
else{
	synth.def = function(opts) {
  var op2 = T(Wave, {freq:opts.freq, mul:opts.velocity/150});
  op2.plot({target:wave1});
  return env.clone().append(op2).on("ended", opts.doneAction).bang()}
	}
  var keydict = T("ndict.key");
T("keyboard").on("keydown", function(e)
{
  midi = keydict.at(e.keyCode)+24;
  if (midi)
  {
		if(mode=="synth"){synth.noteOn(midi,100)}
		else{T.soundfont.play(midi, false)}
		if(id("keyN"+midi)!=null)id("keyN"+midi).style.background="#f50";
  }
}).on("keyup", function(e) {
  midi = keydict.at(e.keyCode)+24;
 if (midi) {
   if(mode=="synth"){synth.noteOff(midi)}
	if(id("keyN"+midi)!=null)id("keyN"+midi).style.background="";
  }
}).start();
if(firstTime==0){playKey(58);setTimeout(function(){playStop(58)},500);}
firstTime=0;
}
var playingKey=new Array();
function playKey(midiIn)
{
	if(playingKey[midiIn]!=true){
	if(mode=="synth"){synth.noteOn(midiIn, 100)	}
 	else{T.soundfont.play(midiIn, false)}
 	playingKey[midiIn]=true;
	var nm=id("keyN"+midiIn);
 	if(nm!=null)nm.style.background="#1f6";  
	}
}
function playStop(midiIn)
{
	if(mode=="synth"){synth.noteOff(midiIn, 100)}
	playingKey[midiIn]=false;
	var nm=id("keyN"+midiIn);
	if(nm!=null)nm.style.background="";
}
function loadValues()
{
	Type=id("Type").value;
	Decay=parseInt(id("Decay").value);
	Hold=parseInt(id("Hold").value);
	Attack=parseInt(id("Attack").value);
	Release=parseInt(id("Release").value);
	Generator=id("Generator").value;
	Phase=id("Phase").value;
	Wave=id("Wave").value;
	Poly=parseInt(id("Poly").value);
	loadSynth();
}