$(document).ready(function(){
	
	// temporary workaround for adjusting em size when FxOS version is larger than 2.0
	var pos = navigator.userAgent.indexOf("rv:") + 3;
	if (parseInt(navigator.userAgent.substring(pos, pos+3)) > 32)
	{
		$("body").css({"font-size": "4em"});
	}
	
	
	var colorScheme = "#556AFF";
	var depressedButtonStyle;
	var raisedButtonStyle;
	var buttonStyle;
	var bodyStyle;
	var shinyButtonStyle;
	var isFirstUse;
	
	var deviceHeight = $(window).height();
	var deviceWidth = $(window).width();
	setTimeout(function(){
		$("textarea").css("height", deviceHeight + "px");
		$("#picText").css("width", deviceWidth);
	}, 500);
	
	$("#pickLauncher").on("vclick", function(){
		var pick = new MozActivity({
		   name: "pick",
		   data: {
		       type: ["image/png", "image/jpg", "image/jpeg"]
		   }
		});
		
		pick.onsuccess = function(){
			var imageURL = URL.createObjectURL(this.result.blob);
			$("#finish, #enlargeImage, #shrinkImage").slideDown(250);
			$("body").css({"background": "black", "background-image": "none"});
			$("#picWindow").html("<img id='currentImg' src='" + imageURL + "'>");
			$("#currentImg").show();
			
			setTimeout(function(){
				deviceWidth = $(window).width();
				deviceHeight = $(window).height();
				var tempWidth = $("#currentImg").width();
				var tempHeight = $("#currentImg").height();
				if (tempWidth/tempHeight < deviceWidth/deviceHeight)
				{
					$("#currentImg").css({"max-height": deviceHeight, "max-width": tempWidth*deviceHeight/tempHeight});
				}
				else
				{
					$("#currentImg").css({"max-width": deviceWidth, "max-height": tempHeight*deviceWidth/tempWidth});
				}
				centerCurrentImg();
				$("#picText").show();
				$("#picText").val("");
			}, 500);
		}; // pick onsuccess
	}); // #pickLauncher vclick handler
	
	
	var canvasTextStyle = {
		"fontFamily": "Fira Sans",
		"bold": "",
		"italic": "",
		"fontSize": 45,
		"fillStyle": "white",
		"strokeStyle": "",
		"lineHeight": 45
	};
	
	
	
	if (localStorage.getItem("Pic1000|UI_isModified") === null)
	{
		changeColorScheme(colorScheme);
		depressedButtonStyle["box-shadow"] = "0 0 1em blue";
	}
	else
	{
		colorScheme = localStorage.getItem("Pic1000|UI_selectedColor");
		changeColorScheme(colorScheme);
	}
	
	if (localStorage.getItem("Pic1000|isFirstUse") === null)
	{
		isFirstUse = true;
	}
	else
	{
		isFirstUse = false;
	}
	
	if (isFirstUse)
	{
		alert("Welcome to Pic1000!  To assist you in using your new app, we'll take you straight to the Help Menu.");
		$("#helpContent").slideDown(250);
		localStorage.setItem("Pic1000|isFirstUse", "false");
		$("#picText").one("focus", function(){
			alert("Swipe down on the keyboard to hide it.");	
		});
	}
	
	var currentTextStyle = $("#picText").attr("class");
	
	$("#colorSchemeText").keyup(function(event){
		if (event.which == 13){
			$("#colorSchemeConfirm").click();
			$("#colorSchemeText").blur();
		}
	});
	
	// iterate through each .color
	$(".color").each(function(){
		// get appropriate color for buttons and style with .css() method call
		var color = $(this).attr("id");
		$(this).css("background", color);
	});
	
	// vclick event handler -- set #picText and canvas font color
	$(".color").on("vclick", function(){
		var color = $(this).attr("id");
		$("#picText").css("color", color);
		canvasTextStyle.fillStyle = color;
	});
	
	
	$("#picText").css("color", "white");
	canvasTextStyle.fillStyle = "white";
	
	// set height and width of invisible canvas to that of the device
	$("#saveImgCanvas").attr("height", deviceHeight);
	$("#saveImgCanvas").attr("width", deviceWidth);
	
	// document swipeleft/right event handlers -- show and hide the menu
	$(document).on("swipeleft", showMenu);
	$(document).on("swiperight", hideMenu);
	
	// document scroll event handler -- keep #picText element centered horizontally
	$(document).scroll(function(){
		if (($("#picText").is(":visible") || $("#colorSchemeText").is(":visible")) && $("#currentImg").width() > deviceWidth && $(document).scrollLeft() <= $("#currentImg").width()-deviceWidth)
		{
			$("#picText").css("margin-left", $(document).scrollLeft());
		}
	}); // document scroll handler
	
	// vclick event handler -- tapping the #launcher toggles the #settingsContent element and hides the menu
	$("#settingsLauncher").on("vclick", function(){
		$("#settingsContent").toggle(250);
		hideMenu();
	}); // #settingsLauncher vclick handler
	
	/* vclick event handler -- tapping #colorSchemeConfirm will:
	 * 1. hide the #settingsContent element
	 * 2. call the showMenu method
	 * 3. set the new color scheme with a call to changeColorScheme (PARAM new color) IF the value of the textbox is not empty (return;)
	 * 4. call the raiseButton method for #colorSchemeConfirm
	 * 5. set the Pic1000|UI_isModified value in localStorage to true
	 * 6. set the Pic1000|UI_selectedColor value in localStorage for later reference on startup
	 */
	$("#colorSchemeConfirm").on("vclick", function(){
		$("#settingsContent").hide(250);
		showMenu();
		var newColor = $("#colorSchemeText").val().trim();
		if (newColor == ""){
			return;
		}else{
			changeColorScheme(newColor);
			raiseButton($("#colorSchemeConfirm"));
			localStorage.setItem("Pic1000|UI_isModified", "true");
			localStorage.setItem("Pic1000|UI_selectedColor", newColor);
		}
	});
	
	/*
	 * PARAM colorScheme (String): the color to style the UI elements with
	 * 1. modify all style JSON objects with colorScheme
	 * 2. apply all styles to elements
	 */
	function changeColorScheme(colorScheme){
		depressedButtonStyle = {
								"box-shadow": "0 0 1em " + colorScheme,
								"text-shadow": "0.1em 0.1em black",
								"color": "white"
								};
		
		raisedButtonStyle = {
							 "color": "black",
							 "box-shadow": "none",
							 "text-shadow": "none"
							};
		
		buttonStyle = {
					   "border": "0.1em solid " + colorScheme
					  };
					  
		bodyStyle = {
					 "background": colorScheme,
					 "background-image": "none"
					};
					
		shinyButtonStyle = {
						   "background": "linear-gradient(-60deg, " + colorScheme + " 10%, white 80%)"
						  };
						  
		$(".depressedButton").css(depressedButtonStyle);
		$(".raisedButton").css(raisedButtonStyle);
		$(".depressible, .clickable, #fontList div").css(buttonStyle);
		$(".fontButton, .optionButton").css(shinyButtonStyle);
		$("#color").css({"background": "linear-gradient(90deg, red, orange, yellow, green, blue, indigo, violet)"});
		$("#colorScheme").text(colorScheme);
		$("#colorScheme").css("color", colorScheme);
	} // changeColorScheme method
	
	/*
	 * vclick event handler -- tapping #helpLauncher will:
	 * 1. show the help menu (#helpContent)
	 * 2. call the hideMenu method
	 */
	$("#helpLauncher").on("vclick", function(){
		$("#helpContent").slideDown(250);
		hideMenu();
	}); // #helpLauncher vclick handler
	
	/*
	 * vclick event handler -- tapping #helpCloser will:
	 * 1. hide the help menu (#helpContent)
	 * 2. call the showMenu method
	 */
	$("#helpCloser").on("vclick", function(){
		$("#helpContent").slideUp(250);
		showMenu();
	}); // #helpCloser vclick handler
	
	/*
	 * vclick event handler -- tapping #finish will:
	 * 1. construct a JSON object (naturalImg) with the natural width and height of the current image
	 * 2. construct a JSON object (DOMelementImg) with the current metrics of the #currentImg element
	 * 3. store the proportion of the naturalImg to the DOMelementImg; all canvas calculations will be multiplied by this number to keep it scaled
	 * 4. construct a JSON object (canvasImg) and set the metrics for it so that it, for all practical purposes, is taking a screenshot
	 * 5. get the hidden canvas element from the DOM and fill it with a black rectangle
	 * 6. draw the image into the canvas
	 * 7. declares two methods: fillCanvasText and strokeCanvasText with checks for line breaks
	 * 7. set the text fill of the canvas
	 * 8. call the fillCanvasText method
	 * 9. set the text stroke of the canvas
	 * 10. call the strokeCanvasText method
	 * 11. create a blob from the canvas
	 * 12. store the blob in DeviceStorage as an image file
	 * 13. load the newly created image into the share menu
	 * 14. show the #shareLauncher element
	 * 15.A attach an event handler to the #shareContent .confirm button that will launch the email client
	 */
	$("#finish").on("vclick", function(){
		$("#picText").blur();
		
		canvasTextStyle.lineHeight = $("#picText").css("line-height");
		canvasTextStyle.lineHeight = canvasTextStyle.lineHeight.substring(0, canvasTextStyle.lineHeight.indexOf("px"));
		var naturalImg = {
			"img": document.getElementById("currentImg"),
			"width": null,
			"height": null
		};
		naturalImg.width = naturalImg.img.naturalWidth;
		naturalImg.height = naturalImg.img.naturalHeight;
		
		var DOMelementImg = {
			"src": $("#currentImg").attr("src"),
			"width": $("#currentImg").width(),
			"height": $("#currentImg").height(),
			"marginLeft": $("#currentImg").css("margin-left").substring(0, $("#currentImg").css("margin-left").indexOf("px")),
			"marginTop": $("#currentImg").css("margin-top").substring(0, $("#currentImg").css("margin-top").indexOf("px"))
		};
		
		var natural_To_DOMelement_Img_Proportion = naturalImg.width / DOMelementImg.width;
		
		var canvasImg = {
			"object": new Image(),
			"cropX": $(document).scrollLeft() * natural_To_DOMelement_Img_Proportion,
			"cropY": $(document).scrollTop() * naturalImg.height / DOMelementImg.height,
			"cropWidth": naturalImg.width,
			"cropHeight": naturalImg.height,
			"displayX": 0,
			"displayY": 0,
			"displayWidth": null,
			"displayHeight": null
		};
		canvasImg.object.src = DOMelementImg.src;
		
		if (DOMelementImg.width > deviceWidth){
			canvasImg.cropWidth = deviceWidth * natural_To_DOMelement_Img_Proportion;
			canvasImg.displayWidth = deviceWidth;
		}else{
			canvasImg.displayX = DOMelementImg.marginLeft;
			canvasImg.displayWidth = DOMelementImg.width;
		}
		
		if (DOMelementImg.height > deviceHeight){
			canvasImg.cropHeight = deviceHeight * natural_To_DOMelement_Img_Proportion;
			canvasImg.displayHeight = deviceHeight; 
		}else{
			canvasImg.displayY = DOMelementImg.marginTop;
			canvasImg.displayHeight = DOMelementImg.height;
		}
		
		var saveImgCanvas = document.getElementById("saveImgCanvas");
		var context = saveImgCanvas.getContext("2d");
		
		context.rect(0, 0, deviceWidth, deviceHeight);
		context.fillStyle = "black";
		context.fill();
		
		context.drawImage(canvasImg.object, canvasImg.cropX, canvasImg.cropY, canvasImg.cropWidth, canvasImg.cropHeight, canvasImg.displayX, canvasImg.displayY, canvasImg.displayWidth, canvasImg.displayHeight);
				
		function fillCanvasText(ctx, textStr, x, y, lineWidth, lineHeight) {
			var words = textStr.split(" ");
			var currentLine = "";
			x = parseInt(x);
			y = parseInt(y);
			lineHeight = parseInt(lineHeight);
			ctx.font = context.font;
			
			for (var i = 0; i < words.length; i++) {
				if (words[i].indexOf("<br>") == 0){
					ctx.fillText(currentLine, x,y);
					y += lineHeight;
					ctx.fillText(" ", x, y);
					currentLine = words[i].substring(4) + " ";
					
				}else{
					var virtualLine = currentLine + words[i] + " ";
					var virtualMetrics = ctx.measureText(virtualLine);
					if (virtualMetrics.width > lineWidth && i > 0) {
						ctx.fillText(currentLine, x, y);
						currentLine = words[i] + " ";
						y = parseInt(y);
						y += parseInt(lineHeight);
					}else {
						currentLine = virtualLine;
					}
				}
			}
			ctx.fillText(currentLine, x, y);
		}
		
		function strokeCanvasText(ctx, textStr, x, y, lineWidth, lineHeight) {
			var words = textStr.split(" ");
			var currentLine = "";
			x = parseInt(x);
			y = parseInt(y);
			lineHeight = parseInt(lineHeight);
			ctx.font=context.font;
			for (var i = 0; i < words.length; i++) {
				if (words[i].indexOf("<br>") == 0){
					ctx.strokeText(currentLine, x,y);
					y += lineHeight;
					ctx.strokeText(" ", x, y);
					currentLine = words[i].substring(4) + " ";
					
				}else{
					var virtualLine = currentLine + words[i] + " ";
					var virtualMetrics = ctx.measureText(virtualLine);
					if (virtualMetrics.width > lineWidth && i > 0) {
						ctx.strokeText(currentLine, x, y);
						currentLine = words[i] + " ";
						y += lineHeight;
					}else{
						currentLine = virtualLine;
					}
				}							
			}
			ctx.strokeText(currentLine, x, y);
		}
		
		var captionText = $("#picText").val().replace(/\n/g, " <br>");
		
		canvasTextStyle.fontSize = $("#picText").css("font-size");
		canvasTextStyle.fontSize = canvasTextStyle.fontSize.substring(0, canvasTextStyle.fontSize.indexOf("px"));
		context.font = canvasTextStyle.bold + " " + canvasTextStyle.italic + " " + canvasTextStyle.fontSize + "px " + canvasTextStyle.fontFamily;
		context.font = context.font.trim();
		context.fillStyle = canvasTextStyle.fillStyle;
		fillCanvasText(context, captionText, 2, canvasTextStyle.fontSize, deviceWidth, canvasTextStyle.lineHeight);
		
		if (canvasTextStyle.strokeStyle != ""){
			context.strokeStyle = canvasTextStyle.strokeStyle;
			strokeCanvasText(context, captionText, 2, canvasTextStyle.fontSize, deviceWidth, canvasTextStyle.lineHeight);
		}
		
		saveImgCanvas.toBlob(function(fileBlob){
			
			var pictures = navigator.getDeviceStorage("pictures");
			var d = new Date();
			var month = ("" + d.getMonth()).replace("0", "12");
			var day = d.getDate();
			var year = d.getFullYear();
			var hour = d.getHours();
			var min = d.getMinutes();
			var sec = d.getSeconds();
			
			var fileName = "Pic1000_" + month + "-" + day + "-" + year + "_" + hour + "-" + min + "-" + sec + ".png";
			var request = pictures.addNamed(fileBlob, fileName);
			request.onerror = function(){
				console.log("ERROR write to pictures" + this.error);
				alert("Pic1000 was unable to save your work!  \nCheck your device's settings to ensure that Pic1000 is allowed to access your image storage, then try again.  \nIf this does not solve the problem, email support@twinklecode.org.");
			};
			
			request.onsuccess = function(){
				alert("Saved to Gallery!");
				
				var fileURL = URL.createObjectURL(fileBlob);
				$("#chosenImage").attr("src", fileURL);
				
				$("#shareLauncher").show();
				
				$("#shareLauncher").on("vclick", function(){
					$("#shareContent").slideDown(250);
				});
				
				$("#shareContent #deny").on("vclick", function(){
					$("#shareContent").slideUp(250);	
				});
				
				$("#shareContent #confirm").on("vclick", function(){
					$("#shareContent").slideUp(250);
					var createEmail = new MozActivity({
						name: "new", // Possibly compose-mail in future versions
						data: {
							type : "mail",
							blobs: [fileBlob],
							filenames: [fileName]
						}
					}); // MozActivity object
				}); // #shareContent #confirm vclick event handler
			}; // onsuccess
		}); // toBlob call
	}); // #finish vclick event handler
	
	$("#picText").focus(function(){
		setTimeout(function(){$(document).scrollTop(0)}, 100);
	});
	
	/*
	 * window orientationchange event handler -- turning the device OR using the keyboard will:
	 * NOTE: IF any text field has focus, THEN the keyboard will be shown and an orientationchange event will fire
	 * 1. show the #exitKeyboard element IF a keyboard is shown, and then scroll the document back up
	 * 1. OTHERWISE the #exitKeyboard element will be hidden
	 * 2. set the width of #picText to deviceWidth (deviceHeight is also updated)
	 * 3. call the centerCurrentImg method
	 */
	$(window).on("orientationchange", function(event){
		setTimeout(function(){$(document).scrollTop(0)}, 50);
		$("#colorSchemeText, #picText").blur();
		if (!$("#colorSchemeText").is(":focus") && !$("#picText").is(":focus"))
		{
			deviceWidth = $(window).width();
			deviceHeight = $(window).height();
			var tempWidth = $("#currentImg").width();
			var tempHeight = $("#currentImg").height();
			if (tempWidth/tempHeight < deviceWidth/deviceHeight)
			{
				$("#currentImg").css({"max-height": deviceHeight, "max-width": tempWidth*deviceHeight/tempHeight});
			}
			else
			{
				$("#currentImg").css({"max-width": deviceWidth, "max-height": tempHeight*deviceWidth/tempWidth});
			}
			
			
			$("#saveImgCanvas").attr("width", deviceWidth);
			$("#saveImgCanvas").attr("height", deviceHeight);
			$("textarea").css("height", deviceHeight + "px");
			$("#picText").css("width", deviceWidth);
		}
		
		centerCurrentImg();
	});
	
	function raiseButton(element){
		element.removeClass("depressedButton");
		element.addClass("raisedButton");
		element.css(raisedButtonStyle);
	}
	
	function depressButton(element){
		element.removeClass("raisedButton");
		element.addClass("depressedButton");
		element.css(depressedButtonStyle);
	}
	
	$(".clickable").on("vmousedown", function(){
		depressButton($(this));
		$(this).one("vmouseup", function(){
			raiseButton($(this));
		});
	});
	
	$("#bold").on("vclick", function(){
		if (canvasTextStyle.bold == "bold"){
			$("#picText").css("font-weight", "normal");
			canvasTextStyle.bold = "";
		}else{
			$("#picText").css("font-weight", "bold");
			canvasTextStyle.bold = "bold";
		}
	});
	
	$("#italics").on("vclick", function(){
		if (canvasTextStyle.italic == "italic"){
			$("#picText").css("font-style", "normal");
			canvasTextStyle.italic = "";
		}else{
			$("#picText").css("font-style", "italic");
			canvasTextStyle.italic = "italic";
		}
	});
	
	$(".depressible").on("vclick", function(){
		if (($(this).attr("class")).indexOf(" depressedButton") != -1){
			raiseButton($(this));
		}else{
			depressButton($(this));
		}
	});
	
	$("#shrinkFont").on("vclick", function(){
		$("#picText").css("font-size", "-=5px");
		canvasTextStyle.fontSize -=5;
	});
	
	$("#enlargeFont").on("vclick", function(){
		$("#picText").css("font-size", "+=5px");
		canvasTextStyle.fontSize += 5;
	});
	
	$("#enlargeImage").on("vclick", function(){
		$("#currentImg").css("width", "+=10%");
		centerCurrentImg();
	});
	
	$("#shrinkImage").on("vclick", function(){
		$("#currentImg").css("width", "-=10%");
		centerCurrentImg();
	});
	
	$("#fontList div").on("vclick", function(){
		$("#picText").removeClass(currentTextStyle);
		var style = $(this).attr("class").trim();
		var i = style.indexOf(" ");
		if (i != -1){
			style = style.substring(0, i);
		}
		
		$("#picText").addClass(style);
		currentTextStyle = style;
		
		if (style.indexOf("MemeSet") != -1){
			canvasTextStyle.strokeStyle = "black";
		}else{
			canvasTextStyle.strokeStyle = "";
		}
		canvasTextStyle.fontFamily = $("#picText").css("font-family");
		$("#fontList div").each(function(){
			raiseButton($(this));
		});
		depressButton($(this));
		$("#MemeSet").css({"color": "white", "text-shadow": "-0.1em -0.1em #000000, -0.1em 0.1em #000000, 0.1em -0.1em #000000, 0.1em 0.1em #000000"});
	});
	
	var colorListIsShown = false;
	$("#color").on("vclick", function(){
		if (!colorListIsShown){
			$("#colorList").slideDown(500);
			colorListIsShown = true;
		}else{
			$("#colorList").slideUp(500);
			colorListIsShown = false;
		}
	});
	
	var fontListIsShown = false;
	$("#font").on("vclick", function(){
		if (!fontListIsShown){
			$("#fontList").slideDown(250);
			
			if (colorListIsShown){
				$("#menu").animate({
					scrollTop: $("#fontList").offset().top
				}, 500, "easeInCubic");
			}
			fontListIsShown = true;
		}else{
			$("#fontList").slideUp(250);
			fontListIsShown = false;
		}
	});
	
	function centerCurrentImg(){
		var imgWidth = $("#currentImg").width();
		var imgHeight = $("#currentImg").height();
		
		if (imgWidth < deviceWidth){
			var leftMargin = (deviceWidth-imgWidth) / 2;
			$("#currentImg").css("margin-left", leftMargin);
		}
		else
		{
			$("#currentImg").css("margin-left", 0);
		}
		
		if (imgHeight < deviceHeight){
			var topMargin = (deviceHeight-imgHeight) / 2;
			$("#currentImg").css("margin-top", topMargin);
		}
		else
		{
			$("#currentImg").css("margin-top", 0);
		}
	}
	
	function showMenu(){
		$("#menu").show();
		$("#menu").animate({"right": 0}, 250);
	}
	
	function hideMenu(){
		$("#menu").animate({"right": "-7em"}, 250);
		$("#menu").hide(250);
	}
	
	/* 
	 * NO PARAMS
	 * 1. use DeviceStorage cursor to create blobs with image data from the Gallery and aborts smoothly
	 * 2. updates DOM -- appends invisible thumbnails to #thumbnailList
	 * 3. attach vclick event handler -- a .thumbnail vclick will place image in #picWindow
	 * 4. iterate through each thumbnail, making it visible when it is loaded
	 
	function loadThumbnails(){
		var files = navigator.getDeviceStorage("pictures");

		var cursor = files.enumerate();
		var i = 0;
		
		cursor.onsuccess = function(){
			var file = this.result;
			if (file != null)
			{
				$("#thumbnailList").append("<div class='thumbnail' id='pic" + i + "'><img id='pic" + i + "' src='" + URL.createObjectURL(file) + "'></div>");
				i++;
				this.done = false;
			}
			else
			{
				this.done = true;
			}// if
			if (!this.done) // more files to enumerate
			{
				this.continue();
			} // if
			else // all images loaded
			{
				// vclick event handler: a .thumbnail vclick will place its image in #picWindow
				$(".thumbnail").on("vclick", function(){
					$("#finish").slideDown(250);
					$("#toggleThumbnails").trigger("vclick");
					depressButton($("#toggleThumbnails"));
					$("body").css({"background": "black", "background-image": "none"});
					var selector = "#" + $(this).attr("id") + " img";
					var imageURL = $(selector).attr("src");
					$("#currentImg").replaceWith("<img id='currentImg' src='" + imageURL + "'>");
					$("#currentImg").show();
					var naturalImg = document.getElementById("currentImg");
					deviceWidth = $(window).width();
					deviceHeight = $(window).height();
					if (deviceWidth > deviceHeight)// landscape
					{
						var maxWidth = deviceHeight/naturalImg.naturalHeight*naturalImg.naturalWidth;
						$("#currentImg").css({"max-height": deviceHeight, "max-width": maxWidth});
					}
					else //portrait
					{
						var maxHeight = deviceWidth/naturalImg.naturalWidth*naturalImg.naturalHeight;
						$("#currentImg").css({"max-width": deviceWidth, "max-height": maxHeight});
					}
					centerCurrentImg();
				}); // .thumbnail vclick handler
			} // else
		}; // cursor.onsuccess function
		
	} // loadThumbnails method
	
	/* vclick event handler: a #refreshThumbnails vclick will:
	 * 1. show the #thumbnailButtons
	 * 2. empty the #thumbnailList element
	 * 3. call the loadThumbnails method
	 */
	
	
}); // document ready handler
