require("jsb.js");
require("Constants.js");
require("main/book/controller/BookController.js");
require("main/book/model/BookModel.js");
require("main/book/model/BookPageModel.js");
require("main/book/model/BookCoverModel.js")
require("main/book/view/BookPageTextView.js");
require("main/book/view/BookPageView.js");
require("main/book/view/BookCoverView.js");
require("main/book/view/BookLastPageView.js");
require("main/book/view/BookPageNavigationView.js");
require("main/book/view/widget/PageThumbView.js");
require("main/book/view/widget/PageNavigationScrollView.js");

require("main/bookshelf/controller/BookshelfController.js");
require("main/bookshelf/view/MenuView.js");
require("main/bookshelf/view/UserSettingsView.js");
require("main/bookshelf/view/LoginView.js");
require('main/bookshelf/view/PrivacyView.js');
require('main/bookshelf/view/AboutView.js');
require('main/bookshelf/view/LibraryView.js');
require('main/bookshelf/view/SupportView.js');
require('main/bookshelf/view/AlertView.js');
require('main/bookshelf/view/BookLanguageListView.js');
require('main/bookshelf/view/BackgroundView.js');

require("main/utils/async.js");
require("main/utils/Base64.js");
require("main/utils/CMCC.js");
require("main/utils/Device.js");
require("main/bookshelf/model/BookshelfModel.js");
require("main/bookshelf/model/UserModel.js");
require("main/bookshelf/model/DownloadBookModel.js");


require('main/map/layer/StoryCategory.js');
require('main/map/layer/ClassicMap.js');
require('main/map/layer/ActionMap.js');
require('main/map/layer/AdventureMap.js');
require('main/map/layer/AnimalMap.js');
require('main/map/layer/FairytaleMap.js');
require('main/map/layer/FamilyMap.js');
require('main/map/layer/FriendshipMap.js');
require('main/map/layer/HistoryMap.js');
require('main/map/layer/LessonMap.js');

require('main/map/controller/StoryMapController.js');

require("main/utils/Utils.js");
require("main/loaders/Loader.js");
require("main/loaders/BookDataLoaderLayer.js");
require("main/loaders/BookCoverLoader.js");
require("main/loaders/PageDataLoaderBlock.js");
require("MainScene.js");

function main() {
    cc.FileUtils.getInstance().loadFilenameLookup("fileLookup.plist");
    //cc.Texture2D.setDefaultAlphaPixelFormat(6);   

    var director = cc.Director.getInstance();
    director.setDisplayStats(false);

    var scene = new MainScene();
    var runningScene = director.getRunningScene();
    if (runningScene === null) director.runWithScene(scene);
    else director.replaceScene(scene);
}