var coloringInit = function () {
    var screenHeight = $(window).height();
    var screenWidth = $(window).width();
    var colorChoosen = "#000000";
    var randomColor = utils.getRandomColor();
    var isChanged = false;
    var $LeftToolbar2 = $(".LeftToolbar");
    var $random = $("#random");
    var $choosedIcon = $("#chose_icon");
    utils.generateColorTubes($LeftToolbar2);
    var $LeftToolbar = $LeftToolbar2.find("li");

    $("#content").css("width", screenWidth).css("height", screenHeight);
    {
        document.getElementById("soundImg").src = b_music ? "res/icons/ic_sound_on.png" : "res/icons/ic_sound_off.png";
        AddBgImg($random);
        var leftLiWidth = $("#Left").width();
        var leftItemH = Math.round(screenHeight * 0.16);
        $choosedIcon.css("background-color", randomColor);
        $("#rightId").css('height', screenHeight);
        $(".RightToolbar").css('height', screenHeight);
        $("#leftId").css('height', screenHeight);
        $(".LeftIcon").css("height", leftItemH + "px");
        $(".LeftTools").css("height", screenHeight);
        $LeftToolbar.css("height", leftItemH + "px").css("width", leftLiWidth);
        $("#tubeItems").css("height", screenHeight);
    }

    $("#ic_save").on("vclick",function () {
        var svgXml = new XMLSerializer().serializeToString($("svg")[0]);
        var cvs = document.getElementById("canvas");
        canvg(cvs, svgXml);
        utils.SaveCanvasToFile(cvs);
    }).on("vmousedown",function () {
            AddBgImg(this);
        }).on("vmouseup", function () {
            RemoveBgImg(this);
        });

    $("#yes").on("vclick", function (e) {
        e.preventDefault();
        playClickTrack(b_music);
        $('#svg1').find('path[class="colorable"]').css("fill", "#FFFFFF");
        isChanged = false;
        $("#clear-popupColoring").popup("close");
    });
    $("#no").on("vclick", function (e) {
        e.preventDefault();
        playClickTrack(b_music);
        $("#clear-popupColoring").popup("close");
    });

    $("#ic_trash").on("vclick",function (e) {
        e.preventDefault();
        playClickTrack(b_music);
        if (isChanged) {
            $("#clear-popupColoring").popup("open");
        }
    }).on("vmousedown",function () {
            AddBgImg(this);
        }).on("vmouseup", function () {
            RemoveBgImg(this);
        });

    var b_randomColor = true;
    $random.on("vclick", function () {
        playClickTrack(b_music);
        b_randomColor = !b_randomColor;
        randomColor = utils.getRandomColor();
        colorChoosen = randomColor;
        $choosedIcon.css("background-color", colorChoosen);
        b_randomColor ? AddBgImg(this) : RemoveBgImg(this);
    });

    $("#ic_sound_on").on("vclick",function () {
        b_music = !b_music;
        playClickTrack(b_music);
        playMainTrack(b_music);
        document.getElementById("soundImg").src = b_music ? "res/icons/ic_sound_on.png" : "res/icons/ic_sound_off.png";
    }).on("vmousedown",function () {
            AddBgImg(this);
        }).on("vmouseup", function () {
            RemoveBgImg(this);
        });
    var $svg2;

    var coloring = {
        fill: function (id) {
            isChanged = true;
            if (b_randomColor) {
                colorChoosen = randomColor;
                randomColor = utils.getRandomColor();
                this.choosedIcon.style.backgroundColor = randomColor;
            }
            var node = this.svg1.querySelector("#" + id);
            if (node != null) {
                node.style.fill = colorChoosen;
            }
            playBrushTrack(b_music);
        },
        svg1: null,
        choosedIcon: document.getElementById("chose_icon")
    };

    function attachEvents() {
        coloring.svg1 = document.querySelector("#svg1");
        $('#svg2').on("vclick", function (e) {
            coloring.fill(e.target.id);
        });
    }

    $("#ic_arrow").on("vclick",function () {
        getNextSVG();
    }).on("vmousedown",function () {
            AddBgImg(this);
        }).on("vmouseup", function () {
            RemoveBgImg(this);
        });

    var tubeMousePressed = false;
    var pressedTube;
    $LeftToolbar.on("vclick",function (e) {
        b_randomColor = false;
        RemoveBgImg($random);
        var $img = $("img", e.currentTarget);
        colorChoosen = $img[0].style.backgroundColor;
        $choosedIcon.css("background-color", colorChoosen);
        playColorSelectTrack(b_music);
    }).on("vmousedown",function (e) {
            setTimeout(function () {
                pressedTube = e.currentTarget;
                var $img = $("img", pressedTube);
                tubeMousePressed = true;
                $img[0].src = "res/icons/tube_tint_p.png";
                $img[1].src = "res/icons/tube_mask_p.png";
                playColorSelectTrack(b_music);
            }, 0)
        }).on("vmouseup vmousemove", function () {
            if (tubeMousePressed) {
                setTimeout(function () {
                    var $img = $("img", pressedTube);
                    $img[0].src = "res/icons/tube_tint_np.png";
                    $img[1].src = "res/icons/tube_mask_np.png";
                }, 0);
                tubeMousePressed = false;
            }
        });

    var index = window.imageList.indexOf(window.selectedImage) - 1;

    var ajaxRequestInProgress = false;

    function getNextSVG() {
        if (ajaxRequestInProgress) return;
        ajaxRequestInProgress = true;
        var url = window.dataSource + window.imageList[(++index) % (window.imageList.length)].replace('.jpg', '.svg');
        $.ajax({
            url: url,
            type: "POST",
            success: function (data) {
                $("svg").remove();
                var svg = $(data).contents().filter("svg")[0];
                var elementById = document.getElementById("contextColoring");
                svg.id = "svg1";
                elementById.appendChild(svg);
                setTimeout(function () {
                    var newChild = svg.cloneNode(true);
                    newChild.id = "svg2";
                    elementById.appendChild(newChild);
                    $svg2 = $("#svg2");
                    $svg2.find("path[class!='colorable']").remove();
                    $svg2.find('path').css("fill", "rgba(0,0,0,0)");
                    $svg2.css("left", screenWidth * 0.1);
                    attachEvents();
                    ajaxRequestInProgress = false;
                }, 0);
            },
            error: function (txt) {
                ajaxRequestInProgress = false;
            }
        });
    }

    getNextSVG();
};
$(document).on("pagebeforeshow", "#coloringPage", coloringInit);
