var screenHeight;
var jqCanvas;
var backgroundFunction;
var bGImgSrc;
var imageObj;
var theCanvas;
var context;
var bgCanvas;
var bgContext;
var canvas3;
var context3;
var canvas4;
var context4;
var canvasW;
var canvasH;
var index;


var drawBackGraundImage = function () {
    imageObj.onload = function () {
        bgContext.drawImage(imageObj, 0, 0, canvasW, canvasH);
        changeBGImgIndex();
    };
    imageObj.src = bGImgSrc;
};

var changeBackGraundColor = function () {
    bgContext.fillStyle = utils.getRandomColor();
    bgContext.fillRect(0, 0, canvasW, canvasH);
};


function changeBGImgIndex() {
    index = ++index % (window.imageList.length - 1) + 1;
    bGImgSrc = window.dataSource + window.imageList[index] + "_big";
}

var initDrawingPageBeforShow = function () {
    imageObj = new Image();
    screenHeight = $(window).height();
    jqCanvas = $("#canvas");
    bGImgSrc = window.bgImgSrc + "_big";
    jqCanvas.css("width", $(window).width() * 0.8);
    jqCanvas.css("height", screenHeight);
    $("#bgcanvas").css("height", screenHeight);
    $("#canvas3").css("height", screenHeight);
    $("#canvas4").css("height", screenHeight);

    theCanvas = document.getElementById('canvas');
    context = theCanvas.getContext('2d');
    bgCanvas = document.getElementById('bgcanvas');
    bgContext = bgCanvas.getContext('2d');
    canvas3 = document.getElementById('canvas3');
    context3 = canvas3.getContext('2d');
    canvas4 = document.getElementById('canvas4');
    context4 = canvas4.getContext('2d');
    canvasW = jqCanvas.width();
    canvasH = jqCanvas.height();

    theCanvas.width = bgCanvas.width = canvas3.width = canvas4.width = canvasW;
    theCanvas.height = bgCanvas.height = canvas3.height = canvas4.height = canvasH;

    var $LeftToolbar = $(".LeftToolbar");
    utils.generateColorTubes($LeftToolbar);
    document.getElementById("soundImg").src = b_music ? "res/icons/ic_sound_on.png" : "res/icons/ic_sound_off.png";
    var leftItemH = Math.round(screenHeight * 0.16);
    $("#rightId").css('height', screenHeight);
    $(".RightToolbar").find("li").css("height", screenHeight / 7);
    $("#leftId").css('height', screenHeight);
    $(".LeftIcon").css("height", leftItemH + "px");
    $(".LeftTools").css("height", screenHeight - leftItemH);
    $LeftToolbar.find('li').css("height", leftItemH + "px").css("width", $("#Left").width());

    if (window.IsCanvasSelected) {
        backgroundFunction = changeBackGraundColor;
        document.getElementById("arrowImg").src = "res/icons/ic_bg.png";
    }
    else {
        backgroundFunction = drawBackGraundImage;
        document.getElementById("arrowImg").src = "res/icons/ic_arrow.png";
    }
    index = parseInt(bGImgSrc.replace(/[^\d.]/g, ''));
    backgroundFunction();
  //  utils.backButtonShow();
};

var initDrawingPage = function () {
    var isChanged = false;

    var randomColor = "rgb(0,0,0)";
    var mousePressed = false;
    var selectedBrush;
    var brushWidth = [ 10, 20, 30 ];
    var brushOptions = {
        width: brushWidth[1],
        color: randomColor
    };

    function random(min, max) {
        return Math.floor(Math.random() * (max - min + 1) + min);
    }


    var deleteCanvas = function (context) {
        context.clearRect(0, 0, canvasW, canvasH)
    };

    var colorRGB = function (color) {
        var r = parseInt(color[1] + color[2], 16);
        var g = parseInt(color[3] + color[4], 16);
        var b = parseInt(color[3] + color[4], 16);
        return 'rgb(' + r + ',' + g + ',' + b + ')';
    };

    var rgba = function (color, alpha) {
        var str = "," + alpha + ")";
        str = color.replace(")", str);
        str = str.replace("rgb", "rgba");
        return str;
    };



    function save() {
        bgContext.drawImage(theCanvas, 0, 0);
        deleteCanvas(context);
        utils.SaveCanvasToFile(bgCanvas);
        isChanged = false;
    }

    function copyContext(fromCanvas, toContext, cb) {
        imageObj.onload = function () {
            toContext.drawImage(imageObj, 0, 0, canvasW, canvasH);
            if (cb != undefined) {
                cb();
            }
        };
        imageObj.src = fromCanvas.toDataURL();
    }


    function TubeMouseDownHandler(element) {
        $("img", element)[0].src = "res/icons/tube_tint_p.png";
        $("img", element)[1].src = "res/icons/tube_mask_p.png";
        $("#chose_icon").css("background-color",
            $("img", element)[0].style.backgroundColor);
        playColorSelectTrack(b_music);
        brushOptions.color = $("img", element)[0].style.backgroundColor;
        RemoveBgImg($("#random"));
        selectedBrush = lineBrush;
        selectedBrush.init();
        randomBrush = false;
    }


    function TubeMouseUpHandler(element) {
        $("img", element)[0].src = "res/icons/tube_tint_np.png";
        $("img", element)[1].src = "res/icons/tube_mask_np.png";
    }

    $(".LeftToolbar li").on("vmousedown",function () {
        TubeMouseDownHandler(this);
    }).on("vmouseup vmousemove", function () {
            TubeMouseUpHandler(this);
        });


    var BrushDelet = {
        init: function () {

        },
        drawStart: function () {
            context.lineJoin = context.lineCap = 'round';
            context.lineWidth = brushOptions.width;
            context.globalCompositeOperation = "destination-out";
            context.beginPath();
            context.moveTo(StartEventPosition.x, StartEventPosition.y);
            context.lineTo(StartEventPosition.x + 1, StartEventPosition.y + 1);
            context.stroke();
        },
        draw: function (brushOptions) {
            context.lineTo(PreviousEventPosition.x, PreviousEventPosition.y);
            context.stroke();
        },
        endDraw: function () {
            context.closePath();
            context.globalCompositeOperation = "source-over";
        }
    };


    var RainbowBrush = {
        init: function () {

        },
        drawStart: function () {
            this.color = (this.color + 2) % 360;
            context.lineWidth = brushOptions.width;
            context.lineJoin = context.lineCap = 'round';
            context.strokeStyle = 'hsl(' + this.color + ', 100%, 50%)';
            context.beginPath();
            context.moveTo(StartEventPosition.x, StartEventPosition.y);
            context.lineTo(StartEventPosition.x + 1, StartEventPosition.y + 1);
            context.closePath();
            context.stroke();
        },
        draw: function (brushOptions) {
            this.color = (this.color + 2) % 360;
            context.strokeStyle = 'hsl(' + this.color + ', 100%, 50%)';
            context.beginPath();
            context.moveTo(CurrentMoveEventPosition.x, CurrentMoveEventPosition.y);
            context.lineTo(PreviousEventPosition.x, PreviousEventPosition.y);
            context.closePath();
            context.stroke();
        },
        endDraw: function () {

        },
        color: 0
    };


    var candyBrush = {
        init: function () {

        },
        drawStart: function () {
            context.lineWidth = 1;
            this.starSize = Math.floor(this.random() * 6) + (brushOptions.width / 2);
            context.save();
            context.beginPath();
            context.strokeStyle = randomHSLColor(rgbToHsl(brushOptions.color));
            context.translate(StartEventPosition.x, StartEventPosition.y);
            context.moveTo(0, 0 - this.starSize);
            for (var i = this.angleCount; i--;) {
                context.rotate(this.mathPi / this.angleCount);
                context.lineTo(0, 0 - (this.starSize * this.m));
                context.rotate(this.mathPi / this.angleCount);
                context.lineTo(0, 0 - this.starSize);
            }
            context.stroke();
            context.closePath();
            context.restore();
        },
        draw: function (brushOptions) {
            this.starSize = Math.floor(this.random() * 6) + (brushOptions.width / 2);
            this.deltaX = 10 - (this.floor(this.random() * 25) + 1);
            this.deltaX = 10 - (this.floor(this.random() * 25) + 1);
            context.save();
            context.beginPath();
            context.strokeStyle = randomHSLColor(rgbToHsl(brushOptions.color));
            context.translate(CurrentMoveEventPosition.x + this.deltaX, CurrentMoveEventPosition.y + this.deltaX);
            context.moveTo(0, 0 - this.starSize);
            for (var i = this.angleCount; i--;) {
                context.rotate(this.mathPi / this.angleCount);
                context.lineTo(0, 0 - (this.starSize * this.m));
                context.rotate(this.mathPi / this.angleCount);
                context.lineTo(0, 0 - this.starSize);
            }
            context.stroke();
            context.closePath();
            context.restore();
        },
        endDraw: function () {

        },
        angleCount: 5,
        m: 0.5,
        starSize: 0,
        deltaX: 0,
        deltaY: 0,
        random: Math.random,
        floor: Math.floor,
        mathPi: Math.PI
    };

    function randomHSLColor(hslColorArr) {
        var h = hslColorArr[0] + (10 - (Math.floor(Math.random() * 60) + 1));
        if (h < 0) {
            h = 0;
        }
        if (h > 360) {
            h = 360;
        }
        return "hsl(" + h + "," + hslColorArr[1] + "%," + hslColorArr[2] + "%)";
    }

    function rgbToHsl(rgbColor) {
        if (rgbColor[0] == "#") {
            rgbColor = colorRGB(rgbColor);
        }
        var spl = rgbColor.split(",");
        var spl1 = spl[0].split("(");
        var spl2 = spl[2].split(")");
        var r = parseInt(spl1[1], 10);
        var g = parseInt(spl[1], 10);
        var b = parseInt(spl2[0], 10);
        r /= 255;
        g /= 255;
        b /= 255;
        var max = Math.max(r, g, b), min = Math.min(r, g, b);
        var h, s, l = (max + min) / 2;
        if (max == min) {
            h = s = 0;
        }
        else {
            var d = max - min;
            s = l > 0.5 ? d / (2 - max - min) : d / (max + min);
            switch (max) {
                case r:
                    h = (g - b) / d + (g < b ? 6 : 0);
                    break;
                case g:
                    h = (b - r) / d + 2;
                    break;
                case b:
                    h = (r - g) / d + 4;
                    break;
            }
            h /= 6;
        }
        return [Math.floor(h * 360), Math.floor(s * 100), Math.floor(l * 100)];
    }

    var lineBrush = {
        init: function () {

        },
        drawStart: function () {
            context.lineJoin = context.lineCap = 'round';
            context.lineWidth = brushOptions.width;
            context.strokeStyle = brushOptions.color;
            context.beginPath();
            context.moveTo(StartEventPosition.x, StartEventPosition.y);
            context.lineTo(StartEventPosition.x + 1, StartEventPosition.y + 1);
            context.stroke();
        },
        draw: function (brushOptions) {
            context.lineTo(PreviousEventPosition.x, PreviousEventPosition.y);
            context.stroke();
        },
        endDraw: function () {
            context.closePath();
        }
    };

    var opacityBrush = {
        init: function () {

        },
        drawStart: function () {

            context3.lineJoin = context3.lineCap = 'round';
            context3.globalCompositeOperation = "copy";
            context3.lineWidth = brushOptions.width;
            context3.strokeStyle = rgba(brushOptions.color, 0.5);
            context3.beginPath();
            context3.moveTo(StartEventPosition.x, StartEventPosition.y);
            context3.lineTo(StartEventPosition.x + 1, StartEventPosition.y + 1);
            context3.stroke();
        },
        draw: function (brushOptions) {
            context3.lineTo(PreviousEventPosition.x, PreviousEventPosition.y);
            context3.stroke();
        },
        endDraw: function () {
            context3.closePath();
            context3.globalCompositeOperation = "source-over";
            copyContext(canvas3, context);
            deleteCanvas(context3);
        }
    };

    var opacityAndLineBrush = {
        init: function () {

        },
        drawStart: function () {
            context3.lineWidth = brushOptions.width;
            context3.lineJoin = context3.lineCap = 'round';
            context3.globalCompositeOperation = "copy";
            context3.strokeStyle = rgba(brushOptions.color, 0.5);
            context3.beginPath();
            context3.moveTo(StartEventPosition.x, StartEventPosition.y);
            context3.lineTo(StartEventPosition.x + 1, StartEventPosition.y + 1);
            context3.stroke();
            context4.lineJoin = context4.lineCap = 'round';
            context4.lineWidth = brushOptions.width / 4;
            context4.strokeStyle = "rgb(255,255,255)";
            context4.beginPath();
            context4.moveTo(StartEventPosition.x, StartEventPosition.y);
            context4.lineTo(StartEventPosition.x + 1, StartEventPosition.y + 1);
            context4.stroke();
        },
        draw: function (brushOptions) {
            context3.lineTo(PreviousEventPosition.x, PreviousEventPosition.y);
            context3.stroke();
            context4.lineTo(PreviousEventPosition.x, PreviousEventPosition.y);
            context4.stroke();
        },
        endDraw: function () {
            context3.closePath();
            context4.closePath();
            context3.globalCompositeOperation = "source-over";
            var cb = function () {
                deleteCanvas(context3);
                copyContext(canvas4, context);
                deleteCanvas(context4);
            };
            copyContext(canvas3, context, cb);
        }
    };

    var circleBrush = {
        init: function () {

        },
        drawStart: function () {
            this.color = (this.color + 2) % 360;
            context.lineJoin = context.lineCap = 'round';
            context.fillStyle = 'hsl(' + this.color + ', 100%, 50%)';
            context.lineWidth = 0;
            context.beginPath();
            context.arc(StartEventPosition.x, StartEventPosition.y, this.minRadius, 0, 2 * this.mathPi);
            context.fill();
            context.closePath();
        },
        draw: function (brushOptions) {
            this.color = (this.color + 2) % 360;
            var deltaX = this.abs(PreviousEventPosition.x - CurrentMoveEventPosition.x);
            var deltaY = this.abs(PreviousEventPosition.y - CurrentMoveEventPosition.y);
            var delta = this.sqrt(deltaX * deltaX + deltaY * deltaY);
            var R = this.minRadius;
            if (R < (brushOptions.width * delta) / 50) {
                R = this.floor((brushOptions.width * delta) / 50);
            }
            if ((this.prevVertexRadius + R) / (brushOptions.width / 10) < delta || true) {
                context.lineJoin = context.lineCap = 'round';
                context.lineWidth = 0;
                context.fillStyle = 'hsl(' + this.color + ', 100%, 50%)';
                context.beginPath();
                context.arc(CurrentMoveEventPosition.x, CurrentMoveEventPosition.y, R, 0, 2 * this.mathPi);
                context.fill();
                context.closePath();
            }
            this.prevVertexRadius = R;
        },
        endDraw: function () {

        },
        lastCircleX: undefined,
        lastCircleY: undefined,
        mathPi: Math.PI,
        color: 0,
        prevVertexRadius: 4,
        abs: Math.abs,
        floor: Math.floor,
        sqrt: Math.sqrt,
        minRadius: 6,
        minimumRadius: 4
    };

    var point = function (x, y) {
        return {
            x: x,
            y: y
        };
    };

    var StartEventPosition;
    var PreviousEventPosition;
    var CurrentMoveEventPosition;

    var brushList = [ lineBrush, opacityBrush, opacityAndLineBrush, RainbowBrush, candyBrush, circleBrush];
    var randomBrush = true;

    function mouseDown(e) {
        playBrushTrack(b_music);
        StartEventPosition = GetEventPositionOnCanvas(e);
        CurrentMoveEventPosition = point(StartEventPosition.x, StartEventPosition.y);
        mousePressed = true;

        if (randomBrush) {
            selectedBrush = brushList[random(0, brushList.length - 1)];
            brushOptions.color = randomColor;
            randomColor = colorRGB(utils.getRandomColor());
            brushOptions.width = brushWidth[random(0, brushWidth.length - 1)];
            $("#chose_icon").css("background-color", randomColor);
        }
        selectedBrush.drawStart();
    }

    function mouseUp() {
        CurrentMoveEventPosition = PreviousEventPosition = StartEventPosition = null;
        mousePressed = false;
        selectedBrush.endDraw();
    }

    function GetEventPositionOnCanvas(e) {
        var touches = e.touches;//|| event.touches;
        if (touches) return point(touches[0].pageX - canvas.offsetLeft, touches[0].pageY - canvas.offsetTop);
        return point(e.pageX - canvas.offsetLeft, e.pageY - canvas.offsetTop);
    }

    function mouseMove(e) {
        if (!mousePressed) return;
        PreviousEventPosition = CurrentMoveEventPosition;
        CurrentMoveEventPosition = GetEventPositionOnCanvas(e);
        selectedBrush.draw(brushOptions);
        isChanged = true;
    }

    var events = function () {
        $("#canvas4").on("vmousedown",function (e) {
            mouseDown(e);
        }).on("vmousemove",function (e) {
                mouseMove(e);
            }).on("vmouseup", function () {
                mouseUp();
            });

        $("#eraser").on("vclick", function () {
            playClickTrack(b_music);
            AddBgImg(this);
            randomBrush = false;
            RemoveBgImg($("#brush"));
            RemoveBgImg($("#random"));
            selectedBrush = BrushDelet;
        });

        $("#arrow").on("vclick",function (e) {
            e.preventDefault();
            playClickTrack(b_music);
            deleteCanvas(context);
            deleteCanvas(context3);
            deleteCanvas(context4);
            isChanged = false;
            backgroundFunction();
        }).on("vmousedown",function () {
                AddBgImg(this);
            }).on("vmouseup", function () {
                RemoveBgImg(this);
            });

        $("#sound").on("vclick",function () {
            window.b_music = !window.b_music;
            if (b_music) {
                document.getElementById("soundImg").src = "res/icons/ic_sound_on.png";

            } else {
                document.getElementById("soundImg").src = "res/icons/ic_sound_off.png";
            }
            playClickTrack(b_music);
            playMainTrack(b_music);
        }).on("vmousedown",function () {
                AddBgImg(this);
            }).on("vmouseup", function () {
                RemoveBgImg(this);
            });

        $("#brush").on("tap", function (e) {
            e.preventDefault();
            playClickTrack(b_music);
            $("#BrushesPopup").popup("open");
        });

        $("#random").on("vclick", function () {
            playClickTrack(b_music);
            randomBrush = !randomBrush;
            if (randomBrush) {
                AddBgImg(this);
                AddBgImg($("#brush"));
                RemoveBgImg($("#eraser"));
            } else {
                RemoveBgImg(this);
            }
        });
        $("#save").on("vclick",function (e) {
            e.preventDefault();
            playClickTrack(b_music);
            save();
        }).on("vmousedown",function () {
                AddBgImg(this);
            }).on("vmouseup", function () {
                RemoveBgImg(this);
            });


        $("#stroke_circles").on("vclick", function (e) {
            e.preventDefault();
            playClickTrack(b_music);
            RemoveBgImg($("#random"));
            selectedBrush = circleBrush;
            selectedBrush.init();
            randomBrush = false;
        });

        $("#stroke_candy").on("vclick", function (e) {
            e.preventDefault();
            playClickTrack(b_music);
            RemoveBgImg($("#random"));
            selectedBrush = candyBrush;
            selectedBrush.init();
            randomBrush = false;
        });

        $("#stroke_rainbow").on("vclick", function (e) {
            e.preventDefault();
            playClickTrack(b_music);
            RemoveBgImg($("#random"));
            selectedBrush = RainbowBrush;
            selectedBrush.init();
            randomBrush = false;
        });

        $("#stroke_neon").on("vclick", function (e) {
            e.preventDefault();
            playClickTrack(b_music);
            RemoveBgImg($("#random"));
            selectedBrush = opacityAndLineBrush;
            selectedBrush.init();
            randomBrush = false;
        });

        $("#stroke_marker").on("vclick", function (e) {
            e.preventDefault();
            playClickTrack(b_music);
            RemoveBgImg($("#random"));
            selectedBrush = lineBrush;
            selectedBrush.init();
            randomBrush = false;
        });

        $("#stroke_blur").on("vclick", function (e) {
            e.preventDefault();
            playClickTrack(b_music);
            RemoveBgImg($("#random"));
            selectedBrush = opacityBrush;
            selectedBrush.init();
            randomBrush = false;
        });

        $(".brushes").each(function () {
            $(this).on("vclick", function (e) {
                e.preventDefault();
                AddBgImg($("#brush"));
                RemoveBgImg($("#eraser"));
            });
        });


        var clear_popup = document.getElementById("clear-popup");
        clear_popup.style.width = window.innerWidth * 0.7 + 'px';
        clear_popup.style.height = window.innerHeight * 0.9 + 'px';

        $("#brush_ghost2").addClass('selected_gh');
        $(".ghosts").on("vclick", function (e) {
            e.preventDefault();
            $(this).addClass('selected_gh');
            $(".ghosts").not($(this)).removeClass('selected_gh');
            $("#BrushesPopup").popup("close");
        });

        $("#stroke_marker").addClass('selected_br');
        $(".brushes").on("vclick", function () {
            $(this).addClass('selected_br');
            $(".brushes").not($(this)).removeClass('selected_br');
            $("#BrushesPopup").popup("close");
        });


        $("#closeIcon").on("vclick", function(e){
            e.preventDefault();
            $("#clear-popup").popup("close");
        });
        $("#yes").on("vclick", function (e) {
            e.preventDefault();
            playClickTrack(b_music);
            deleteCanvas(context);
            deleteCanvas(context3);
            deleteCanvas(context4);
            isChanged = false;
            $("#clear-popup").popup("close");
        });
        $("#no").on("vclick", function (e) {
            e.preventDefault();
            playClickTrack(b_music);
            $("#clear-popup").popup("close");
        });

        $("#trash").on("vclick",function (e) {
            e.preventDefault();
            playClickTrack(b_music);
            if (isChanged) {
                $("#clear-popup").popup("open");
            }
        }).on("vmousedown",function () {
                AddBgImg(this);
            }).on("vmouseup", function () {
                RemoveBgImg(this);
            });


        $("#brush_ghost1").on("vclick", function () {
            playClickTrack(b_music);
            brushOptions.width = brushWidth[2];
            circleBrush.minRadius = circleBrush.minimumRadius * brushOptions.width / brushWidth[0];
        });
        $("#brush_ghost2").on("vclick", function () {
            playClickTrack(b_music);
            brushOptions.width = brushWidth[1];
            circleBrush.minRadius = circleBrush.minimumRadius * brushOptions.width / brushWidth[0];
        });
        $("#brush_ghost3").on("vclick", function () {
            playClickTrack(b_music);
            brushOptions.width = brushWidth[0];
            circleBrush.minRadius = circleBrush.minimumRadius * brushOptions.width / brushWidth[0];
        });
    };
    events();

};
$(document).on("pagebeforeshow", "#pageDrawing", initDrawingPageBeforShow);
$(document).on("pageshow", "#pageDrawing", initDrawingPage);
