var initImgList = function () {
    var drawImgList = function (callback) {
        var src = window.dataSource;
        var drawImagesArray = window.imageList;
        var y = (src == null);
        var m = $(document.createElement("div"));
        var x;
        for (var i = 0, max = drawImagesArray.length; i < max; i++) {
            x = '<div class = "ImgDiv"><div class="transparentDiv"></div><img class="imgListImg" src="' + (y ? drawImagesArray[i] : src + drawImagesArray[i]) + '"/></div>';
            m.append(x);
        }
        $("#contentDivImgList").append(m);
        callback && callback();
    };

    if (window.toPage == "drawing" || window.toPage == "learning") {
        drawImgList();
        var blank = $("#imgListContent").find('img:first').attr("src");
        var ImageMouseDownHandler = function (selectedItem) {
            selectedItem.parentNode.childNodes[0].style.display = "block";
            hided = false;
            var source = selectedItem.src;
            if (source == blank) {
                window.IsCanvasSelected = true;
            } else {
                window.IsCanvasSelected = false;
                window.bgImgSrc = source;
            }
        };

        var ImageMouseUpHandler = function (selectedItem) {
            selectedItem.parentNode.childNodes[0].style.display = "none";
            hided = false;
            $.mobile.changePage("drawing.html", {
                transition: "none"
            });
        };

        var mousePressed = false;
        $(".imgListImg").on("click", function (e) {
            e.preventDefault();
           ImageMouseUpHandler(this);
        });
        $(".imgListImg").on("vmousedown", function (e) {
            mousePressed = true;
            ImageMouseDownHandler(this);
        });
        $(".transparentDiv").on("vmouseup", function () {
            mousePressed = false;
            ImageMouseUpHandler(this);
        });
        var hided = false;
        $("#ImgList").on("vmousemove", function () {
            if (mousePressed && !hided) {
                hided = true;
                $(".transparentDiv").hide();
            }
        });
    } else if (window.toPage == "coloring") {
        drawImgList();
        ImageMouseDownHandler = function (selectedItem) {
            selectedItem.parentNode.childNodes[0].style.display = "block";
            hided = false;
        };

        ImageMouseUpHandler = function (selectedItem) {
            selectedItem.parentNode.childNodes[0].style.display = "none";
            hided = false;
            window.selectedImage = selectedImg;
            $.mobile.changePage("coloring.html", {
                transition: "none"
            });
        };
        var selectedImg;
        mousePressed = false;
        $(".imgListImg").on("tap", function (e) {
            e.preventDefault();
            ImageMouseUpHandler(this);
        });
        $(".imgListImg").on("vmousedown", function () {
            selectedImg = this.src.split("/").pop();
            mousePressed = true;
            ImageMouseDownHandler(this);
        });
        $(".transparentDiv").on("vmouseup", function () {
            mousePressed = false;
            ImageMouseUpHandler(this);
        });
        $(".transparentDiv").on("tap", function (e) {
            e.preventDefault();
            ImageMouseUpHandler(this);
        });
        hided = false;
        $("#ImgList").on("vmousemove", function () {
            if (mousePressed && !hided) {
                hided = true;
                $(".transparentDiv").hide();
            }
        });
    } else if (window.toPage == "gallery") {
        utils.getFileList(function(){
            drawImgList(function(){
                $("#imageViewClose").on("click", function(e){
                    $("#imageViewContent").css({"display":"none"});
                })
                $(".imgListImg").on("click", function (e) {
                    e.preventDefault();
                    $("#imageViewContent").css({"display":"block"});
                    $("#imageView").attr('src', "" + this.src);
                });
            })
        });

    }
};
$(document).on("pagebeforeshow", "#ImgList", initImgList);
