var utils = {
    generateColorTubes: function (domElement) {
        var container = document.createElement("div");
        var m = $(document.createElement("div"));
        for (var i = 0, max = this.tubeColorsArray.length; i < max; i++) {
            var s = '<li><img class="underTubePos tubeSize" src="./res/icons/tube_tint_np.png" style="background-color: '
                    + this.tubeColorsArray[i]
                 + '";'
                   + ' /><img class="topTubePos" src="./res/icons/tube_mask_np.png"  /></li>';
           m.append(s);
            if(i==7)
            {
                $(domElement).append(m);
            }
      }
        $(domElement).append(m);
    },
    tubeColorsArray: [ "#FF0013", "#FED307", "#58E80C", "#226CFF", "#8601AF",
        "#FFFFFF", "#000000", "#FF8080", "#FF4747", "#FF0000", "#9C0000",
        "#FFC880", "#FFAF45", "#FF9100", "#9C5900", "#FFF9BF", "#FFED4F",
        "#FFE600", "#A37500", "#83FF80", "#5EFF59", "#00C900", "#009100",
        "#A8CFE0", "#72BFE0", "#009DE0", "#006794", "#BFCDFF", "#597DFF",
        "#0037FF", "#002CCF", "#E9AFCB", "#E94D9A", "#E9187E", "#B30459",
        "#A37AA2", "#A33CA0", "#A3009F", "#780075" ],
    getRandomColor: function () {
        return this.tubeColorsArray[Math.floor(Math.random()
                * (this.tubeColorsArray.length - 1))];
    },

    SaveCanvasToFile: function (cvs) {
        var base64 = cvs.toDataURL("image/png");
        var b64 = base64.slice(base64.indexOf(',') + 1);
        var byteCharacters = window.atob(b64);
        var byteNumbers = byteCharacters.split('').map(function (e) {
            return e.charCodeAt(0);
        });
        var byteArray = new Uint8Array(byteNumbers);
        var blob = new Blob([byteArray], {type: 'image/png'});

        var pics = navigator.getDeviceStorage('pictures');
        var pic_name = "PicsArtKids/img_" + new Date().getTime() + ".png";
        var request = pics.addNamed(blob, pic_name);

        request.onsuccess = function () {
            //alert("on success ok");
            $.mobile.loading('hide');
            $("#savedPopup").popup("open");
            setTimeout(function () {
                $("#savedPopup").popup("close")
            }, 300);
        };

        request.onerror = function () {
            alert("on error");
        };
    },


    getFileList: function (callback) {
        window.dataSource = null;
        window.imageList = [];
        var pics = navigator.getDeviceStorage('pictures');
        var kidsDir = pics.enumerate("PicsArtKids");
        kidsDir.onsuccess = function () {
            var file = this.result;
            if (!this.done) {
                var reader  = new FileReader();
                reader.onloadend = function () {
                    window.imageList.push(reader.result);
                }
                reader.readAsDataURL(file);
                this.continue();
            } else {
                callback();
            }
        }

        kidsDir.onerror = function () {

        }
    },


    d:function () {
    var camera = new MozActivity({
        name: "record",
        data:{
            type: ["photos"]
        }

    });

        camera.onsuccess = function(){
           //@stex pti grvi en kod@ vor@ or nkart kvercne


        }

        camera.onerror = function (){
           alert("Error")
        }
    },

    openImgView: function  (path){


//
//    var pic = new MozActivity({
//        name: "open",
//        data:{
//            type: ["image/jpeg",
//                "image/png",
//                "image/gif",
//                "image/bmp"
//            ]
//        }
//    });
//
//pic.onsuccess = function(){
//    console.log(this);
//    console.log(this.blob)
//    console.log(this.result.blob)
//
//
//}
//
//        pic.onerror = function (){
//            alert("Error");
//        }

}

};

window.tracksBrush = [ "draw_1.ogg", "draw_2.ogg", "draw_3.ogg", "draw_4.ogg",
    "draw_5.ogg", "draw_6.ogg", "draw_7.ogg", "draw_8.ogg", "draw_9.ogg",
    "draw_10.ogg", "draw_11.ogg", "draw_12.ogg" ];

window.mainTrack;
window.brushTrack;
window.clickTrack;
window.colorSelectTrack;
window.b_music = false;

function random(min, max) {
    return Math.floor(Math.random() * (max - min + 1) + min);
}

function initTrack() {
    window.mainTrack = document.getElementById("mainTrack");
    window.brushTrack = document.getElementById("brushTrack");
    window.clickTrack = document.getElementById("clickTrack");
    window.colorSelectTrack = document.getElementById("colorSelectTrack");
    window.b_music = false;
    window.mainTrack.addEventListener('ended', function () {
        this.play();
    }, false);
    window.onfocus = function () {
        if (window.b_music) {
            mainTrack.play();
        }
    }
}

function playMainTrack(b_music) {
    if (b_music) {
        mainTrack.play();
    } else {
        mainTrack.pause();
        mainTrack.currentTime = 0;
    }
}

function playBrushTrack(b_music) {
    if (b_music) {
        brushTrack.src = "sound/draw/"
                + tracksBrush[random(0, tracksBrush.length - 1)];
        brushTrack.play();
    }
}

function playClickTrack(b_music) {
    if (b_music) {
        clickTrack.play();
    }
}

function playColorSelectTrack(b_music) {
    if (b_music) {
        colorSelectTrack.play();
    }
}

function AddBgImg(item) {
    $(item).css({
        "background-image": "url('res/icons/bg_panel_button_p.png')",
        "background-repeat": "no-repeat"
    });
}

function RemoveBgImg(item) {
    $(item).css("background-image", "none");
}


$(document).on("pageinit", "#mainPage", initTrack);