﻿/*window.onload = () => {
PigeonRevenge.game = new PigeonRevenge.Game();
};
*/
var doc;
doc = document;
var hidden, visibilityChange;
if (typeof doc.hidden !== "undefined") {
    hidden = "hidden";
    visibilityChange = "visibilitychange";
} else if (typeof doc.webkitHidden !== "undefined") {
    hidden = "webkitHidden";
    visibilityChange = "webkitvisibilitychange";
}

function handleVisibilityChange() {
    if (document[hidden]) {
        PigeonRevenge.level.pause();
    }
}
document.addEventListener(visibilityChange, handleVisibilityChange, false);
var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var PigeonRevenge;
(function (PigeonRevenge) {
    var Boot = (function (_super) {
        __extends(Boot, _super);
        function Boot() {
            _super.apply(this, arguments);
        }
        Boot.prototype.preload = function () {
            var path = "assets/images/320/pigeon_logo.png";
            if (PigeonRevenge.game.height == 480)
                path = "assets/images/480/pigeon_logo.png";

            this.load.image('logo', path);
        };

        Boot.prototype.create = function () {
            PigeonRevenge.game.antialias = false;

            this.input.maxPointers = 1;
            PigeonRevenge.game.stage.smoothed = false;
            this.stage.disableVisibilityChange = true;

            PigeonRevenge.game.scale.scaleMode = Phaser.ScaleManager.SHOW_ALL;
            PigeonRevenge.game.scale.minWidth = 480;
            PigeonRevenge.game.scale.minHeight = 480;
            PigeonRevenge.game.scale.maxWidth = 800;
            PigeonRevenge.game.scale.maxHeight = 800;
            PigeonRevenge.game.scale.forceLandscape = true;
            PigeonRevenge.game.scale.pageAlignHorizontally = true;
            PigeonRevenge.game.scale.pageAlignVertically = true;
            PigeonRevenge.game.scale.setScreenSize(true);

            PigeonRevenge.game.scale.width = window.innerWidth;
            PigeonRevenge.game.scale.height = window.innerHeight;

            //game.scale.setMaximum();
            this.game.scale.setShowAll();
            this.game.scale.refresh();

            if (PigeonRevenge.game.device.desktop) {
            } else {
            }

            PigeonRevenge.game.state.start('Preload', true, false);
        };
        return Boot;
    })(Phaser.State);
    PigeonRevenge.Boot = Boot;
})(PigeonRevenge || (PigeonRevenge = {}));
var PigeonRevenge;
(function (PigeonRevenge) {
    var Constants = (function () {
        function Constants() {
        }
        Object.defineProperty(Constants, "Levels", {
            get: function () {
                var levels = {};
                levels["Village"] = {
                    id: 1,
                    spawnInterval: 2,
                    targets: [
                        {
                            start_time: 0,
                            weight: 100,
                            type: PigeonRevenge.TargetCow
                        },
                        {
                            start_time: 30,
                            weight: 100,
                            type: PigeonRevenge.TargetDoyarka
                        },
                        {
                            start_time: 60,
                            weight: 50,
                            type: PigeonRevenge.TargetGoose
                        }
                    ]
                };

                levels["City"] = {
                    id: 2,
                    spawnInterval: 2,
                    targets: [
                        {
                            start_time: 0,
                            weight: 80,
                            type: PigeonRevenge.TargetGlamourFatty
                        },
                        {
                            start_time: 10,
                            weight: 50,
                            type: PigeonRevenge.TargetRunnerGirl
                        },
                        {
                            start_time: 20,
                            weight: 40,
                            type: PigeonRevenge.TargetRabbit
                        },
                        {
                            start_time: 30,
                            weight: 60,
                            type: PigeonRevenge.TargetManager
                        },
                        {
                            start_time: 40,
                            weight: 70,
                            type: PigeonRevenge.TargetOldMan
                        },
                        {
                            start_time: 40,
                            weight: 50,
                            type: PigeonRevenge.TargetBlackguy
                        },
                        {
                            start_time: 50,
                            weight: 30,
                            type: PigeonRevenge.TargetCat
                        },
                        {
                            start_time: 60,
                            weight: 40,
                            type: PigeonRevenge.TargetGirlWithUmbrella
                        },
                        {
                            start_time: 80,
                            weight: 80,
                            type: PigeonRevenge.TargetFat
                        }
                    ]
                };
                return levels;
            },
            enumerable: true,
            configurable: true
        });
        Constants.bombInitial = 0;
        Constants.bombAmountMax = 5;
        Constants.bombAmountCritical = 7;
        Constants.minBombForLaunch = 1;
        Constants.bombRegen = 1;
        Constants.bonusSpawnChance = 0.07;

        Constants.lifesMax = 10;

        Constants.speedScoreMultiplie = 0.01;
        return Constants;
    })();
    PigeonRevenge.Constants = Constants;
})(PigeonRevenge || (PigeonRevenge = {}));
var PigeonRevenge;
(function (PigeonRevenge) {
    var Game = (function (_super) {
        __extends(Game, _super);
        function Game() {
            //set to 320 manually to see it, for pc launch it will be always 480
            //game.scale.scaleFactor.set(2, 2);
            //game.scale.refresh();
            _super.call(this, 320, 480, Phaser.AUTO, 'content', null, false, false);

            //super(320, innerHeight < 400 ? 320 : 480, Phaser.AUTO, 'content', null, false, false);
            //super(320, 320, Phaser.AUTO, 'content', null, false, false);
            //game.scale.fullScreenScaleMode = Phaser.ScaleManager.SHOW_ALL;
            //game.scale.scaleMode = Phaser.ScaleManager.SHOW_ALL;
            //game.scale.setMaximum();
            //game.scale.setScreenSize(true);
            //game.scale.pageAlignHorizontally = true;
            //game.scale.pageAlignVertically = true;
            // Docs say this is necessary, but it doesn't seem to change behavior?
            //game.scale.setScreenSize(true);
            // This is necessary to scale before waiting for window changes.
            this.state.add('Boot', PigeonRevenge.Boot, false);
            this.state.add('Preload', PigeonRevenge.Preload, false);
            this.state.add('MainMenu', PigeonRevenge.MainMenu, false);
            this.state.add('Level', PigeonRevenge.Level, false);

            this.state.start('Boot');
        }
        return Game;
    })(Phaser.Game);
    PigeonRevenge.Game = Game;
})(PigeonRevenge || (PigeonRevenge = {}));
var PigeonRevenge;
(function (PigeonRevenge) {
    PigeonRevenge.game;
    PigeonRevenge.level;
    PigeonRevenge.language;

    function clearStorage() {
        localStorage.clear();
    }
    PigeonRevenge.clearStorage = clearStorage;
})(PigeonRevenge || (PigeonRevenge = {}));
/// <reference path="Configs.ts" />
var PigeonRevenge;
(function (PigeonRevenge) {
    var Level = (function (_super) {
        __extends(Level, _super);
        function Level() {
            _super.apply(this, arguments);
            this.gameOverState = false;
            this.targets = {};
            this.pigeonSpeed = 160;
            this.pigeonFlyingRight = true;
            this.pigeonOffset = 20;
            this.tutorialFinishedText = null;
            this.scoreDigits = [];
            this.lifeDigits = [];
            this.bombCell = [];
        }
        Level.prototype.init = function (level) {
            this.levelConfig = PigeonRevenge.Constants.Levels[level];
        };

        Level.prototype.create = function () {
            var _this = this;
            PigeonRevenge.level = this;
            this.startTime = PigeonRevenge.game.time.now;
            this.bombAmount = PigeonRevenge.Constants.bombInitial;
            this.score = 0;
            this.lifes = PigeonRevenge.Constants.lifesMax;
            this.pigeonFlyingRight = true;
            this.gameOverState = false;

            this.stage.backgroundColor = 0xeeeeee;
            this.createLayers();

            this.explosions = PigeonRevenge.game.add.group();
            this.explosions.enableBody = true;
            this.explosions.physicsBodyType = Phaser.Physics.ARCADE;
            this.explosions.createMultiple(30, 'explosion');
            this.explosions.setAll('anchor.x', 0.5);
            this.explosions.setAll('anchor.y', 0.5);
            this.explosions.forEach(function (explosion) {
                return explosion.animations.add('boom');
            }, this);

            this.explosionsBig = PigeonRevenge.game.add.group();
            this.explosionsBig.enableBody = true;
            this.explosionsBig.physicsBodyType = Phaser.Physics.ARCADE;
            this.explosionsBig.createMultiple(30, 'explosion5');
            this.explosionsBig.setAll('anchor.x', 0.5);
            this.explosionsBig.setAll('anchor.y', 0.5);
            this.explosionsBig.setAll('scale.x', 1.3);
            this.explosionsBig.setAll('scale.y', 1.3);
            this.explosionsBig.forEach(function (explosion) {
                return explosion.animations.add('boom');
            }, this);

            this.spawnPigeon();
            this.spawnTarget();

            this.initHudElements();

            PigeonRevenge.game.physics.arcade.gravity.y = 400;

            this.background.inputEnabled = true;
            this.background.events.onInputDown.add(function () {
                return _this.bomb();
            }, this);

            var timer = PigeonRevenge.game.time.create(false);
            timer.loop(this.levelConfig.spawnInterval * 1000, this.spawnTarget, this);
            timer.start();

            var bombRefilltimer = PigeonRevenge.game.time.create(false);
            bombRefilltimer.loop(1000 / 10, function () {
                return _this.bombAmount += PigeonRevenge.Constants.bombRegen / 10;
            }, this);
            bombRefilltimer.start();
        };

        Level.prototype.update = function () {
            if (!this.pigeon.alive)
                return;

            //this.bombAmount += game.time.elapsed / 1000 * Constants.bombRegen;
            if (this.bombAmount >= PigeonRevenge.Constants.bombAmountMax)
                this.pigeon.play('fly_big');
            else if (this.bombAmount > PigeonRevenge.Constants.bombAmountMax / 2)
                this.pigeon.play('fly_medium');
            else if (this.pigeon.animations.currentAnim.name != 'bomb' || (this.pigeon.animations.currentAnim.name == 'bomb' && this.pigeon.animations.currentAnim.isFinished))
                this.pigeon.play('fly_small');

            var bombsFilled = this.bombAmount;
            for (var i = 0; i < PigeonRevenge.Constants.bombAmountMax; i++) {
                if (bombsFilled >= (i + 1)) {
                    this.bombCell[i].frame = i < 4 ? 0 : 1;
                } else
                    this.bombCell[i].frame = 2;
            }

            var exceeded = this.bombAmount - PigeonRevenge.Constants.bombAmountMax;
            var skullHeight = PigeonRevenge.game.cache.getImage('skull').height;
            if (exceeded > 0) {
                var filled = Math.round(skullHeight * Math.max(0, exceeded / 2));
                this.skullCell.crop(new Phaser.Rectangle(0, skullHeight - filled, 50, filled), true);
            } else {
                this.skullCell.crop(new Phaser.Rectangle(0, 0, 50, 0), true);
            }

            var scoreStr = this.pad(Math.min(Math.floor(this.score), 999999), 6);
            for (var i = 0; i < 6; i++) {
                this.scoreDigits[i].frame = +scoreStr.charAt(i);
            }

            var lifeStr = this.pad(this.lifes, 2);
            for (var i = 0; i < 2; i++) {
                this.lifeDigits[i].frame = +lifeStr.charAt(i);
            }

            if (this.lifes <= 0 && !this.gameOverState) {
                this.gameOver();
            }

            if (this.bombAmount > PigeonRevenge.Constants.bombAmountCritical + 0.2) {
                this.gameOver();
            }

            var pigeonMovement = PigeonRevenge.game.time.elapsed / 1000 * this.pigeonSpeed;
            this.pigeon.position.x += pigeonMovement * this.pigeon.scale.x;

            var pigeonHalfWidth = this.pigeon.widthAbs / 2;
            if (this.pigeon.position.x > PigeonRevenge.game.width - pigeonHalfWidth - this.pigeonOffset) {
                this.pigeon.position.x = PigeonRevenge.game.width - pigeonHalfWidth - this.pigeonOffset;
                this.pigeon.scale.x = -1;
            }
            if (this.pigeon.position.x < pigeonHalfWidth + this.pigeonOffset) {
                this.pigeon.position.x = pigeonHalfWidth + this.pigeonOffset;
                this.pigeon.scale.x = 1;
            }

            for (var targetType in this.targets) {
                PigeonRevenge.game.physics.arcade.overlap(this.bombs, this.targets[targetType], this.targetHit, null, this);
            }

            PigeonRevenge.game.physics.arcade.overlap(this.bombs, this.ground, this.groundHit, null, this);

            if (this.levelConfig.id == 1 && this.score > 1000 && this.tutorialFinishedText == null && localStorage.getItem("tutorial_passed") != "true") {
                var completed = PigeonRevenge.game.add.sprite(PigeonRevenge.game.world.centerX, PigeonRevenge.game.world.centerY, 'txt_tutorial_completed');
                completed.anchor.set(0.5);
                PigeonRevenge.game.paused = true;
                this.game.input.onDown.addOnce(function () {
                    if (PigeonRevenge.game.paused) {
                        PigeonRevenge.game.paused = false;
                        completed.destroy();
                    }
                }, this);
                localStorage.setItem("tutorial_passed", "true");
            }

            this.deadGroup.forEach(function (sprite) {
                if (sprite != undefined)
                    try  {
                        sprite.destroy();
                    } finally {
                    }
            }, this);
        };

        Level.prototype.pad = function (num, size) {
            var str = "000000000" + num;
            return str.substr(str.length - size);
        };

        Level.prototype.targetHit = function (bomb, target) {
            if (!bomb.alive)
                return;
            bomb.kill();

            if (bomb.amount >= PigeonRevenge.Constants.bombAmountMax) {
                this.aoeHit(bomb);
            } else
                this.hitTarget(target, bomb.amount);

            var explosion = this.createExplosion(bomb.x, bomb.y, bomb.amount, 1 + Math.min(bomb.amount / 10, 1));
            explosion.body.velocity.x = bomb.body.velocity.x / 5 / bomb.amount;
            explosion.body.velocity.y = bomb.body.velocity.y / 5 / bomb.amount;
        };

        Level.prototype.createExplosion = function (x, y, amount, scale) {
            if (typeof scale === "undefined") { scale = 1; }
            var explosion;
            if (amount >= PigeonRevenge.Constants.bombAmountMax) {
                explosion = this.explosionsBig.getFirstExists(false);
            } else {
                explosion = this.explosions.getFirstExists(false);
                explosion.scale.set(scale);
            }

            explosion.reset(x, y + 2);
            explosion.play('boom', 15, false, true);
            return explosion;
        };

        Level.prototype.hitTarget = function (target, bombAmount, superHit) {
            if (typeof superHit === "undefined") { superHit = 1; }
            var score = Math.floor(target.score * target.speed * PigeonRevenge.Constants.speedScoreMultiplie * Math.pow(bombAmount, 1.5)) * superHit;

            if (bombAmount >= target.minBombAmount) {
                this.spawnDamageInfo(target.x, target.y - 10, score);
                this.score += score;
                target.destroy();
                if (target.superHit != 0) {
                    this.showSuperHit(target.superHit);
                }
                if (Math.random() < PigeonRevenge.Constants.bonusSpawnChance) {
                    var bonuses = [BonusBomb, BonusLife, BonusFreeze];
                    var bonus = bonuses[Math.floor(Math.random() * bonuses.length)];
                    var bonusObj = new bonus(target.x, target.y);
                    PigeonRevenge.game.add.existing(bonusObj);
                }
            } else {
                this.spawnDamageInfo(target.x, target.y - 10, Math.floor(score / 10));
                this.score += score / 10;
            }
        };

        Level.prototype.showSuperHit = function (multiplier) {
            var _this = this;
            var superHit = PigeonRevenge.game.add.sprite(PigeonRevenge.game.world.centerX, PigeonRevenge.game.world.centerY, 'x' + multiplier);
            superHit.anchor.set(0.5);
            superHit.animations.add('show');
            superHit.play('show', 6, false, true);
            superHit.animations.currentAnim.onComplete.addOnce(function () {
                return _this.deadGroup.add(superHit);
            }, superHit);
        };

        Level.prototype.aoeHit = function (bomb) {
            var _this = this;
            var miss = true;
            var radius = 80;
            var toHit = [];
            for (var targetType in this.targets) {
                this.targets[targetType].forEachAlive(function (target) {
                    var distance = Phaser.Math.distance(target.x, target.y, bomb.x, bomb.y);

                    //console.log(distance);
                    if (distance < radius) {
                        toHit.push({ target: target, amount: bomb.amount * (radius - distance / 1.5) / radius });
                    }
                }, this);
            }
            if (toHit.length > 0) {
                miss = false;
                this.showSuperHit(2);
            }

            toHit.forEach(function (ti) {
                _this.hitTarget(ti.target, ti.amount, 2);
            });
            return miss;
        };

        Level.prototype.groundHit = function (ground, bomb) {
            if (!bomb.alive)
                return;

            this.createExplosion(bomb.x, bomb.y, bomb.amount, 1 + Math.min(bomb.amount / 5, 1));

            if (bomb.noMiss) {
                //console.log('noMiss bomb');
                bomb.kill();
                return;
            }

            var miss = true;

            if (bomb.amount >= PigeonRevenge.Constants.bombAmountMax) {
                miss = this.aoeHit(bomb);
            }

            if (miss) {
                //console.log('miss');
                this.decLife();
            }

            //else
            //    console.log('no miss');
            bomb.kill();
        };

        Level.prototype.render = function () {
            //this.targets.forEachAlive((target) => game.debug.body(target), this);
        };

        Level.prototype.canBomb = function () {
            return this.bombAmount >= PigeonRevenge.Constants.minBombForLaunch && this.pigeon.alive && PigeonRevenge.game.input.activePointer.y < (this.game.height - this.ground.height);
        };

        Level.prototype.bomb = function () {
            var _this = this;
            if (this.canBomb()) {
                var bomb = this.createBomb(this.pigeon.x, this.pigeon.y, this.bombAmount, this.pigeonSpeed * this.pigeon.scale.x / 2);
                bomb.events.onOutOfBounds.addOnce(function () {
                    return _this.onBombMissed(bomb);
                }, this);
                this.bombAmount = 0;
                this.pigeon.play('bomb');
            }
        };

        Level.prototype.createBomb = function (x, y, amount, velocity) {
            var bomb = this.bombs.getFirstDead();
            if (bomb) {
                bomb.reset(x, y);
                bomb.noMiss = false;
            } else {
                bomb = new Bomb(x, y);
                this.bombs.add(bomb);
            }
            bomb.init(amount, velocity);
            return bomb;
        };

        Level.prototype.onBombMissed = function (bomb) {
            if (!bomb.alive)
                return;
            this.decLife();
            bomb.kill();
        };

        Level.prototype.decLife = function () {
            this.lifes -= 1;
        };

        Level.prototype.gameOver = function () {
            var _this = this;
            this.gameOverState = true;
            var explosion = PigeonRevenge.game.add.sprite(this.pigeon.x, this.pigeon.y, 'explosion_bird');
            explosion.anchor.set(0.5);
            explosion.scale.set(2);
            explosion.animations.add('boom');
            explosion.play('boom', 10, false, true);
            this.pigeon.kill();

            var gameOverText = PigeonRevenge.game.add.sprite(PigeonRevenge.game.world.centerX, PigeonRevenge.game.world.centerY - 50, 'txt_gameover');
            gameOverText.anchor.set(0.5);

            var currentScoreDigits = [];
            for (var i = 0; i < 6; i++) {
                currentScoreDigits[i] = PigeonRevenge.game.add.sprite(PigeonRevenge.game.width / 2 + 10 + i * 18, gameOverText.y + 20, 'digit', 0);
            }

            var scoreText = PigeonRevenge.game.add.sprite(PigeonRevenge.game.width / 2 - 10, gameOverText.y + 20, 'txt_score');
            scoreText.x -= scoreText.width;

            var bestScoreDigits = [];
            for (var i = 0; i < 6; i++) {
                bestScoreDigits[i] = PigeonRevenge.game.add.sprite(PigeonRevenge.game.width / 2 + 10 + i * 18, gameOverText.y + 50, 'digit', 0);
            }

            var bestScore = PigeonRevenge.game.add.sprite(PigeonRevenge.game.width / 2 - 10, gameOverText.y + 50, 'txt_score_best');
            bestScore.x -= bestScore.width;

            var scoreStr = this.pad(Math.min(Math.floor(this.score), 999999), 6);
            for (var i = 0; i < 6; i++) {
                currentScoreDigits[i].frame = +scoreStr.charAt(i);
            }

            var scroreField = "score_" + this.levelConfig.id;
            var prevScore = localStorage.getItem(scroreField);
            prevScore = prevScore || 0;
            var scoreStr = this.pad(Math.min(Math.floor(prevScore > this.score ? prevScore : this.score), 999999), 6);
            for (var i = 0; i < 6; i++) {
                bestScoreDigits[i].frame = +scoreStr.charAt(i);
            }

            PigeonRevenge.game.input.onDown.addOnce(function () {
                if (_this.score > prevScore)
                    localStorage.setItem(scroreField, _this.score.toString());
                PigeonRevenge.game.state.start('MainMenu', true, false);
            }, this);

            if (this.score > prevScore) {
                var timer = PigeonRevenge.game.time.create(false);
                timer.repeat(150, 50, function () {
                    _this.createExplosion(Math.random() * PigeonRevenge.game.width, Math.random() * PigeonRevenge.game.height, 5 * Math.random(), 1 + Math.random());
                }, this);
                timer.start();
            }
        };

        Level.prototype.spawnPigeon = function () {
            this.pigeon = new MySprite(20, PigeonRevenge.game.height - 250, 'pigeon');
            this.pigeon.animations.add('fly_small', [0, 1, 2, 3], 6, true);
            this.pigeon.animations.add('fly_medium', [4, 5, 6, 7], 6, true);
            this.pigeon.animations.add('fly_big', [8, 9, 10, 11], 6, true);
            this.pigeon.animations.add('bomb', [12, 13, 14, 15], 6, false);
            this.pigeon.anchor.set(0.5);
            PigeonRevenge.game.add.existing(this.pigeon);
            this.pigeon.play('fly_small');
            PigeonRevenge.game.add.tween(this.pigeon.position).to({ y: this.pigeon.position.y - 6 }, 500, Phaser.Easing.Quadratic.InOut).to({ y: this.pigeon.position.y + 6 }, 500, Phaser.Easing.Quadratic.InOut).loop().start();
        };

        Level.prototype.spawnTarget = function () {
            var targetInfo = this.getTargetForSpawn();
            var group = this.targets[typeof targetInfo.type];
            var target = new targetInfo.type();
            group.add(target);
            target.init();
        };

        Level.prototype.getTargetForSpawn = function () {
            var _this = this;
            var targets = this.levelConfig.targets.filter(function (target) {
                return _this.game.time.elapsedSecondsSince(_this.startTime) >= target.start_time;
            });
            var sum = targets.reduce(function (acc, current) {
                return acc += current.weight;
            }, 0);
            var weight = PigeonRevenge.game.rnd.integerInRange(0, sum);
            var currentWeight = 0;
            for (var index in targets) {
                var target = targets[index];
                currentWeight += target.weight;
                if (weight <= currentWeight)
                    return target;
            }
        };

        Level.prototype.initHudElements = function () {
            var _this = this;
            var bombIcon = PigeonRevenge.game.add.sprite(0, 0, 'bomb_icon');
            bombIcon.x = 4;
            bombIcon.y = 4;

            var lifesIcon = PigeonRevenge.game.add.sprite(0, 0, 'lifes_icon');
            lifesIcon.x = PigeonRevenge.game.width - lifesIcon.width - 4;
            lifesIcon.y = 10;

            for (var i = 0; i < 6; i++) {
                this.scoreDigits[i] = PigeonRevenge.game.add.sprite(PigeonRevenge.game.width / 2 - 10 + i * 18, PigeonRevenge.game.height - 40, 'digit', 0);
                //this.scoreDigits[i].tint = 0xfff68f;
            }

            var scoreText = PigeonRevenge.game.add.sprite(PigeonRevenge.game.width / 2 - 15, PigeonRevenge.game.height - 40, 'txt_score');
            scoreText.x -= scoreText.width;

            for (var i = 0; i < 2; i++)
                this.lifeDigits[i] = PigeonRevenge.game.add.sprite(lifesIcon.x - 50 + i * 20, lifesIcon.y, 'digit', 0);

            for (var i = 0; i < 5; i++) {
                this.bombCell[i] = PigeonRevenge.game.add.sprite(bombIcon.width + 5 + i * 22, bombIcon.y + 14, 'bomb_bar', 2);
            }

            PigeonRevenge.game.add.sprite(this.bombCell[4].x + 22, bombIcon.y + 10, 'skull', 0);

            this.skullCell = PigeonRevenge.game.add.sprite(this.bombCell[4].x + 22, bombIcon.y + 10, 'skull', 1);
            this.skullCell.y += this.skullCell.height;
            this.skullCell.crop(new Phaser.Rectangle(0, 0, 50, 0), true);
            this.skullCell.anchor.y = 1;

            var button = PigeonRevenge.game.add.sprite(5, PigeonRevenge.game.height - 5, 'btn_mainmenu');
            button.anchor.set(0, 1);
            button.inputEnabled = true;
            button.events.onInputDown.addOnce(function () {
                return PigeonRevenge.game.state.start('MainMenu', true, false);
            }, this);

            var button = PigeonRevenge.game.add.sprite(PigeonRevenge.game.width - 5, PigeonRevenge.game.height - 5, 'btn_pause');
            button.anchor.set(1, 1);
            button.inputEnabled = true;
            button.events.onInputDown.add(function () {
                return _this.pause();
            }, this);

            this.pauseText = PigeonRevenge.game.add.sprite(PigeonRevenge.game.width / 2, PigeonRevenge.game.height / 2, 'txt_paused');
            this.pauseText.anchor.set(0.5);
            this.pauseText.visible = false;
            //button.tint = 0xff0000;
        };

        Level.prototype.pause = function () {
            var _this = this;
            if (this.gameOverState)
                return;
            PigeonRevenge.game.paused = true;
            this.pauseText.visible = true;
            PigeonRevenge.game.input.onDown.addOnce(function () {
                PigeonRevenge.game.paused = false;
                _this.pauseText.visible = false;
            }, this);
        };

        Level.prototype.createLayers = function () {
            this.background = PigeonRevenge.game.add.sprite(0, 0, "level" + this.levelConfig.id + "_back");
            this.background.anchor.set(0, 0);

            for (var i in this.levelConfig.targets) {
                this.targets[typeof this.levelConfig.targets[i].type] = PigeonRevenge.game.add.group();
            }

            this.bombs = PigeonRevenge.game.add.group();
            this.deadGroup = PigeonRevenge.game.add.group();

            this.ground = PigeonRevenge.game.add.sprite(0, this.background.height, "level" + this.levelConfig.id + "_ground");
            this.ground.y -= this.ground.height;
            this.ground.anchor.set(0, 0);
            PigeonRevenge.game.physics.enable(this.ground, Phaser.Physics.ARCADE);
            this.ground.body.allowGravity = false;
            this.ground.body.static = true;
        };

        Level.prototype.spawnDamageInfo = function (x, y, value) {
            var info = [];
            var valueStr = value.toString();

            for (var i = 0; i < valueStr.length; i++) {
                info[i] = PigeonRevenge.game.add.sprite(x - valueStr.length * 18 / 2 + i * 18, y - 10, 'digit', 0);
                info[i].frame = +valueStr.charAt(i);
                PigeonRevenge.game.add.tween(info[i]).to({ y: y - 100, alpha: 0 }, 1000, Phaser.Easing.Quadratic.Out, true).onComplete.add(info[i].destroy, info[i]);
            }
        };
        return Level;
    })(Phaser.State);
    PigeonRevenge.Level = Level;

    var MySprite = (function (_super) {
        __extends(MySprite, _super);
        function MySprite(x, y, key, frame) {
            _super.call(this, PigeonRevenge.game, x, y, key, frame);
        }
        Object.defineProperty(MySprite.prototype, "widthAbs", {
            get: function () {
                return Math.abs(this.width);
            },
            enumerable: true,
            configurable: true
        });

        Object.defineProperty(MySprite.prototype, "heightAbs", {
            get: function () {
                return Math.abs(this.height);
            },
            enumerable: true,
            configurable: true
        });
        return MySprite;
    })(Phaser.Sprite);
    PigeonRevenge.MySprite = MySprite;

    var Bomb = (function (_super) {
        __extends(Bomb, _super);
        function Bomb(x, y) {
            _super.call(this, x, y, 'bomb', 0);

            this.noMiss = false;

            this.anchor.set(0.5);

            PigeonRevenge.game.physics.enable(this, Phaser.Physics.ARCADE);
            this.body.allowGravity = true;
            this.body.velocity.y = 100;
            this.checkWorldBounds = true;

            this.animations.add('0', [0, 1], 6, true);
            this.animations.add('1', [2, 3], 6, true);
            this.animations.add('2', [4, 5], 6, true);
            this.animations.add('3', [6, 7], 6, true);
            this.animations.add('4', [8, 9], 6, true);
        }
        Bomb.prototype.init = function (amount, velocity) {
            this.amount = Math.floor(Math.min(Math.max(1, amount), PigeonRevenge.Constants.bombAmountMax));
            this.body.velocity.x = velocity;
            this.animations.play((this.amount - 1).toString());
        };
        return Bomb;
    })(MySprite);
    PigeonRevenge.Bomb = Bomb;

    var Bonus = (function (_super) {
        __extends(Bonus, _super);
        function Bonus(x, y, sprite) {
            var _this = this;
            _super.call(this, x, y, sprite, 0);

            this.animations.add('anim');
            this.animations.play('anim', 6, true);

            this.inputEnabled = true;
            this.events.onInputDown.addOnce(function () {
                return _this.action();
            }, this);

            PigeonRevenge.game.add.tween(this.position).to({ y: PigeonRevenge.level.pigeon.y + 20 }, 1200, Phaser.Easing.Quadratic.In, true);
        }
        Bonus.prototype.action = function () {
            this.destroy();
        };
        return Bonus;
    })(MySprite);
    PigeonRevenge.Bonus = Bonus;

    var BonusBomb = (function (_super) {
        __extends(BonusBomb, _super);
        function BonusBomb(x, y) {
            _super.call(this, x, y, 'bonus_bomb');
        }
        BonusBomb.prototype.action = function () {
            var y = PigeonRevenge.level.pigeon.y + 10;

            var x = 10;
            while (x <= PigeonRevenge.game.width - 10) {
                var bomb = PigeonRevenge.level.createBomb(x, y, PigeonRevenge.Constants.bombAmountMax, 0);
                bomb.noMiss = true;
                x += 40;
            }
            _super.prototype.action.call(this);
        };
        return BonusBomb;
    })(Bonus);
    PigeonRevenge.BonusBomb = BonusBomb;

    var BonusLife = (function (_super) {
        __extends(BonusLife, _super);
        function BonusLife(x, y) {
            _super.call(this, x, y, 'bonus_life');
        }
        BonusLife.prototype.action = function () {
            PigeonRevenge.level.lifes += 1;
            _super.prototype.action.call(this);
        };
        return BonusLife;
    })(Bonus);
    PigeonRevenge.BonusLife = BonusLife;

    var BonusFreeze = (function (_super) {
        __extends(BonusFreeze, _super);
        function BonusFreeze(x, y) {
            _super.call(this, x, y, 'bonus_freeze');
        }
        BonusFreeze.prototype.action = function () {
            for (var g in PigeonRevenge.level.targets) {
                PigeonRevenge.level.targets[g].forEachAlive(function (t) {
                    if (t.x > 0 && t.x < PigeonRevenge.game.width)
                        t.freeze();
                }, PigeonRevenge.level);
            }
            _super.prototype.action.call(this);
        };
        return BonusFreeze;
    })(Bonus);
    PigeonRevenge.BonusFreeze = BonusFreeze;
})(PigeonRevenge || (PigeonRevenge = {}));
/// <reference path="Configs.ts" />
var PigeonRevenge;
(function (PigeonRevenge) {
    var MainMenu = (function (_super) {
        __extends(MainMenu, _super);
        function MainMenu() {
            _super.apply(this, arguments);
        }
        MainMenu.prototype.create = function () {
            this.background = this.add.sprite(0, 0, 'menu');

            var tutorialBubble = this.add.sprite(0, 0, 'btn_howto');
            tutorialBubble.x = 10;
            tutorialBubble.y = PigeonRevenge.game.height - 200;

            var gameBubble = this.add.sprite(0, 0, 'btn_game');
            gameBubble.x = 160;
            gameBubble.y = PigeonRevenge.game.height - 220;

            var pigeon = this.add.sprite(0, 0, 'pigeon');
            pigeon.animations.add('fly_small', [0, 1, 2, 3], 6, true);
            pigeon.anchor.set(0.5);
            pigeon.play('fly_small');
            pigeon.x = 50;
            pigeon.y = PigeonRevenge.game.height - 220;

            var title = this.add.sprite(0, 0, 'menu_logo');
            title.anchor.set(0.5);
            title.x = PigeonRevenge.game.width / 2;
            title.y = title.height / 2;

            this.villageRect = new Phaser.Rectangle(0, PigeonRevenge.game.height - 200, 140, 200);
            this.cityRect = new Phaser.Rectangle(160, PigeonRevenge.game.height - 200, 160, 200);

            if (this.isTutorialPassed()) {
                pigeon.x = 270;
                pigeon.y = PigeonRevenge.game.height - 170;
            }

            PigeonRevenge.game.add.tween(pigeon.position).to({ y: pigeon.position.y - 6 }, 500, Phaser.Easing.Quadratic.InOut).to({ y: pigeon.position.y + 6 }, 500, Phaser.Easing.Quadratic.InOut).loop().start();

            PigeonRevenge.game.input.onTap.add(this.tap, this);
        };

        MainMenu.prototype.tap = function () {
            var _this = this;
            if (this.villageRect.contains(PigeonRevenge.game.input.x, PigeonRevenge.game.input.y)) {
                var tutorial = PigeonRevenge.game.add.sprite(0, 0, 'tutorial');
                tutorial.inputEnabled = true;
                tutorial.events.onInputDown.add(function () {
                    return _this.startGame("Village");
                }, this);
            } else if (this.cityRect.contains(PigeonRevenge.game.input.x, PigeonRevenge.game.input.y)) {
                this.startGame("City");
            }
        };

        MainMenu.prototype.startGame = function (level) {
            PigeonRevenge.game.state.start('Level', true, false, level);
        };

        MainMenu.prototype.isTutorialPassed = function () {
            return localStorage.getItem("tutorial_passed") == "true";
        };
        return MainMenu;
    })(Phaser.State);
    PigeonRevenge.MainMenu = MainMenu;
})(PigeonRevenge || (PigeonRevenge = {}));
var PigeonRevenge;
(function (PigeonRevenge) {
    var Preload = (function (_super) {
        __extends(Preload, _super);
        function Preload() {
            _super.apply(this, arguments);
        }
        Preload.prototype.preload = function () {
            //  Set-up our preloader sprite
            this.logo = this.add.sprite(PigeonRevenge.game.width / 2, PigeonRevenge.game.height / 2, 'logo');
            this.logo.anchor.set(0.5, 0.5);
            this.load.setPreloadSprite(this.logo);

            //console.log(language);
            var locale = PigeonRevenge.language == "ru_RU" ? "ru" : "en";

            //  Load our actual games assets
            this.load.spritesheet('bomb', 'assets/images/bomb.png', 32, 32);

            this.load.spritesheet('pigeon', 'assets/images/pigeon.png', 32, 32, 16);

            this.load.spritesheet('cow', 'assets/images/npc/cow.png', 64, 48);
            this.load.spritesheet('doyarka', 'assets/images/npc/doyarka.png', 48, 48);
            this.load.spritesheet('goose', 'assets/images/npc/goose.png', 48, 48);
            this.load.spritesheet('glamour_fatty', 'assets/images/npc/glamour_fatty.png', 48, 48);
            this.load.spritesheet('runner_girl', 'assets/images/npc/runner_girl.png', 48, 48);
            this.load.spritesheet('rabbit', 'assets/images/npc/rabbit.png', 32, 32);
            this.load.spritesheet('manager', 'assets/images/npc/manager.png', 32, 64);
            this.load.spritesheet('oldman', 'assets/images/npc/oldman.png', 32, 64);
            this.load.spritesheet('cat', 'assets/images/npc/cat.png', 48, 32);
            this.load.spritesheet('blackguy', 'assets/images/npc/blackguy.png', 32, 64);
            this.load.spritesheet('fat', 'assets/images/npc/fat.png', 56, 64);
            this.load.spritesheet('girl_umbrella', 'assets/images/npc/girl_umbrella.png', 48, 76);

            this.load.spritesheet('explosion', 'assets/images/explosion.png', 50, 50);
            this.load.spritesheet('explosion_bird', 'assets/images/explosion_bird.png', 50, 50);
            this.load.spritesheet('explosion5', 'assets/images/explosion5.png', 64, 80);

            this.load.spritesheet('digit', 'assets/images/digits.png', 18, 34);
            this.load.spritesheet('bomb_bar', 'assets/images/bomb_bar.png', 20, 18);
            this.load.spritesheet('bonus_bomb', 'assets/images/bonus_bomb.png', 64, 64);
            this.load.spritesheet('bonus_life', 'assets/images/bonus_life.png', 64, 64);
            this.load.spritesheet('bonus_freeze', 'assets/images/bonus_freeze.png', 64, 64);
            this.load.image('bomb_icon', "assets/images/bomb_icon.png");
            this.load.image('lifes_icon', "assets/images/lifes_icon.png");
            this.load.spritesheet('skull', 'assets/images/skull.png', 24, 24);

            this.load.image('level1_back', "assets/images/" + PigeonRevenge.game.height + "/level1_back.png");
            this.load.image('level1_ground', "assets/images/" + PigeonRevenge.game.height + "/level1_ground.png");
            this.load.image('level2_back', "assets/images/" + PigeonRevenge.game.height + "/level2_back.png");
            this.load.image('level2_ground', "assets/images/" + PigeonRevenge.game.height + "/level2_ground.png");
            this.load.image('menu', "assets/images/" + PigeonRevenge.game.height + "/pigeon_menu.png");

            this.load.image('tutorial', "assets/locale/" + locale + "/" + PigeonRevenge.game.height + "/pigeon_tutorial.png");
            this.load.image('menu_logo', "assets/locale/" + locale + "/game_name.png");
            this.load.image('btn_howto', "assets/locale/" + locale + "/btn_howto.png");
            this.load.image('btn_game', "assets/locale/" + locale + "/btn_game.png");
            this.load.image('txt_score', "assets/locale/" + locale + "/txt_score.png");
            this.load.image('txt_score_best', "assets/locale/" + locale + "/txt_bestscore.png");
            this.load.image('txt_paused', "assets/locale/" + locale + "/txt_paused.png");
            this.load.image('txt_gameover', "assets/locale/" + locale + "/txt_gameover.png");
            this.load.image('txt_tutorial_completed', "assets/locale/" + locale + "/txt_tutorial_completed.png");

            this.load.image('btn_pause', "assets/images/btn_pause.png");
            this.load.image('btn_mainmenu', "assets/images/btn_mainmenu.png");
            this.load.spritesheet('x2', "assets/images/x2.png", 84, 64);
            this.load.spritesheet('x5', "assets/images/x5.png", 84, 64);
        };

        Preload.prototype.create = function () {
            var tween = this.add.tween(this.logo).to({ alpha: 0 }, 4000, Phaser.Easing.Linear.None, true);
            tween.onComplete.add(this.startMainMenu, this);
        };

        Preload.prototype.startMainMenu = function () {
            PigeonRevenge.game.state.start('MainMenu', true, false);
        };
        return Preload;
    })(Phaser.State);
    PigeonRevenge.Preload = Preload;
})(PigeonRevenge || (PigeonRevenge = {}));
var PigeonRevenge;
(function (PigeonRevenge) {
    var Target = (function (_super) {
        __extends(Target, _super);
        function Target(x, y, key, frame) {
            _super.call(this, x, y, key, frame);
            this.minBombAmount = 1;
            this.superHit = 0;

            this.anchor.set(0.5);

            PigeonRevenge.game.physics.enable(this, Phaser.Physics.ARCADE);
            this.body.allowGravity = false;
        }
        Target.prototype.init = function () {
            if ((this.x > PigeonRevenge.game.width && this.scale.x > 0) || (this.x < 0 && this.scale.x < 0))
                this.scale.x *= -1;
            //console.log(this.x + " " + this.scale.x);
        };
        return Target;
    })(PigeonRevenge.MySprite);
    PigeonRevenge.Target = Target;

    var SimpleTarget = (function (_super) {
        __extends(SimpleTarget, _super);
        function SimpleTarget(key) {
            _super.call(this, 0, 0, key);
            this.doAttach = true;
            this.doMove = true;

            this.animations.add('move', null, 6, true);
        }
        SimpleTarget.prototype.init = function () {
            this.x = Math.random() > 0.5 ? -50 : PigeonRevenge.game.width + 50;
            _super.prototype.init.call(this);
            if (this.doAttach)
                this.attachToGround();
            if (this.doMove) {
                this.simpleMove();
                if (this.animations.getAnimation('move') != undefined)
                    this.play('move');
            }
        };

        SimpleTarget.prototype.findTargetPosition = function () {
            this.targetPos = this.scale.x > 0 ? PigeonRevenge.game.width + 50 : -50;
        };

        SimpleTarget.prototype.simpleMove = function () {
            var _this = this;
            this.findTargetPosition();
            this.activeTween = PigeonRevenge.game.add.tween(this.position).to({ x: this.targetPos }, Math.abs(this.targetPos - this.x) / this.speed * 1000, Phaser.Easing.Linear.None, true);
            this.activeTween.onComplete.addOnce(function () {
                return _this.destroy();
            }, this);
        };

        SimpleTarget.prototype.attachToGround = function () {
            this.y = PigeonRevenge.game.height - PigeonRevenge.level.ground.height - this.height / 2 + 4;
        };

        SimpleTarget.prototype.freeze = function () {
            this.animations.paused = true;
            this.activeTween.pause();
        };
        return SimpleTarget;
    })(Target);
    PigeonRevenge.SimpleTarget = SimpleTarget;

    var TargetGoose = (function (_super) {
        __extends(TargetGoose, _super);
        function TargetGoose() {
            _super.call(this, 'goose');

            this.scale.set(0.6, 0.6);

            this.speed = 110;
            this.score = 25;
            this.minBombAmount = 3;
        }
        return TargetGoose;
    })(SimpleTarget);
    PigeonRevenge.TargetGoose = TargetGoose;

    var TargetDoyarka = (function (_super) {
        __extends(TargetDoyarka, _super);
        function TargetDoyarka() {
            _super.call(this, 'doyarka');

            this.speed = 90;
            this.score = 15;
        }
        return TargetDoyarka;
    })(SimpleTarget);
    PigeonRevenge.TargetDoyarka = TargetDoyarka;

    var TargetCow = (function (_super) {
        __extends(TargetCow, _super);
        function TargetCow() {
            _super.call(this, 'cow');

            this.speed = 60;
            this.score = 10;
        }
        return TargetCow;
    })(SimpleTarget);
    PigeonRevenge.TargetCow = TargetCow;

    var TargetGlamourFatty = (function (_super) {
        __extends(TargetGlamourFatty, _super);
        function TargetGlamourFatty() {
            _super.call(this, 'glamour_fatty');

            this.speed = 80;
            this.score = 15;
        }
        return TargetGlamourFatty;
    })(SimpleTarget);
    PigeonRevenge.TargetGlamourFatty = TargetGlamourFatty;

    var TargetRunnerGirl = (function (_super) {
        __extends(TargetRunnerGirl, _super);
        function TargetRunnerGirl() {
            _super.call(this, 'runner_girl');

            this.speed = 120;
            this.score = 20;
        }
        return TargetRunnerGirl;
    })(SimpleTarget);
    PigeonRevenge.TargetRunnerGirl = TargetRunnerGirl;

    var TargetRabbit = (function (_super) {
        __extends(TargetRabbit, _super);
        function TargetRabbit() {
            _super.call(this, 'rabbit');
            this.doMove = false;

            this.animations.add('jump', [0, 1], 6, false);
            this.animations.add('land', [3], 6, false);
            this.animations.add('fly', [2], 6, true);

            //this.animations.add('jump_end', [0, 1], 6, true);
            this.speed = 120;
            this.score = 20;
        }
        TargetRabbit.prototype.init = function () {
            _super.prototype.init.call(this);
            this.findTargetPosition();
            this.jump();
        };

        TargetRabbit.prototype.jump = function () {
            var _this = this;
            this.checkPosition();
            this.activeTween = PigeonRevenge.game.add.tween(this.position).to({ y: this.y - 5, x: this.x + this.step(2) }, 2 / this.speed * 1000, Phaser.Easing.Linear.None, true, 100);

            this.activeTween.onStart.addOnce(function () {
                return _this.play('jump');
            }, this);
            this.activeTween.onComplete.addOnce(function () {
                return _this.fly();
            }, this);
        };

        TargetRabbit.prototype.fly = function () {
            var _this = this;
            this.activeTween = PigeonRevenge.game.add.tween(this.position).to({ y: this.y - 24, x: this.x + this.step(30) }, 30 / this.speed * 1000, Phaser.Easing.Linear.None, true);
            this.activeTween.onStart.addOnce(function () {
                return _this.play('fly');
            }, this);
            this.activeTween.onComplete.addOnce(function () {
                _this.activeTween = PigeonRevenge.game.add.tween(_this.position).to({ y: _this.y + 29, x: _this.x + _this.step(20) }, 20 / _this.speed * 1000, Phaser.Easing.Linear.None, true);
                _this.activeTween.onComplete.addOnce(function () {
                    return _this.land();
                }, _this);
            }, this);
        };

        TargetRabbit.prototype.land = function () {
            var _this = this;
            this.activeTween = PigeonRevenge.game.add.tween(this.position).to({ y: this.y + 1, x: this.x + this.step(2) }, 2 / this.speed * 1000, Phaser.Easing.Linear.None, true);
            this.activeTween.onStart.addOnce(function () {
                return _this.play('land');
            }, this);
            this.activeTween.onComplete.addOnce(function () {
                return _this.jump();
            }, this);
        };

        TargetRabbit.prototype.checkPosition = function () {
            var targetReached = this.scale.x > 0 ? this.x > this.targetPos : this.x < this.targetPos;
            if (targetReached)
                this.destroy();
        };

        TargetRabbit.prototype.step = function (amounX) {
            if (this.targetPos > this.x)
                return amounX;
            return -amounX;
        };
        return TargetRabbit;
    })(SimpleTarget);
    PigeonRevenge.TargetRabbit = TargetRabbit;

    var TargetManager = (function (_super) {
        __extends(TargetManager, _super);
        function TargetManager() {
            _super.call(this, 'manager');

            this.speed = 100;
            this.score = 12;
        }
        return TargetManager;
    })(SimpleTarget);
    PigeonRevenge.TargetManager = TargetManager;

    var TargetOldMan = (function (_super) {
        __extends(TargetOldMan, _super);
        function TargetOldMan() {
            _super.call(this, 'oldman');
            this.doMove = false;

            this.speed = 60;
            this.score = 10;

            this.chanceToZZZ = 0.5;

            this.animations.add('walk', [0, 1, 2, 3], 6, true);
            this.animations.add('zzz', [4, 5, 6, 7, 8], 6, false);
        }
        TargetOldMan.prototype.init = function () {
            _super.prototype.init.call(this);
            this.walk();
        };

        TargetOldMan.prototype.walk = function () {
            this.play('walk');
            if (Math.random() < this.chanceToZZZ) {
                var stopPos = PigeonRevenge.game.width / 4 + PigeonRevenge.game.width / 2 * Math.random();
                this.findTargetPosition();
                this.activeTween = PigeonRevenge.game.add.tween(this.position).to({ x: stopPos }, Math.abs(stopPos - this.x) / this.speed * 1000, Phaser.Easing.Linear.None, true);
                this.activeTween.onComplete.addOnce(this.zzz, this);
            } else {
                this.simpleMove();
            }
        };

        TargetOldMan.prototype.zzz = function () {
            var _this = this;
            this.play('zzz');
            this.score *= 5;
            this.superHit = 5;
            this.activeTween = PigeonRevenge.game.add.tween(this.position).to({ x: this.targetPos }, Math.abs(this.targetPos - this.x) / this.speed * 1000, Phaser.Easing.Linear.None, true, 1500);
            this.activeTween.onStart.addOnce(function () {
                _this.score /= 5;
                _this.superHit = 0;
                _this.play('walk');
            }, this);
            this.activeTween.onComplete.addOnce(function () {
                return _this.destroy();
            }, this);
        };
        return TargetOldMan;
    })(SimpleTarget);
    PigeonRevenge.TargetOldMan = TargetOldMan;

    var TargetFat = (function (_super) {
        __extends(TargetFat, _super);
        function TargetFat() {
            _super.call(this, 'fat');

            this.speed = 80;
            this.score = 30;

            this.minBombAmount = 4;
        }
        return TargetFat;
    })(SimpleTarget);
    PigeonRevenge.TargetFat = TargetFat;

    var TargetCat = (function (_super) {
        __extends(TargetCat, _super);
        function TargetCat() {
            _super.call(this, 'cat');

            this.speed = 130;
            this.score = 30;
        }
        return TargetCat;
    })(SimpleTarget);
    PigeonRevenge.TargetCat = TargetCat;

    var TargetGirlWithUmbrella = (function (_super) {
        __extends(TargetGirlWithUmbrella, _super);
        function TargetGirlWithUmbrella() {
            _super.call(this, 'girl_umbrella');

            this.speed = 80;
            this.score = 15;

            this.chanceToPutDownUmbrella = 0.7;

            this.animations.add('walk', [0, 1, 2, 3], 6, true);
            this.animations.add('put_down', [4, 5, 6, 7, 8], 6, false);
            this.animations.add('put_up', [9, 10], 6, false);

            this.doMove = false;
        }
        TargetGirlWithUmbrella.prototype.init = function () {
            _super.prototype.init.call(this);
            this.walk();
        };

        TargetGirlWithUmbrella.prototype.walk = function () {
            var _this = this;
            this.play('walk');
            if (Math.random() < this.chanceToPutDownUmbrella) {
                var stopPos = PigeonRevenge.game.width / 4 + PigeonRevenge.game.width / 2 * Math.random();
                this.findTargetPosition();
                this.activeTween = PigeonRevenge.game.add.tween(this.position).to({ x: stopPos }, Math.abs(stopPos - this.x) / this.speed * 1000, Phaser.Easing.Linear.None, true);
                this.activeTween.onComplete.addOnce(function () {
                    return _this.putDownUmbrella();
                }, this);
            } else {
                this.simpleMove();
            }
        };

        TargetGirlWithUmbrella.prototype.putDownUmbrella = function () {
            var _this = this;
            this.play('put_down');
            this.activeTween = PigeonRevenge.game.add.tween(this.position).to({ x: (this.scale.x > 0 ? this.x + 40 : this.x - 40) }, 40 / this.speed * 1000, Phaser.Easing.Linear.None, true);

            if (this.animations.currentAnim)
                this.animations.currentAnim.onComplete.addOnce(function () {
                    _this.score *= 5;
                    _this.superHit = 5;
                    _this.activeTween = PigeonRevenge.game.add.tween(_this.position).to({}, 400, Phaser.Easing.Linear.None, true);
                    _this.activeTween.onComplete.addOnce(function () {
                        _this.play('put_up');
                        if (_this.animations.currentAnim)
                            _this.animations.currentAnim.onComplete.addOnce(function () {
                                _this.play('walk');
                                _this.score /= 5;
                                _this.superHit = 0;
                                _this.activeTween = PigeonRevenge.game.add.tween(_this.position).to({ x: _this.targetPos }, Math.abs(_this.targetPos - _this.x) / _this.speed * 1000, Phaser.Easing.Linear.None, true);
                                _this.activeTween.onComplete.addOnce(function () {
                                    return _this.destroy();
                                }, _this);
                            }, _this);
                    }, _this);
                }, this);
        };
        return TargetGirlWithUmbrella;
    })(SimpleTarget);
    PigeonRevenge.TargetGirlWithUmbrella = TargetGirlWithUmbrella;

    var TargetBlackguy = (function (_super) {
        __extends(TargetBlackguy, _super);
        function TargetBlackguy() {
            _super.call(this, 'blackguy');

            this.speed = 100;
            this.score = 25;
        }
        return TargetBlackguy;
    })(SimpleTarget);
    PigeonRevenge.TargetBlackguy = TargetBlackguy;
})(PigeonRevenge || (PigeonRevenge = {}));
//# sourceMappingURL=app.js.map
