
var adsManager;
var adsLoader;
var adDisplayContainer;
var intervalTimer;
var skipButton;
var videoContent;
var postAdsCallback;

var countdownTimer;


function startGameAfterAds() {
  var elem = document.getElementById("mainContainer");
  elem.parentNode.removeChild(elem);
  
  PigeonRevenge.game = new PigeonRevenge.Game();
}

function initAd() {
  videoContent = document.getElementById('content');
  skipButton = document.getElementById('skipButton');
  skipButton.addEventListener('click', startGameAfterAds);
  
  var seconds = 5;
  var second = 0;
  
  skipButton.firstChild.data = 'Skip in ' + seconds + ' seconds';
  skipButton.disabled = true;

  countdownTimer = setInterval(function() {
        second++;
        if (second >= seconds) {
          skipButton.firstChild.data = 'Skip';
          skipButton.disabled = false;
          clearInterval(interval);
        }
        else
          skipButton.firstChild.data = 'Skip in ' + (seconds - second) + ' seconds';
    }, 1000);
}

function createAdDisplayContainer() {
  // We assume the adContainer is the DOM id of the element that will house
  // the ads.
  adDisplayContainer =
      new google.ima.AdDisplayContainer(document.getElementById('adContainer'));
}

function requestAds() {
  // Create the ad display container.
  createAdDisplayContainer();
  // Initialize the container. Must be done via a user action on mobile devices.
  adDisplayContainer.initialize();
  // Create ads loader.
  adsLoader = new google.ima.AdsLoader(adDisplayContainer);
  // Listen and respond to ads loaded and error events.
  adsLoader.addEventListener(
      google.ima.AdsManagerLoadedEvent.Type.ADS_MANAGER_LOADED,
      onAdsManagerLoaded,
      false);
  adsLoader.addEventListener(
      google.ima.AdErrorEvent.Type.AD_ERROR,
      onAdError,
      false);

  // Request video ads.
  var adsRequest = new google.ima.AdsRequest();
  adsRequest.adTagUrl =
 /*
    'http://pubads.g.doubleclick.net/gampad/ads?sz=400x300&' +
    'iu=%2F6062%2Fiab_vast_samples&ciu_szs=300x250%2C728x90&gdfp_req=1&' +
    'env=vp&output=xml_vast2&unviewed_position_start=1&url=' +
    '[referrer_url]&correlator=[timestamp]&cust_params=iab_vast_samples' +
    '%3Dlinear';
*/    
    'http://googleads.g.doubleclick.net/pagead/ads?ad_type=video_image_flash&client=ca-games-pub-8207118632167407&description_url=http%3A%2F%2Fstarwind-games.com%2Fgames%2Fpigeonrevenge%2Fpage.html&videoad_start_delay=0&hl=en&max_ad_duration=30000';

    //'http://googleads.g.doubleclick.net/pagead/ads?ad_type=video&client=ca-games-pub-4968145218643279&videoad_start_delay=0&description_url=http%3A%2F%2Fwww.google.com&max_ad_duration=40000&adtest=on';

  // Specify the linear and nonlinear slot sizes. This helps the SDK to
  // select the correct creative if multiple are returned.
  adsRequest.linearAdSlotWidth = 640;
  adsRequest.linearAdSlotHeight = 400;

  //adsRequest.nonLinearAdSlotWidth = 640;
  //adsRequest.nonLinearAdSlotHeight = 150;

  adsLoader.requestAds(adsRequest);
}

function onAdsManagerLoaded(adsManagerLoadedEvent) {
  // Get the ads manager.
  adsManager = adsManagerLoadedEvent.getAdsManager(
      videoContent);  // should be set to the content video element

  // Add listeners to the required events.
  adsManager.addEventListener(
      google.ima.AdErrorEvent.Type.AD_ERROR,
      onAdError);
  adsManager.addEventListener(
      google.ima.AdEvent.Type.CONTENT_PAUSE_REQUESTED,
      onContentPauseRequested);
  adsManager.addEventListener(
      google.ima.AdEvent.Type.CONTENT_RESUME_REQUESTED,
      onContentResumeRequested);
  adsManager.addEventListener(
      google.ima.AdEvent.Type.ALL_ADS_COMPLETED,
      onAdEvent);

  // Listen to any additional events, if necessary.
  adsManager.addEventListener(
      google.ima.AdEvent.Type.LOADED,
      onAdEvent);
  adsManager.addEventListener(
      google.ima.AdEvent.Type.STARTED,
      onAdEvent);
  adsManager.addEventListener(
      google.ima.AdEvent.Type.COMPLETE,
      onAdEvent);

  try {
    // Initialize the ads manager. Ad rules playlist will start at this time.
    adsManager.init(640, 360, google.ima.ViewMode.NORMAL);
    // Call play to start showing the ad. Single video and overlay ads will
    // start at this time; the call will be ignored for ad rules.
    adsManager.start();
  } catch (adError) {
    // An error may be thrown if there was a problem with the VAST response.
    videoContent.play();
  }
}

function onAdEvent(adEvent) {
  // Retrieve the ad from the event. Some events (e.g. ALL_ADS_COMPLETED)
  // don't have ad object associated.
  var ad = adEvent.getAd();
  switch (adEvent.type) {
    case google.ima.AdEvent.Type.LOADED:
      // This is the first event sent for an ad - it is possible to
      // determine whether the ad is a video ad or an overlay.
      if (!ad.isLinear()) {
        // Position AdDisplayContainer correctly for overlay.
        // Use ad.width and ad.height.
      }
      break;
    case google.ima.AdEvent.Type.STARTED:
      // This event indicates the ad has started - the video player
      // can adjust the UI, for example display a pause button and
      // remaining time.
      if (ad.isLinear()) {
        // For a linear ad, a timer can be started to poll for
        // the remaining time.
        intervalTimer = setInterval(
            function() {
              var remainingTime = adsManager.getRemainingTime();
            },
            300); // every 300ms
      }
      break;
    case google.ima.AdEvent.Type.COMPLETE:
      // This event indicates the ad has finished - the video player
      // can perform appropriate UI actions, such as removing the timer for
      // remaining time detection.
      if (ad.isLinear()) {
        clearInterval(intervalTimer);
      }
      startGameAfterAds();
      break;
  }
}

function onAdError(adErrorEvent) {
  // Handle the error logging.
  console.log(adErrorEvent.getError());
  try {
    adsManager.destroy();
  } catch (adError) {
  }
  startGameAfterAds();
}

function onContentPauseRequested() {
  videoContent.pause();
  // This function is where you should setup UI for showing ads (e.g.
  // display ad timer countdown, disable seeking etc.)
  // setupUIForAds();
}

function onContentResumeRequested() {
  videoContent.play();
  // This function is where you should ensure that your UI is ready
  // to play content. It is the responsibility of the Publisher to
  // implement this function when necessary.
  // setupUIForContent();

}

