/**
 * MyApp.js v1.0
 * Data for app creation
 * Copyright (c) 2013 Simiula, http://simiula.com
 */

// 1 == awesome , 2==entypo , etc.
var FONT_AWESOME_ID = 1
var FONT_ENTYPO_ID = 2

var SELECTED_BORDER = 0
var SELECTED_BACKGROUND = 1
var SELECTED_FILL = 2

var choosenIconSetID = FONT_AWESOME_ID;
var choosenIconID = 1;
var choosenIconName = "music";
var choosenIconUnicode = "\uf001";
var choosenFontName = "Arial";

var arrayOfColors = ["ffffff", "cdcdcd", "a7a7a7" , "0073b9" , "00bff0" , "0afffa" , "3fb34f" , "add278" , "fff373" , "fff02a" ,  "f48e5c" , "eb212e" , "ea148c"  , "f29bc1" , "a666a7" , "902c8e" , "7c4807" , "f8ad85" , "666666" , "000000"  ];

var fillColor = "000000";
var borderColor = "ff0000";
var backgroundColor = "eeeeee";
var currentSelection = SELECTED_FILL; 
var preferredItems = Array();
var statusStoreButton = false;

var canvas = '';
var canvasURL = "";
var context = "";
var currentPage = '';


function getQueryVariable(variable) {
       var query = window.location.search.substring(1);
       var vars = query.split("&");
       for (var i=0;i<vars.length;i++) {
               var pair = vars[i].split("=");
               if(pair[0] == variable){return pair[1];}
       }
       return(false);
}



function choosedFont( id, name , unicode ) {
	//alert( id + ' ' + name + ' ' + unicode );
	choosenIconID = id;
	choosenIconName = name;
	choosenIconUnicode = unicode;

 	// go to page create
	document.querySelector('#create').className = 'current';
 	document.querySelector('[data-position="current"]').className = 'left';
 	currentPage = document.querySelector('#create');
	showChoosedIcon();
}


function showChoosedIcon() {
 
	var HTML = "";

	/* color palettepopup 
	HTML += '<div id="popup-cover-container">';
	HTML += '<div class="color-palette-container">';
	var itemsCounter = 1;
	for (key in arrayOfColors) {
		var borderColor = '#000000';
		if ( arrayOfColors[key] == "000000" )
			borderColor = '#ffffff';
	 	HTML += "\r" + '<div class="color-palette-item" style="border: 1px solid ' + borderColor + '; background-color: #' + arrayOfColors[key] + '" id="colorPalette' + itemsCounter + '"></div>';
		itemsCounter++;
	}; 
	HTML += '</div></div>';
	*/

	/* palette bottons */
	HTML += '<div class="icon-choosed-container">';
	HTML += '<div class="icon-palette-buttons-container"><p>Change Colors</p>';
	HTML += '<div class="myapp-palette-button" id="popPaletteBkg">';
	HTML += '<span class="icon-home-awesome" id="icon-button-background">&#xf04d;</span>';
	HTML += '<br />Background';
	HTML += '</div>';

	HTML += '<div class="myapp-palette-button" id="popPaletteFill">';
	HTML += '<span class="icon-home-awesome" id="icon-button-fill">&#xf0a3;</span>';
	HTML += '<br />Fill';
	HTML += '</div>';

	HTML += '<div class="myapp-palette-button" id="popPaletteBorder">';
	HTML += '<span class="icon-home-awesome" id="icon-button-border">&#xf096;</span>';
	HTML += '<br />Border';
	HTML += '</div>';

	HTML += '<div><br />';

	
	/* canvas */
	HTML += '<div class="icon-choosed-canvas-container"><canvas id="icon-canvas"></canvas></div>';

	HTML += '<div>';

	$('#create').find('#pageCreateButtons').html(HTML);
	
	document.querySelector('#popPaletteBkg').addEventListener ('click', function () {
	  popUpPalette( SELECTED_BACKGROUND );
	});
	document.querySelector('#popPaletteFill').addEventListener ('click', function () {
	  popUpPalette( SELECTED_FILL );
	});
	document.querySelector('#popPaletteBorder').addEventListener ('click', function () {
	  popUpPalette( SELECTED_BORDER );
	});


	createButtonsOnColorPalette();
	setCurrentColorOnButtons();

  	var section =  $(currentPage).find('#icon-canvas');
    canvas = section[0]; // convert to real canvas pointer		

	drawIconOncanvas();


}


function clrIconOncanvas(){ 
	if ( canvas ) {
		// 3. Obtain a 2D context from the canvas element.
		context = canvas.getContext("2d");
		context.fillStyle = "#FFFFFF";;
		//context.fillRect(0, 0, canvas.width, canvas.height);
		context.clearRect(0, 0, canvas.width, canvas.height);
	
		context.fillStyle = backgroundColor;
		context.fillRect(0, 0, canvas.width, canvas.height);
	}
}

function drawIconOncanvas(){ 
	// 3. Obtain a 2D context from the canvas element.
	context = canvas.getContext("2d");
	context.fillStyle = "#FFFFFF";;
	//context.fillRect(0, 0, canvas.width, canvas.height);
	context.clearRect(0, 0, canvas.width, canvas.height);

	context.fillStyle = backgroundColor;
	context.fillRect(0, 0, canvas.width, canvas.height);
	var x = canvas.width / 2;
	var y = canvas.height / 2;
	context.fillStyle = 'transparent';
	context.strokeStyle = borderColor;
	context.lineWidth = 6;
	context.textAlign = 'center';
	if ( choosenIconSetID == FONT_AWESOME_ID ) {
		context.font = "normal 150px FontAwesome";
		context.strokeText(choosenIconUnicode, x, canvas.height - 12);
		context.fillStyle = fillColor;
		context.fillText(choosenIconUnicode, x, canvas.height - 12);
	} else if ( choosenIconSetID == FONT_ENTYPO_ID ) {
		context.font = "250px Entypo";
		context.strokeText(choosenIconUnicode, x, canvas.height - 12);
		context.fillStyle = fillColor;
		context.fillText(choosenIconUnicode, x, canvas.height - 12);
	}
	//var dataUrl = canvas.toDataURL();
	//alert( dataUrl );
	//window.open(dataUrl, "toDataURL() image", "width=600, height=200");

}

function saveCanvasToURL(){ 
	var dataUrl = canvas.toDataURL("image/jpeg", 90);
	return( dataUrl );
}

function createUniqueFilename() {
	resumeState();
	localStorage["simiula.piktograms.createdImages"]++;
	saveState();
	var filename = "piktogram_" + localStorage["simiula.piktograms.createdImages"] + ".png";
	return( filename );
}

function saveToGallery() {
	canvasURL = saveCanvasToURL();
	
	if ( _gaq != undefined ) {
		_gaq.push(['_trackPageview', '/GA-Virtual/piktogram-save']);
	}

	// Export to blob and share through a Web Activitiy
	canvas.toBlob(function (blob) {
		var gallery = navigator.getDeviceStorage("pictures");
		var filename = createUniqueFilename();
		var request = gallery.addNamed(blob, filename );
		request.onsuccess = function () {
			alert("saved to Gallery");
		}
		
		request.onerror = function () {
			alert('error \n' + this.error.name + '\n' + filename  );
		}
	});

}

function share() {
	if ( _gaq != undefined ) {
		_gaq.push(['_trackPageview', '/GA-Virtual/piktogram-share']);
	}

	canvas.toBlob(function (blob) {
		var sharingImage = new MozActivity({
			name: "share",
			data: {
				type: "image/*",
				number: 1,
				blobs: [blob],
				filenames: [createUniqueFilename()],
				filepaths: ["piktograms/"]
			}
		});
	});

}


/* list page */

function createIconList() {
	
	clrIconOncanvas();

	var HTML ="";
	var itemsCounter = 1;	
	flagAdWordsInList = false;
	
	// create first icon set
	var fontList = createFontAwesomeList();
	
	HTML += '<header><h2>Font Awesome</h2></header>';
	HTML += '<ul class="pageListItemsList">' ;
	for (key in fontList) {
		var tmpFont = fontList[key];
		var lineHTML = "\r" + '<li class="icon-border icon-border-awesome" id="icon' + itemsCounter + '" iconid="' + key + '"  chooseniconsetid="' + FONT_AWESOME_ID + '" iconname="' +  tmpFont['css'] + '" iconunicode="' +  tmpFont['unicode'] + '"><div class="icon-border-awesome">' + tmpFont['unicode'] + '</div></li>';
		HTML += lineHTML ;

		itemsCounter++;
	}
	HTML += '</ul>';
	HTML += '<div class="clear">&nbsp;<br /></div>';

	// append the second set

	var fontList = createFontEntypoList();
	HTML += '<header><h2>Font Entypo</h2></header><br />';
	HTML += '<ul class="pageListItemsList">';
	for (key in fontList) {
		var tmpFont = fontList[key];
		HTML += '<li class="icon-border icon-border-entypo" id="icon' + itemsCounter + '" iconid="' + key + '" chooseniconsetid="' + FONT_ENTYPO_ID + '" iconname="' +  tmpFont['css'] + '" iconunicode="' +  tmpFont['unicode'] + '"><div class="icon-border-entypo icon-entypo-browser-gecko">' + tmpFont['unicode'] + '</div></li>';
		itemsCounter++;
	}
	HTML += '</ul>';
	HTML += '<div class="clear" style="min-height: 80px">&nbsp;<br /><br /></div>';

	// append to the page

	$('#listItems').find('#pageListItems').html(HTML);
	
	for ( var i=0; i < itemsCounter ; i++ ) {
		$('#listItems').find('#icon' + i ).click(function() {
			choosenIconSetID = $(this).attr( "chooseniconsetid" );
			choosedFont( $(this).attr( "iconid" ) , $(this).attr( "iconname" ) , $(this).attr( "iconunicode" ));
		});
	}

}



/* ************** Color Palette ***************** */

function createButtonsOnColorPalette() {
	var itemsCounter = 1;	
	for (key in arrayOfColors) {
		$('#create').find('#colorPalette' + itemsCounter ).click(function() {
			changeColorSelected( $(this).css( "backgroundColor" ) );
		});
		itemsCounter++;
	}; 

}


function popUpPalette( changeColorType ) {
	currentSelection = changeColorType;
	$('#create').find('#popup-cover-container').fadeIn('fast', function() {
		// Animation complete
	});
}

function setCurrentColorOnButtons() {
	$(currentPage).find('#icon-button-background').css( "color" , backgroundColor );
	$(currentPage).find('#icon-button-border').css( "color" , borderColor );
	$(currentPage).find('#icon-button-fill').css( "color" , fillColor );

}

function changeColorSelected( color ) {
	$(currentPage).find('#popup-cover-container').fadeOut('fast', function() {
		// Animation complete
	});
	//$('#popup-cover-container').css( "display" , "none" );
	
	if ( currentSelection == SELECTED_BORDER  ) {
		borderColor = color;
	} else if ( currentSelection == SELECTED_BACKGROUND  ) {
		backgroundColor = color;
	} else if ( currentSelection == SELECTED_FILL  ) {
		fillColor = color;
	}
	setCurrentColorOnButtons();
	saveState();
	drawIconOncanvas();

}

/* ************** Preferred items ***************** */

function editStartupSetPreferredButton() {
	if ( preferredItemsCheckIfExist( choosenIconID , choosenIconSetID ) ) {
		statusStoreButton = true;
	}
}

function preferredButtonStatus() {
	if ( statusStoreButton ) {
		$(currentPage).find('#edit-store-icon').css( "color" , "#ff0000" );
		$(currentPage).find('#edit-store-icon').html( "&#xf004;" ); // heart
	} else {
		$(currentPage).find('#edit-store-icon').css( "color" , "#ffffff" );
		$(currentPage).find('#edit-store-icon').html( "&#xf08a;" ); // heart empty
	}
} 

function preferredItemsAdd() {
	resumeState();
	var record = new MyItemObject();
	record.choosenIconSetID = choosenIconSetID;
	record.choosenIconID = choosenIconID;
	record.choosenIconName = choosenIconName;
	record.choosenIconUnicode = choosenIconUnicode;
	record.choosenFontName = choosenFontName;
	record.fillColor = fillColor;
	record.borderColor = borderColor;
	record.backgroundColor = backgroundColor;
	preferredItems.push( record );
	saveState();
	statusStoreButton = true;

	//preferredButtonStatus();
	alert('Saved');
}

function preferredItemsCheckIfExist( iconID , fontSetID ) {
	var charToCheck = String.fromCharCode(iconID);
	//alert(preferredItems.length);
	var arrayLength = preferredItems.length;
	var counter = 0;
	if ( arrayLength > 0 ) {
		for (var i = 0; i < arrayLength; i++) {
			var record = preferredItems[i];
			//	alert( record.choosenIconID + ' == ' + iconID + ' - ' + record.choosenIconSetID + '==' + fontSetID );
			if ( record.choosenIconID == iconID && record.choosenIconSetID == fontSetID )
				return( true );
			counter++;	
		};
	}
	return false;
}

function preferredItemsRemove( iconID , fontSetID ) {
	var arrayLength = preferredItems.length;
	var counter = 0;
	if ( arrayLength > 0 ) {
		for (var i = 0; i < arrayLength; i++) {
			var record = preferredItems[i];
			if ( record.choosenIconID == iconID && record.choosenIconSetID == fontSetID ) {
				//alert( record.choosenIconID + ' == ' + iconID + ' - ' + record.choosenIconSetID + '==' + fontSetID );
				preferredItems.splice(counter, 1);
				return;
			} else
				counter++;
		};
	}
}

function preferredItemsDebugList() {
	//resumeState();
	var HTML = '<div id="debug-preferred">Debug ';
	var arrayLength = preferredItems.length;
	if ( arrayLength > 0 ) {
		HTML += 'array len:' + arrayLength + '<br />';
		HTML += '<table>';
		for (var i = 0; i < arrayLength; i++) {
			var record = preferredItems[i];
			HTML += '<tr>';
			HTML += '<td>' + record.choosenIconSetID + '</td>';
			HTML += '<td>' + record.choosenIconID + '</td>';
			HTML += '<td>' + record.choosenIconName + '</td>';
			HTML += '<td>' + record.choosenIconUnicode + '</td>';
			HTML += '<td>' + record.choosenFontName + '</td>';
			HTML += '<td>' + record.fillColor + '</td>';
			HTML += '<td>' + record.borderColor + '</td>';
			HTML += '<td>' + record.backgroundColor + '</td>';
			HTML += '</tr>';
		};
		HTML += '</table>';
	}
	HTML += '</div>';
	return ( HTML );
}

function createPreferredIconList() {
	resumeState();
	//var HTML = preferredItemsDebugList();

	var itemsCounter = 1;	
	var arrayLength = preferredItems.length;
	if ( arrayLength > 0 ) {
		$(currentPage).find('#pageCollectionList').append('<ul class="app-list">');
		var fontListAwesome = createFontAwesomeList();
		var fontListEntypo = createFontEntypoList();

		for (var i = 0; i < arrayLength; i++) {
			var record = preferredItems[i];

			var tmpChoosenIconName = record.choosenIconName;
			var tmpChoosenIconUnicode = record.choosenIconUnicode;
			var tmpFillColor = record.fillColor;
			var tmpBorderColor = record.borderColor;
			var tmpBackgroundColor = record.backgroundColor;
// alert(record.choosenIconID );
			if ( record.choosenIconSetID == FONT_AWESOME_ID ) {
				var tmpFont = fontListAwesome[record.choosenIconID];
				var lineHTML = "\r" + '<li class="icon-border icon-border-awesome" style="background-color: ' + record.backgroundColor + '" id="icon' + itemsCounter + '" iconid="' + record.choosenIconID + '"  mybackgroundColor="' + record.backgroundColor + '" myborderColor="' + record.borderColor + '" myfillColor="' + record.fillColor + '" chooseniconsetid="' + record.choosenIconSetID + '" iconname="' +  tmpFont['css'] + '" iconunicode="' +  tmpFont['unicode'] + '"><div class="icon-awesome" style="color: ' + record.fillColor + ';">' + tmpFont['unicode'] + '</div></li>';
				$(currentPage).find('#pageCollectionList').append(lineHTML);
			} else if ( record.choosenIconSetID == FONT_ENTYPO_ID ) {
				var tmpFont = fontListEntypo[record.choosenIconID];
				var lineHTML = '<li class="icon-border icon-border-entypo" style="background-color: ' + record.backgroundColor + '" id="icon' + itemsCounter + '" iconid="' + record.choosenIconID + '"  mybackgroundColor="' + record.backgroundColor + '" myborderColor="' + record.borderColor + '" myfillColor="' + record.fillColor + '" chooseniconsetid="' + record.choosenIconSetID + '" iconname="' +  tmpFont['css'] + '" iconunicode="' +  tmpFont['unicode'] + '"><div class="icon-entypo XXX" style="color: ' + record.fillColor + ';">' + tmpFont['unicode'] + '</div></li>';

				lineHTML = lineHTML.replace( "XXX" , "icon-entypo-browser-gecko");
				$(currentPage).find('#pageCollectionList').append(lineHTML);

			}
			$(currentPage).find('#icon' + itemsCounter ).click(function() {
				choosenIconSetID = $(this).attr( "chooseniconsetid" );
				if ( choosenIconSetID == FONT_AWESOME_ID )
					fontList = createFontAwesomeList();
				else if ( choosenIconSetID == FONT_ENTYPO_ID )
					fontList = createFontEntypoList();
				fillColor = $(this).attr( "myfillColor" );
				borderColor = $(this).attr( "myborderColor" );
				backgroundColor = $(this).attr( "mybackgroundColor" );

				choosedFont( $(this).attr( "iconid" ) , $(this).attr( "iconname" ) , $(this).attr( "iconunicode" ));
			});

			itemsCounter++;
		};

		var random = Math.ceil( Math.random() * 8 );
		bannerCount = random;
		$(currentPage).find('#pageCollectionList').append('</ul>');
		$(currentPage).find('#pageCollectionList').append('<div class="clear"></div>');
	} else {
		$(currentPage).find('#pageCollectionList').append('<div class="about-section">No saved Piktograms found.<br /><br />To save a piktogram<br />create and then tap on the bar icon <span class="icon-bar-awesome">&#xf019;</span>.</div>');
		//var HTML = preferredItemsDebugList();
		//$(currentPage).find('#pageCollectionList').append( HTML );
		//alert( preferredItemsDebugList() );
	}

}

/* ************** Local storage ***************** */

function MyItemObject()
{
  this.choosenIconSetID;
  this.choosenIconID;
  this.choosenIconName;
  this.choosenIconUnicode;
  this.choosenFontName;
  this.fillColor;
  this.borderColor;
  this.backgroundColor;
}

function supportsLocalStorage() {
  try {
    return 'localStorage' in window && window['localStorage'] !== null;
  } catch (e) {
    return false;
  }
}

function saveState() {
    if (!supportsLocalStorage()) { return false; }
    localStorage["simiula.piktograms.fillColor"] = fillColor;
    localStorage["simiula.piktograms.borderColor"] = borderColor;
    localStorage["simiula.piktograms.backgroundColor"] = backgroundColor;
    // convert array to be stored
 //   alert( preferredItemsDebugList() );
//     localStorage["simiula.piktograms.preferredItems"] = "";
	localStorage["simiula.piktograms.preferredItems"] = JSON.stringify(preferredItems);

    return true;
}

// test link: http://192.168.50.252/sec/test2013-dino/televoter/test.html

function resumeState() {
    if (!supportsLocalStorage()) { return false; }
    fillColor = localStorage["simiula.piktograms.fillColor"];
    borderColor = localStorage["simiula.piktograms.borderColor"];
    backgroundColor = localStorage["simiula.piktograms.backgroundColor"];
    if ( localStorage["simiula.piktograms.preferredItems"] ) {
	    preferredItems = JSON.parse(localStorage["simiula.piktograms.preferredItems"]); 
	    //alert( preferredItemsDebugList() );
	}
    return true;
}

function readPageNameFromURL() {
	var url = window.location.pathname;  
    var pageName = url.substring(url.lastIndexOf('/') + 1); 
    var pageNameArray=pageName.split("?");
	var nameWithoutParams=pageNameArray[0];
    return ( nameWithoutParams );
}





