var POINT = false;
var DIGITS = 0;
var COMMENTS = {
    'bad': "Come on! I bet you can do better than that!",
    'not bad': "Not bad! Wanna try it again?",
    'good': "Good! Try improving it",
    'nice': "Very nice! Keep it up!",
    'awesome': "Wow! Awesome memory!"
}

function setEnd(txt) {  
  if (txt.createTextRange) {  
   //IE  
   var FieldRange = txt.createTextRange();  
   FieldRange.moveStart('character', txt.value.length);  
   FieldRange.collapse();  
   FieldRange.select();  
   }  
  else {  
   //Firefox and Opera  
   txt.focus();  
   var length = txt.value.length;  
   txt.setSelectionRange(length, length);  
  }  
}

function updateValue(input) {
    var pi = document.getElementById("pi-text");
    setEnd(pi);
    if (input.value == '.') {
        if (!POINT) {
            POINT = true;
            pi.value += '.';
        }
    }
    else{
        pi.value += input.value;
    }
    verifyPi(pi.value,
             function(){},
             function(){
                gameOver();
             });
}

function clearValue() {
    var pi = document.getElementById("pi-text");
    POINT = false;
    pi.value = pi.value.substring(0,pi.value.length-1);
}

function gameOver() {
    var comment;
    if (DIGITS < 10) {
        comment = 'bad';
    }else if (DIGITS < 50) {
        comment = 'not bad';
    }else if (DIGITS < 80) {
        comment = 'good';
    }else if (DIGITS < 100) {
        comment = 'nice';
    }else {
        comment = 'awesome';
    }
    document.getElementById("comment")
    .innerHTML = COMMENTS[comment];
    document.getElementById("view-result")
    .innerHTML = DIGITS+" DIGITS";
    document.getElementById("game-layout")
    .style.visibility = "hidden";
    document.getElementById("game-over")
    .style.visibility = "visible";
}

function verifyPi(str, onSuccess, onError) {
    if (PI.substring(0, str.length) == str) {
        DIGITS = str.length-2;
        DIGITS < 0 ? DIGITS = 0 : null;
        if (str.length == PI.length) {
            onError();
        }
        onSuccess();
    }
    else onError();
}