var POINT = false;

function setEnd(txt) {  
  if (txt.createTextRange) {  
   //IE  
   var FieldRange = txt.createTextRange();  
   FieldRange.moveStart('character', txt.value.length);  
   FieldRange.collapse();  
   FieldRange.select();  
   }  
  else {  
   //Firefox and Opera  
   txt.focus();  
   var length = txt.value.length;  
   txt.setSelectionRange(length, length);  
  }  
}


function updateValue(input) {
    var pi = document.getElementById("pi-text");
    setEnd(pi);
    if (input.value == '.') {
        if (!POINT) {
            POINT = true;
            pi.value += '.';
        }
    }
    else{
        pi.value += input.value;
    }
    verifyPi(pi.value,
             function(){
                pi.style.background = '#00AACC';
             },
             function(){
                pi.style.background = 'red';
             });
}

function clearValue() {
    var pi = document.getElementById("pi-text");
    POINT = false;
    pi.value = pi.value.substring(0,pi.value.length-1);
    verifyPi(pi.value,
             function(){
                pi.style.background = '#00AACC';
             },
             function(){
                pi.style.background = 'red';
             });
}


function verifyPi(str, onSuccess, onError) {
    if (PI.substring(0, str.length) == str) {
        DIGITS = str.length-2;
        DIGITS < 0 ? DIGITS = 0 : null;
        onSuccess();
    }
    else onError();
}