/*jshint forin:true, noarg:true, noempty:true, eqeqeq:true,
  bitwise:true, strict:true, undef:true, curly:true, browser:true,
  devel:true, indent:2, maxerr:50, moz:true, newcap:false, moz:true */

/*
 * @ TODO double check source to destination mapping
 * @ TODO new info button detailing project / implementation status
 * @ TODO implement Contacts matching & updating
 * @ TODO add support to read file from SD card
 * @ TODO verify operation on real device
 * @ TODO implement calendar import
 * @ TODO implement SMS import
 */

(function () {
    "use strict";

    function restartApp() {
        document.getElementById("InputBlock").style.display = "block";
        document.getElementById("ProgressBlock").style.display = "none";
        document.getElementById("progressUnpack").style.display = "none";
        document.getElementById("progressContactFile").style.display = "none";
        document.getElementById("progressContacts").style.display = "none";
        document.getElementById("progressAppointments").style.display = "none";
        document.getElementById("progressMessages").style.display = "none";
        document.getElementById("protocolBlock").style.display = "none";
        document.getElementById("OK-Button").style.display = "none";
    }

    var PIMimport = PIMimport || {};
    PIMimport.Message = PIMimport.Message || {};

    PIMimport.Message.Type = {
        SUCCESS: 'success',
        LOG: 'log',
        INFO: 'info',
        WARNING: 'warning',
        ERROR: 'error'
    }

    function addUserMessage(msg, msgType) {
        if ((msgType === undefined) || (PIMimport.Message.Type[msgType.toUpperCase()] !== msgType))
            msgType = PIMimport.Message.Type.LOG;
        if (msgType === PIMimport.Message.Type.LOG)
            console.log(msg); // Because we hide it on display
        document.getElementById("protocolBlock").style.display = "block"; // first messages switches on visibility
        document.getElementById("protocolMsg").innerHTML += "<li class=\"" + msgType + "\" >" + msg + "</li>";
        if (msgType === PIMimport.Message.Type.ERROR)
            document.getElementById("OK-Button").style.display = "block";
    }

    function updateProgressBar(elementName, percent) {
        var progressEl = document.getElementById(elementName);
        progressEl.style.display = "block";
        progressEl.value = progressEl.max * percent;
    }

    /**
    * route PIM Files to handling functions
    *
    * @extractedFile e.unarchivedFile from unzip extract event
    * @lastFile bool if this is last file in archive
    *
    */

    function parsePIMFile(extractedFile, fileNumber, fileCount) {
        var fileType = extractedFile.filename.substr(extractedFile.filename.length - 4);

        if (fileType === ".csa") {
            //return parsePIMappointments(extractedFile.fileData, textLng);
        } else if (fileType === ".csl") {
            //return parsePIMlogs(extractedFile.fileData, textLng);
        } else if (fileType === ".csc") {
            var records = importContacts(extractedFile.fileData);
        } else if (fileType === ".xml") {
            if (extractedFile.filename === "OwnerInfos.xml") {
            } else if (extractedFile.filename === "RegionalSettings.xml") {
            } else {
                // handle knirsch.de.xml
            }
        } else if (fileType === ".csm") {
            return parsePIMmessages(extractedFile.fileData);
        } else if (fileType === ".cst") {
            //return parsePIMtasks(extractedFile.fileData, textLng);
        }
        if (fileNumber === fileCount) {
            addUserMessage(fileCount + " File" + ((fileCount !== 1) ? "s" : "") + " extracted from archive", PIMimport.Message.Type.SUCCESS);
        }
    }

    function parsePIMappointments(inStr, textLng) {
        return null;
    }

    /**
    * prepare importing contacts
    *
    * @inStr Typed Array
    *
    * Ask user if we should wipe existing contacts befor import
    *
    */

    function importContacts(inStr) {
        try {
            if (document.getElementById("clearContacts").checked) {
                var cl_req = window.navigator.mozContacts.clear();

                cl_req.onerror = function () {
                    addUserMessage("Cannot clear Contacts database", PIMimport.Message.Type.ERROR);
                };

                cl_req.onsuccess = function () {
                    addUserMessage("Cleared all contacts", PIMimport.Message.Type.SUCCESS);
                    parsePIMcontacts(inStr);
                };
            } else {
                parsePIMcontacts(inStr);
            }
        }
        catch (err) {
            addUserMessage("Error during importing contacts: " + err, PIMimport.Message.Type.ERROR);
        }
    }

    /**
    * parse PIM contacts file
    *
    * @inStr Typed Array
    *
    * split file into lines
    * take first line as field denominator
    * split lines to entries
    * create contacts record and store them
    * 
    * @ TODO: verify storage works in device
    *
    */

    var saved = 0;
    var extracted;  

    function parsePIMcontacts(inStr) {

        var importer = new fileHandler.importer.Contacts(inStr);
        importer.addEventListener("error", function (e) {
            addUserMessage("Extract error: " + e.msg, PIMimport.Message.Type.ERROR);
        });
        importer.addEventListener("success", function (e) {
            extracted = e.recordCnt;
            addUserMessage(e.recordCnt + " Contact" + ((e.recordCnt !== 1) ? "s" : "") + " extracted", PIMimport.Message.Type.SUCCESS);
        });
        importer.addEventListener("warning", function (e) {
            addUserMessage("Extract warning: " + e.msg, PIMimport.Message.Type.WARNING);
        });
        importer.addEventListener("progress", function (e) {
            updateProgressBar("progressContactFile", e.percentDone);
        });
        importer.addEventListener("data", function (e) {
            saveContact(e.data)
        });
        importer.start();
    }

    /**
    * parse PIM mesage file
    *
    * @inStr Typed Array
    *
    * @ TODO: should end up similar to contacts
    *
    */

    function parsePIMmessages(inStr) {
    }

    /**
    * parse PIM contacts file
    *
    * @rec mozContacts
    *
    * save contact
    * 
    * @ TODO: verify storage works in device and/or simulator
    *
    */

    function saveContact(rec) {

        var contact = new mozContact();
        contact.init(rec);

        var sav_req = navigator.mozContacts.save(contact);
        sav_req.onsuccess = function () {
            saved++;
            if (extracted !== undefined)
                updateProgressBar("progressContacts", saved / extracted);
            if (saved === extracted) {
                addUserMessage(saved + " Contact" + ((saved !== 1) ? "s" : "") + " saved", PIMimport.Message.Type.SUCCESS);
                document.getElementById("ProgressBlock").style.display = "none";
                document.getElementById("OK-Button").style.display = "block";
            }
        };

        sav_req.onerror = function () {
            addUserMessage("Failed to save a record", PIMimport.Message.Type.ERROR);
        };
    }

    window.onload = function () {

        document.body.addEventListener("submit",
        function (evt) {

            function updateProgressBarFile(e) {
                if (e.lengthComputable) {
                    updateProgressBar("progressFile", e.loaded / e.total);
                }
            }

            function OnHttpError(e) {
                if( e.target.status !== 0)
                    addUserMessage(e.target.status + "<br />" + e.target.statusText + "<br />" + e.target.readyState, PIMimport.Message.Type.ERROR);
                console.log("HTTP GET OnError Done");
            };

            function OnHttpAbort(e) {
                addUserMessage("HTTP GET Aborted", PIMimport.Message.Type.ERROR);
            };

            function OnHttpLoaded(e) {
                var filesUnpacked = 0;
                var filesInArchive;

                if (req.status !== 200)
                    return;

                var unzipper = new bitjs.archive.Unzipper(req.response, "bitjs-b96e51e0216d/");

                addUserMessage("Archive download complete", PIMimport.Message.Type.SUCCESS);

                unzipper.addEventListener("error", function (e) {
                    addUserMessage("Unpack error: " + e.msg, PIMimport.Message.Type.ERROR);
                });
                unzipper.addEventListener("info", function (e) {
                    addUserMessage("Unpack info: " + e.msg, PIMimport.Message.Type.LOG);
                });
                unzipper.addEventListener("progress", function (e) {
                    updateProgressBar("progressUnpack", (e.currentFileNumber + 1) / e.totalFilesInArchive);
                    if (filesInArchive === undefined)
                        filesInArchive = e.totalFilesInArchive;
                });
                unzipper.addEventListener("extract", function (e) {
                    addUserMessage("extract: " + e.unarchivedFile.filename, PIMimport.Message.Type.LOG);
                    if (filesInArchive === undefined)
                        filesInArchive = 1;
                    parsePIMFile(e.unarchivedFile, ++filesUnpacked, filesInArchive);
                });
                unzipper.addEventListener("finish", function (e) {
                    addUserMessage(filesUnpacked + " File" + ((filesUnpacked !== 1) ? "s" : "") + " Unpacked", PIMimport.Message.Type.SUCCESS);
                });
                unzipper.start();
            };

            function OnHttpStateChange(e) {
                if (req.readyState === 4) // COMPLETED
                    if (req.status !== 200)
                        addUserMessage("Download failed: " + req.status + " " + req.statusText, PIMimport.Message.Type.ERROR);
            };

            document.getElementById("InputBlock").style.display = "none";
            document.getElementById("ProgressBlock").style.display = "block";

            var req = new XMLHttpRequest({ mozSystem: true });
            var URL = document.getElementsByName("URL")[0].value;
            req.open("GET", URL, true);
            req.responseType = "arraybuffer";

            req.onreadystatechange = OnHttpStateChange;
            req.onprogress = updateProgressBarFile;
            req.onerror = OnHttpError;
            req.onabort = OnHttpAbort;
            req.onload = OnHttpLoaded;
            req.onload = OnHttpLoaded;

            req.send();

            evt.stopPropagation();
            evt.preventDefault();
        }, false);

    };

} ());
