/*jshint forin:true, noarg:true, noempty:true, eqeqeq:true,
bitwise:true, strict:true, undef:true, curly:true, browser:true,
devel:true, indent:2, maxerr:50, moz:true, newcap:false, moz:true */

var fileHandler = fileHandler || {};
fileHandler.importer = fileHandler.importer || {};

/*
* @ Module to import a Contacts file
*/
(function() {

// ===========================================================================
// Stolen from Closure because it's the best way to do Java-like inheritance.
fileHandler.base = function(me, opt_methodName, var_args) {
  var caller = arguments.callee.caller;
  if (caller.superClass_) {
    // This is a constructor. Call the superclass constructor.
    return caller.superClass_.constructor.apply(
        me, Array.prototype.slice.call(arguments, 1));
  }

  var args = Array.prototype.slice.call(arguments, 2);
  var foundCaller = false;
  for (var ctor = me.constructor;
       ctor; ctor = ctor.superClass_ && ctor.superClass_.constructor) {
    if (ctor.prototype[opt_methodName] === caller) {
      foundCaller = true;
    } else if (foundCaller) {
      return ctor.prototype[opt_methodName].apply(me, args);
    }
  }

  // If we did not find the caller in the prototype chain,
  // then one of two things happened:
  // 1) The caller is an instance method.
  // 2) This method was not called by the right caller.
  if (me[opt_methodName] === caller) {
    return me.constructor.prototype[opt_methodName].apply(me, args);
  } else {
    throw Error(
        'goog.base called from a method of one name ' +
        'to a method of a different name');
  }
};
fileHandler.inherits = function(childCtor, parentCtor) {
  /** @constructor */
  function tempCtor() {};
  tempCtor.prototype = parentCtor.prototype;
  childCtor.superClass_ = parentCtor.prototype;
  childCtor.prototype = new tempCtor();
  childCtor.prototype.constructor = childCtor;
};
// ===========================================================================

/**
 * An unarchive event.
 *
 * @param {string} type The event type.
 * @constructor
 */
fileHandler.importer.ImportEvent = function(type) {
  /**
   * The event type.
   *
   * @type {string}
   */
  this.type = type;
};

fileHandler.importer.ImportEvent.Type = {
    SUCCESS: 'success',
    DATA: 'data',
    PROGRESS: 'progress',
    LOG: 'log',
    INFO: 'info',
    WARNING: 'warning',
    ERROR: 'error'
}

/**
 * Useful for passing error info up to the client (for debugging).
 *
 * @param {string} msg The info message.
 */
fileHandler.importer.ImportErrorEvent = function(msg) {
  fileHandler.base(this, fileHandler.importer.ImportEvent.Type.ERROR);

  /**
   * The information message.
   *
   * @type {string}
   */
  this.msg = msg;
};
fileHandler.inherits(fileHandler.importer.ImportErrorEvent, fileHandler.importer.ImportEvent);

/**
 * Useful for passing data element up to the client (for storage).
 *
 * @param {string} msg The info message.
 */
fileHandler.importer.ImportDataEvent = function(data) {
  fileHandler.base(this, fileHandler.importer.ImportEvent.Type.DATA);

  this.data = data;
};
fileHandler.inherits(fileHandler.importer.ImportDataEvent, fileHandler.importer.ImportEvent);

/**
 * Useful for passing error info up to the client (for debugging).
 *
 * @param {string} msg The info message.
 */
fileHandler.importer.ImportWarningEvent = function(msg) {
  fileHandler.base(this, fileHandler.importer.ImportEvent.Type.WARNING);

  /**
   * The information message.
   *
   * @type {string}
   */
  this.msg = msg;
};
fileHandler.inherits(fileHandler.importer.ImportWarningEvent, fileHandler.importer.ImportEvent);

/**
 * Useful for passing success info up to the client (for debugging).
 *
 * @param {string} msg The info message.
 */
fileHandler.importer.ImportSuccessEvent = function(recordCnt) {
  fileHandler.base(this, fileHandler.importer.ImportEvent.Type.SUCCESS);

  this.recordCnt = recordCnt;
};
fileHandler.inherits(fileHandler.importer.ImportSuccessEvent, fileHandler.importer.ImportEvent);

/**
 * Useful for passing progress info up to the client (for debugging).
 *
 * @param {string} msg The info message.
 */
fileHandler.importer.ImportProgressEvent = function(recordCnt, percentDone) {
  fileHandler.base(this, fileHandler.importer.ImportEvent.Type.PROGRESS);

  this.recordCnt = recordCnt;
  this.percentDone = percentDone;
};
fileHandler.inherits(fileHandler.importer.ImportProgressEvent, fileHandler.importer.ImportEvent);

/**
 * Base class for all Importers.
 *
 * @param {ArrayBuffer} arrayBuffer The Array Buffer.
 * @param {string} opt_pathToBitJS Optional string for where the BitJS files are located.
 * @constructor
 */
fileHandler.importer.Import = function(arrayBuffer, opt_pathToFileHandler) {
  /**
   * The ArrayBuffer object.
   * @type {ArrayBuffer}
   * @protected
   */
  this.ab = arrayBuffer;

  /**
   * The path to the BitJS files.
   * @type {string}
   * @private
   */
  this.pathToFileHandler_ = opt_pathToFileHandler || '';

  /**
   * A map from event type to an array of listeners.
   * @type {Map.<string, Array>}
   */
  this.listeners_ = {};
  for (var type in fileHandler.importer.ImportEvent.Type) {
    this.listeners_[fileHandler.importer.ImportEvent.Type[type]] = [];
  }
};

/**
 * Private web worker initialized during start().
 * @type {Worker}
 * @private
 */
fileHandler.importer.Import.prototype.worker_ = null;

/**
 * This method must be overridden by the subclass to return the script filename.
 * @return {string} The script filename.
 * @protected.
 */
fileHandler.importer.Import.prototype.getScriptFileName = function() {
  throw 'Subclasses of AbstractUnarchiver must overload getScriptFileName()';
};

/**
 * Adds an event listener for UnarchiveEvents.
 *
 * @param {string} Event type.
 * @param {function} An event handler function.
 */
fileHandler.importer.Import.prototype.addEventListener = function(type, listener) {
  if (type in this.listeners_) {
    if (this.listeners_[type].indexOf(listener) == -1) {
      this.listeners_[type].push(listener);
    }
  }
};

/**
 * Removes an event listener.
 *
 * @param {string} Event type.
 * @param {EventListener|function} An event listener or handler function.
 */
fileHandler.importer.Import.prototype.removeEventListener = function(type, listener) {
  if (type in this.listeners_) {
    var index = this.listeners_[type].indexOf(listener);
    if (index != -1) {
      this.listeners_[type].splice(index, 1);
    }
  }
};

/**
 * Receive an event and pass it to the listener functions.
 *
 * @param {fileHandler.importer.ImportEvent} e
 * @private
 */
fileHandler.importer.Import.prototype.handleWorkerEvent_ = function(e) {
  if ((e instanceof fileHandler.importer.ImportEvent || e.type) && 
      this.listeners_[e.type] instanceof Array) {
    this.listeners_[e.type].forEach(function (listener) { listener(e) });
  } else {
    console.log(e);
  }
};

/**
 * Starts the import in a separate Web Worker thread and returns immediately.
 */
 fileHandler.importer.Import.prototype.start = function() {
  var me = this;
  var scriptFileName = this.pathToFileHandler_ + this.getScriptFileName();
  if (scriptFileName) {
    this.worker_ = new Worker(scriptFileName);

    this.worker_.onerror = function(e) {
      console.log('Worker error: message = ' + e.message);
      throw e;
    };

    this.worker_.onmessage = function(e) {
      if (typeof e.data == 'string') {
        // Just log any strings the workers pump our way.
        console.log(e.data);
      } else {
        // Assume that it is an UnarchiveEvent.  Some browsers preserve the 'type'
        // so that instanceof UnarchiveEvent returns true, but others do not.
        me.handleWorkerEvent_(e.data);
      } 
    };

    this.worker_.postMessage({file: this.ab});
  }
}

/**
 * Contacts
 * @extends {fileHandler.importer.Import}
 * @constructor
 */
fileHandler.importer.Contacts = function(arrayBuffer, opt_pathToFileHandler) {
  fileHandler.base(this, arrayBuffer, opt_pathToFileHandler);
};
fileHandler.inherits(fileHandler.importer.Contacts, fileHandler.importer.Import);
fileHandler.importer.Contacts.prototype.getScriptFileName = function() { return 'contacts.js' };

})();
