fps=null;
hPI=Math.PI/2;
spd=10;
window.requestAnimFrame=window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame;
window.AudioContext=window.AudioContext||window.webkitAudioContext;
context=null;
bufferLoader=null;
cp=null;
cp,sq=null;
sfx=null;
FX={};
context=null;
scores=[0,0,0,0];
var BUFFERS_TO_LOAD={high: 'audio/bounceHgh.mp3',med: 'audio/bounceMed.mp3',low: 'audio/bounceLow.mp3'};
function loadBuffers()
{
	var names=[];
	var paths=[];
	for (var name in BUFFERS_TO_LOAD)
	{
		var path=BUFFERS_TO_LOAD[name];
		names.push(name);
		paths.push(path);
	}
	bufferLoader=new BufferLoader(context,paths,function(bufferList)
	{
		for (var i=0;i<bufferList.length;i++)
		{
			var buffer=bufferList[i];
			var name=names[i];
			FX[name]=buffer;
		}
	});
	bufferLoader.load();
}

document.addEventListener('DOMContentLoaded', function()
{
	window.AudioContext=window.AudioContext||window.webkitAudioContext;
    context=new AudioContext();
	loadBuffers();
});

function exLink(a)
{
	window.open(a,'_blank');
}

function mode(a)
{
	menu(q('.options')[0]);
	setup();
	if (a==0)
	{
		//dark
		p2.c='#000';
		p3.c='#000';
		p4.c='#000';
	}
	else
	{
		//light
		p1.c='#fff';
		p2.c='#fff';
		p3.c='#fff';
		p4.c='#fff';
	}
	b2.c=p2.c;
	b3.c=p3.c;
	b4.c=p4.c;
}
function continueGame()
{
	var a,b;
	a=p1.c;
	b=p1.l;
	toggleV(q('.win')[0]);
	setup();
	p1.c=a;
	p1.l=b;
}

function menu(a)
{
	toggleV(a);
	toggleV(q('.main')[0]);
}

function toggleFX(a)
{
	var b,c;
	b=[1,0];
	c=a.getAttribute('data-value');
	a.setAttribute('data-value',b[c]);
}
window.onload=memory();
function memory()
{
	var a,b;
	a=new String(localStorage.pingQuadVersion);
	if (a.indexOf('.')==-1)
	{
		localStorage.pingQuadVersion='1.00';
		b='0:0';
		localStorage.pingQuadData=JSON.stringify(b);
	}
	b=JSON.parse(localStorage.pingQuadData);
	q('#score')[0].innerHTML=b;
}

function resetData()
{
	var a=confirm("Are you sure you want to reset this Game? If you reset your game your progress will NOT be able to be recovered.");
	if (a==true)
	{
		localStorage.clear();
		memory();
	}
}

function saveData(a)
{
	var b,c,d;
	b=JSON.parse(localStorage.pingQuadData);
	c=b.split(':');
	c[0]=new Number(c[0]);
	c[1]=new Number(c[1]);
	c[a]+=1;
	b=c[0]+':'+c[1];
	localStorage.pingQuadData=JSON.stringify(b);
	q('#score')[0].innerHTML=b;
	q('.ratio')[0].innerHTML=b;
	q('.ratio')[1].innerHTML=b;
}

function restart()
{
	hide(q('.death')[0]);
	hide(q('.pause')[0]);
	hide(q('.win')[0]);
	setup();	
}
function quit()
{
	hide(q('.game')[0]);
	hide(q('.pause')[0]);
	hide(q('.death')[0]);
	hide(q('.win')[0]);
	var a=q('canvas')[0].getContext('2d');
	a.fillStyle='#000';
	a.fillRect(0,0,sq,sq);
	show(q('.menu')[0]);
}
	
function play(buffer,volume)
{
	if (sfx==1)
	{
		var source=context.createBufferSource();
		source.buffer=buffer;
		var gainNode=context.createGain();
		source.connect(gainNode);
		gainNode.connect(context.destination);
		gainNode.gain.value=(volume);
		source.start(0);
	}
}

function Ball(x,y,v,h,c,q)
{
	this.x=x;
	this.y=y;
	this.v=v;
	this.h=h;
	this.q=q;
	this.c=c;
	this.rand=rand;
	this.bounceD=bounceD;
	this.bounceH=bounceH;
	this.bounceV=bounceV;
	function rand()
	{
		var rand=~~(Math.random()*100);
		this.h=~~(spd*(Math.sin(rand)));
		this.v=~~(spd*Math.cos(rand)*-1);
	}

	function bounceD()
	{
		this.h *= -1;
		this.v *= -1;
	}

	function bounceH()
	{
		this.h*=-1;
	}

	function bounceV()
	{
		this.v *= -1;
	}
}

function resume()
{
	hide(q('.pause')[0]);
	animate();
}

function pause()
{
	cancelAnimationFrame(fps);
	show(q('.pause')[0]);
}

function Paddle(x,y,w,h,c,v,l)
{
	this.x=x;
	this.y=y;
	this.w=w;
	this.h=h;
	this.c=c;
	this.v=v;
	this.l=l;
	this.move=move;
	this.hurt=hurt;
	function move(a)
	{
		this.v=a;
	}
	function hurt()
	{
		if (this.l>0)
		{
			this.l-=1;	
		}
		if (this.l==0)
		{
			this.v=0;	
		}
	}
}
function atomic(e)
{
	var keynum=e.which;
	if (keynum==37)
	{
		p1.move(-10);
	}
	else if (keynum==39)
	{
		p1.move(10);
	}
}
function release()
{
	p1.move(0);	
}

function inputMove(a)
{
	p1.move(a);
}
	
function lose()
{
	cancelAnimationFrame(fps);
	saveData(1);
	show(q('.death')[0]);
}

function win()
{
	cancelAnimationFrame(fps);
	saveData(0);
	show(q('.win')[0]);	
}

function setup()
{
	var c=q('canvas')[0];
	cp=c.getContext('2d');
	sq=window.innerHeight;
	c.setAttribute('width',sq);
	c.setAttribute('height',sq);
	scale=(1000/q('canvas')[0].getAttribute('width'));
	sfx=q('[onclick="toggleFX(this)"]')[0].getAttribute('data-value');
	colors=['#c00','#f60','#fc0','#0c0','#0c9','#0cf','#06f','#939','#f66'];
	p1=new Paddle(440,900,160,40,colors[~~(Math.random()*colors.length)],0,10);
	colors.splice(colors.indexOf(p1.c),1);
	p2=new Paddle(60,440,40,160,colors[~~(Math.random()*colors.length)],0,10);
	colors.splice(colors.indexOf(p2.c),1);
	p3=new Paddle(440,60,160,40,colors[~~(Math.random()*colors.length)],0,10);
	colors.splice(colors.indexOf(p3.c),1);
	p4=new Paddle(900,440,40,160,colors[~~(Math.random()*colors.length)],0,10);
	colors.splice(colors.indexOf(p4.c),1);
	b1=new Ball(500,860,0,0,p1.c,[]);
	b2=new Ball(140,500,0,0,p2.c,[]);
	b3=new Ball(500,140,0,0,p3.c,[]);
 	b4=new Ball(860,500,0,0,p4.c,[]);
	b1.rand();
	b2.rand();
	b3.rand();
	b4.rand();
	que(b1);
	que(b2);
	que(b3);
	que(b4);
	hide(q('.menu')[0]);
	show(q('.game')[0]);
	animate();
}
function que(a)
{
	var x,y,z;
	x=a.x;
	y=a.y;
	z=[[x,y]];
	for (i=0;i<10;i++)
	{
		a.q.push(z);	
	}
}
function closeX(a,b)
{
	// a=balls
	// b=paddle
	var c,d,e,f,g;
	c=0;
	d=a.length;
	e=1;
	g=10;
	for (e=1;e<4;e+=1)
	{
		if (Math.abs(b.y-a[e].y)<Math.abs(b.y-a[c].y))
		{
			c=e;
		}
	}
	if (Math.abs(b.x-a[c].x)<Math.abs((b.x+b.w)-a[c].x))
	{
		g=-10;
	}
	b.v=g;
}
function closeY(a,b)
{
	// a=balls
	// b=paddle
	var c,d,e,f,g;
	c=0;
	d=a.length;
	e=1;
	g=10;
	for (e=1;e<4;e+=1)
	{
		if (Math.abs(b.x-a[e].x)<Math.abs(b.x-a[c].x))
		{
			c=e;
		}
	}
	if (Math.abs(b.y-a[c].y)<Math.abs((b.y+b.h)-a[c].y))
	{
		g=-10;
	}
	b.v=g;
}
function animate()
{
	cp.fillStyle='#000';
	cp.fillRect(0,0,sq,sq);
	balls=[b1,b2,b3,b4];
	padds=[p1,p2,p3,p4];
	var i=0;
	for (i=0;i<4;i++)
	{
		b=balls[i];
		z=0;
		for (z=0;z<4;z+=1)
		{
    		if ((z!=i)&&(z<4))
			{
				var l,w,h;
				w=Math.abs(balls[z].x-b.x);
				l=Math.abs(balls[z].y-b.y);
				h=Math.sqrt((l*l)+(w*w));
        		if (h<40) 
				{
					if (w<l)
					{
						//same direction
						if (((balls[z].h>0)&&(b.h>0))||((balls[z].h<0)&&(b.h<0)))
						{
							//balls[z] is ahead
							if (balls[z].x>b.x)
							{
								balls[z].x+balls[z].h;
								balls[z].y+balls[z].v;
								b.bounceH();
							}
							
							else
							{
								b.x+b.h;
								b.y+b.v;
								balls[z].bounceH();
							}
						}
						
						else
						{
							balls[z].bounceH();
							b.bounceH();
						}
					}
					else if (l<w)
					{						
						if (((balls[z].v>0)&&(b.v>0))||((balls[z].v<0)&&(b.v<0)))
						{
							//balls[z] is ahead
							if (balls[z].y>b.y)
							{
								balls[z].y+balls[z].v;
								balls[z].x+balls[z].h;
								b.bounceV();
							}
							
							else
							{
								b.x+b.h;
								b.y+b.v;
								balls[z].bounceV();
							}
						}
						else
						{
							balls[z].bounceV();
							b.bounceV();
						}
					}
					else
					{
						balls[z].bounceD();
						b.bounceD(); 
					}
					var c0=balls[z].c;
					var c1=b.c;
					balls[z].c=c1;
					b.c=c0;
					play(FX.med,0.25);
				}
			}
		}
		if (((((b.x+20)>p1.x)&&((b.x-20)<(p1.x+p1.w)))&&((b.y+20)>p1.y))&&(b.y<(p1.y+p1.h)))
		{
			var tempNum=((b.x-(p1.x+80))/160)*hPI;
			b.h=spd*(Math.sin(tempNum));
			b.v=Math.abs(spd*Math.cos(tempNum))*-1;
			b.c=p1.c;
			play(FX.high,0.25);
		}
		else if ((((b.x-20)<(p2.x+p2.w))&&((b.y-20)<(p2.y+p2.h)&&((b.y+20)>p2.y)))&&(b.x>p2.x))
		{
			var tempNum=((b.y-(p2.y+80))/160)*hPI;
			b.v=spd*(Math.sin(tempNum));
			b.h=Math.abs(spd*Math.cos(tempNum));
			b.c=p2.c;
			play(FX.high,0.25);
		}
		
		else if (((((b.x+20)>p3.x)&&((b.x-20)<(p3.x+p3.w)))&&((b.y-20)<(p3.y+p3.h)))&&(b.y>p3.y))
		{
			var tempNum=((b.x-(p3.x+80))/160)*hPI;
			b.h=spd*(Math.sin(tempNum));
			b.v=Math.abs(spd*Math.cos(tempNum));
			b.c=p3.c;
			play(FX.high,0.25);
		}
		
		else if ((((b.x+20)>p4.x)&&((b.y-20)<(p4.y+p4.h)&&((b.y+20)>p4.y)))&&(b.x<(p4.x+p4.w)))
		{
			var tempNum=((b.y-(p4.y+80))/160)*hPI;
			b.v=spd*(Math.sin(tempNum));
			b.h=Math.abs(spd*Math.cos(tempNum))*-1;
			b.c=p4.c;
			play(FX.high,0.25);
		}
		
		if (b.x>980)
		{
			b.x=980;
			b.bounceH();
			play(FX.low,0.5);
			p4.hurt();
		}
		else if (b.x<20)
		{
			b.x=20;
			b.bounceH();
			play(FX.low,0.5);
			p2.hurt();
		}
		if (b.y<20)
		{
			b.y=20;
			b.bounceV();
			play(FX.low,0.5);
			p3.hurt();

		}
		else if (b.y>980)
		{
			b.y=980;
			b.bounceV();
			play(FX.low,0.5);
			p1.hurt();
		}
		b.x+=b.h;
		b.y+=b.v;
		b.q.unshift([b.x,b.y]);
		b.q.pop();
		cp.strokeStyle=b.c;
		cp.lineCap='round';
		cp.lineWidth=(40/scale);
		cp.beginPath();
		cp.moveTo((b.x/scale),(b.y/scale));
		var ii=0;
		for (ii=0;ii<10;ii++)
		{
			cp.lineTo(b.q[ii][0]/scale,b.q[ii][1]/scale);
		}
		cp.stroke();
		cp.beginPath();
		cp.arc((b.x/scale),(b.y/scale),(20/scale),0,2*Math.PI,false);
		cp.fillStyle='#fff';
		cp.fill();
	}
	//cpu intel
	if (p2.l>0){closeY(balls,p2);p2.y+=p2.v;}else{p2.v=0;}
	if (p3.l>0){closeX(balls,p3);p3.x+=p3.v;}else{p3.v=0;}
	if (p4.l>0){closeY(balls,p4);p4.y+=p4.v;}else{p4.v=0;}
	p1.x+=p1.v;
	if(p1.x<0){p1.x=0;}
	else if(p1.x>840){p1.x=840;}
	
	for (i=0;i<4;i+=1)
	{
		p=padds[i];
		cp.fillStyle='#fff';
		cp.fillRect((p.x/scale),(p.y/scale),(p.w/scale),(p.h/scale));
	}
	if (p1.l>0){cp.fillStyle=p1.c;cp.fillRect((p1.x/scale),(p1.y/scale),((p1.w/scale)*(p1.l/10)),(p1.h/scale));}
	if (p2.l>0){cp.fillStyle=p2.c;cp.fillRect((p2.x/scale),(p2.y/scale),(p2.w/scale),((p2.h/scale)*(p2.l/10)));}	
	if (p3.l>0){cp.fillStyle=p3.c;cp.fillRect((p3.x/scale),(p3.y/scale),((p3.w/scale)*(p3.l/10)),(p3.h/scale));}	
	if (p4.l>0){cp.fillStyle=p4.c;cp.fillRect((p4.x/scale),(p4.y/scale),(p4.w/scale),((p4.h/scale)*(p4.l/10)));}
	if ((p1.l>0)&&((p2.l==0)&&(p3.l==0)&&(p4.l==0))){win();}
	else if (p1.l>0){fps=requestAnimationFrame(animate);}
	else{lose();}
}