(function app() {
	'use strict';

	// Launching from web activity adds the search (defined in manifest.webapp)
	var hasActivity = (location.search == '?activity');
	var shareUrl = null;

	function ready() {
		// Online and not waiting for a pending Web Activity
		if (!navigator.onLine || (hasActivity && !shareUrl)) {
			return;
		}
		var url = 'https://www.pinterest.com/';
		if (shareUrl) {
			url += '/pin/find/?url=' + encodeURIComponent(shareUrl);
			shareUrl = null;
		}
		location.replace(url);
	}

    // Only supported on some platforms
  	if (navigator.mozSetMessageHandler) {
		navigator.mozSetMessageHandler('activity', function(activity) {
			hasActivity = false;

			// Do we know this activity?
			var source = activity.source;
			if (source.name != 'share') {
				// activity.postError('name not supported');
				window.close();
				return;
			}
			var data = source.data;
			if (data.type != 'url') {
				// activity.postError('type not supported');
				window.close();
				return;
			}

			shareUrl = data.url;
			ready();
		});
	}

	// Called on start and on every offline/online event
	function onlineCheck() {
		if (navigator.onLine) {
			document.documentElement.classList.remove('is-offline');
			ready();
		} else {
			document.documentElement.classList.add('is-offline');
		}
	}

	// Called on load to ensure splashscreen
	window.addEventListener('load', function() {
		window.addEventListener('online', onlineCheck);
		window.addEventListener('offline', onlineCheck);
		onlineCheck();
	});

})();
