function factorial(n) {
	return (n <= 1) ? 1 : n * factorial(n - 1);
}

function getBezierBasis(i, n, t) {
	return (factorial(n)/(factorial(i)*factorial(n - i)))* Math.pow(t, i)*Math.pow(1 - t, n - i);
}

function ClassBezier() 
{
	this.t = 1;
	this.speed = .02
	this.arr = [];
	this.et = null

}

ClassBezier.prototype.setObject = function(o){	
	this.getImg = o
	// this.getImg.visible = false;
}

ClassBezier.prototype.setSpeed = function(v){
	this.speed = v
}

ClassBezier.prototype.setEveryTick = function(v){
	this.et = v
}

ClassBezier.prototype.set = function(start_x, start_y, mid_x, mid_y, end_x, end_y)
{
	this.t = 0;
	// var start_r = Math.random()*(Math.PI*2);
	// var end_r = Math.random()*(Math.PI*2);
	this.arr = [
			{ x:start_x, y:start_y },
			{ x:mid_x, y:mid_y },
			// { x:start_x+150*Math.sin(start_r), y:start_y+150*Math.cos(start_r) },
			// { x:end_x+150*Math.sin(end_r), y:end_y+150*Math.cos(end_r) },
			{ x: end_x, y: end_y }
		];
}

ClassBezier.prototype.Iter = function(cb)
{
	if(this.t < 1)
	{
		this.t += this.speed;// скорость
		if(this.t > 1)
		{
			// this.getImg.visible = false;
			if(cb)
				cb()
			//достигла end_x end_y
		}
		else
		{
			if(this.et)
				this.et()
			var wx=0, wy=0;
			for(var i = 0; i < this.arr.length; i++)
			{
				var b = getBezierBasis(i, this.arr.length - 1, this.t);
				wx += this.arr[i].x * b;
				wy += this.arr[i].y * b;
			}
			this.getImg.x = wx; //координаты
			this.getImg.y = wy;


			/*
			var aa = this.getImg.x; //если нужен поворот в сторону движения
			var bb = this.getImg.y;
			this.getImg.rotation = Math.atan2((wx-aa), (bb-wy))*180/Math.PI;
			this.getImg.x = wx;
			this.getImg.y = wy;
			*/
		}
	}
};