function LogicGame(s)
{	
	var th = this
//--------------------------------//

	var _obs = new Array()
	var cur_step, cur_ship, ready, life_user, life_bot, modal, only_ready, center_target, user_money, scale_field, loupe_active
	var timer = null
	var activeTutorial
	var dimension = s

	this.getDimension = function(){
		return dimension
	}

	var _logicGame = new BattleShip(this, notify)

/// Инициализация ///
	this.init = function(v){
		scale_field = 1
		cur_step = 1
		user_money = st_getMoney()
		cur_ship = "real" // "transp"
		loupe_active = false
		ready = false
		time = -1
		life_user = __config.lifes
		life_bot = __config.lifes
		modal = null
		only_ready = null
		center_target = null
		activeTutorial = v

		startTimer(_logicGame.getAllTime(), _logicGame.after_time)
		_logicGame.createRocks()
		// this.setTutorial()
		// notify()
	}	

/// Регистрация наблюдателей ///
	this.registerObservers = function(v){
		if(indexOf(_obs, v) == -1)
			_obs.push(v)
	}
/// Действия над логикой ///
	this.pause = function(){
		
	}
	
	this.changeScale = function(){
		scale_field = scale_field == 1 ? .5 : 1
		loupe_active = scale_field == 1 ? false : true
		notify()
	}
	// Изменение прозрачности
	this.changeView = function(){
		cur_ship = cur_ship == "transp" ? "real" : "transp"
		this.updateView()
	}
	this.updateView = function(){
		var alpha = cur_ship == "real" ? true : false
		if(_logicGame.setAlphaObjects)
			_logicGame.setAlphaObjects(alpha)
		notify()
	}
	// Создание корабля на поле
	this.createShip = function(deck, direct){
		_logicGame.createShip(deck, direct, "user")
	}
	// Изменение положение корабля
	this.changeShipLoc = function(o, i, j){
		_logicGame.changeShipLoc(o, i, j, "user")
	}
	// Поворот корабля
	this.rotateShip = function(o, rot){
		_logicGame.rotateShip(o, "user")
	}
	// Создание мины (для бота)
	this.createMine = function(){
		_logicGame.createMine("user")
	}
	//
	this.randomPlacing = function(){
		_logicGame.randomPlacing("user")
	}
	//
	this.createTarget = function(){
		_logicGame.createTarget("user")
	}
	//
	this.createBonus = function(v){
		_logicGame.createBonus(v, "user")
	}

	this.deActiveBonus = function(v){
		_logicGame.deActiveBonus(v)
	}
	// Следующий шаг
	this.nextStep = function(){
		t_delInTicker(timer)
		ready = false
		time = -1
	// Смена обработчика логичеких данных в соответствии с шагом
		var data = _logicGame.getData()
		if(cur_step == 3)
			cur_step = 2
		else
			cur_step ++;
	// При переходе на второй шаг
		if(cur_step == 2){
			_logicGame = new TargetSelection(this, notify, data)
			startTimer(_logicGame.getAllTime(), _logicGame.after_time)
			// console.log(data.num_attack)
			if(data.num_attack<5)
				this.setModal("text_place_your_target")
			// center_target = true
			this.createTarget()
			// this.setTutorial()
		}
	// При переходе на третий шаг
		if(cur_step == 3){
			_logicGame.calculation()
			data = _logicGame.getData()
			_logicGame = new Fight(this, notify, data)
			_logicGame.updateView()
			this.updateView()
			activeTutorial = false
		}
		notify()
		// console.log("curStep", cur_step, _logicGame)
	}
	// 
	this.startTimer = function(t, fun){
		time = -1
		startTimer(t, fun)
	}
	// Готово
	this.activeReady = function(){
		ready = true
		notify()
	}
	// НеГотово
	this.deActiveReady = function(){
		ready = false
		notify()
	}
	// активирование перископв
	this.activePeriskop = function(){
		_logicGame.goPeriskope()
	}

	this.setModal = function(v, onlyready){
		// console.log(v, onlyready)
		// if(modal == "text_setup_battlefield")
		// 	this.setTutorial()
		modal = v
		only_ready = onlyready
		if(modal)
			pauseTimer()
		else
			startTimer(_logicGame.getAllTime(), _logicGame.after_time)
		notify()
	}

	this.setMoney = function(player, v){
		if(player == "user")
			user_money +=v
		st_setMoney(v)
	}

	this.shot = function(i, j, player, num){
		_logicGame.shotToCell(player, i, j, num)
		notify()
	}

	this.changeCurrentPlayer = function(){
		_logicGame.changeCurrentPlayer()
	}

	this.resetOnlyReady = function(){
		only_ready = null
	}

	this.setLife = function(player, v){
		// console.log(player, v)
		if(player == "user")
			life_user +=v
		else
			life_bot +=v
		if(life_user<=0 || life_bot<=0){
			t_allInPause()
			t_delayOn(2, function(){
				var data = _logicGame.getData()
				var hit_rate_user =  data.ship_shots_user == 0 ? 0 : Math.round(data.ship_shots_user/data.all_shots_user * 100)
				var hit_rate_bot = data.ship_shots_bot == 0 ? 0 : Math.round(data.ship_shots_bot/data.all_shots_bot * 100)
				var ttl = player == "user" ? "text_you_lose" : "text_victory"
				v_choiseLocation("gameOver", {title: ttl, hit_rate_user: hit_rate_user, hit_rate_bot: hit_rate_bot, treasures_user: data.num_chests_user, treasures_bot: data.num_chests_bot, num_money: data.num_money,
												reason: "life_lost"});
				if(player == "user")
					MusicCTRL.play("sound3");
				else
					MusicCTRL.play("sound6");
			})
		}
		notify()
	}

	this.setNumBonus = function(player, bonus, v){
		if(player == "user"){
			if(bonus == "multibomb"){
				// console.log("add", th.getData().game_data.multibomb_num_user)
				th.getData().game_data.multibomb_num_user += v
			}if(bonus == "dinamite")
				th.getData().game_data.dinamite_num_user += v
			if(bonus == "periscope")
				th.getData().game_data.periskope_num_user += v
			if(bonus == "torpedo")
				th.getData().game_data.torpedo_num_user += v
		}
		notify()
	}

	this.pause = function(){
		pauseTimer()
	}

	this.unPause = function(){
		// startTimer(_logicGame.getAllTime(), _logicGame.after_time)
		t_delInPause(timer)
	}

/// Getters ///
	this.getData = function(){
		var p = {
			cur_step: cur_step,
			cur_ship: cur_ship,
			ready: ready,
			game_data: _logicGame.getData(),
			time: time,
			life_user: life_user,
			life_bot: life_bot,
			modal: modal,
			only_ready: only_ready,
			center_target: center_target, 
			user_money: user_money,
			scale_field: scale_field,
			loupe_active: loupe_active
		}

		return p
	}

// PRIVATE //
	function notify(dis_game, dis_interface){
		for(var a = 0; a < _obs.length; a++){
			if(_obs[a].notify && !dis_game)
				_obs[a].notify()
			if(_obs[a].notifyInterface && !dis_interface)
				_obs[a].notifyInterface()
		}
	}
	// Включить туториал
	this.setTutorial = function (){
		if(!activeTutorial)
			return
		for(var a = 0; a < _obs.length; a++){
			if(_obs[a].setTutorial)
				_obs[a].setTutorial(true)
		}
	}

	// Таймер
	function startTimer(allTime, after){
		t_delInPause(timer)
		t_delInTicker(timer)
		if(allTime == 0)
			return
		var fun = function(){
			if(time >= 7){
				time++
				after()
				notify()
				return
			}
			time++
			notify(true)
			timer = t_delayOn(allTime/8, fun)
		}
		fun()
	}

	function pauseTimer(){
		t_setPause(timer)
	}
	
};