/**
 * Variáveis globais para manipulação da view
 */
var id    = 0,
    items = [],
    desc  = document.getElementById("itemdesc"),
    val   = document.getElementById("itemval"),
    list  = document.getElementById("itemList"),
    total  = document.getElementById("thetotal");

/**
 * Função para adicionar os itens à lista
 */
function add() {
    if (!valida()){
        return;
    }
    items.push(new Item(id,desc.value,val.value));
    showItens();
    id++;
    desc.value = "";
    val.value = "";
}

/**
 * Função para validar se há dados para adicionar
 * OBS: como o input do valor é do tipo number, se o valor
 *      digitado não for numérico, ele retorna um value vazio
 */
function valida() {
    return (desc.value != "" && val.value != "");
}

/**
 * Função para deletar o item da lista
 */
function del(id) {
    for (var i in items){
        if (items[i].id == id) {
            items.splice(i, 1);
        }
    }
    showItens();
}

/**
 * Função para mostrar os itens na tela.
 * É utilizada tanto no add() quanto no del()
 */
function showItens() {   
    list.innerHTML = '';
    var tot = 0;
    for(i=0;i<items.length;i++) {
        tot =  parseFloat(tot) +  parseFloat(items[i].val);
        var li = document.createElement("li"),
            d = document.createElement("span"),
            v = document.createElement("span"),
            c = document.createElement("span"),
            clear = document.createElement("div");
        
        d.textContent = items[i].desc;
        d.className = "desc";
        v.textContent = parseFloat(items[i].val).toFixed(2);
        v.className = "val";
        c.textContent = "x";
        c.className = "close";
        c.setAttribute("id", items[i].id);
        c.addEventListener("click", function (e) {
            console.log(this.id);
            del(this.id);
        });
        clear.className = "clear";
        li.appendChild(d);
        li.appendChild(c);
        li.appendChild(v);
        li.appendChild(clear);
        list.appendChild(li);
    }
    total.textContent = tot.toFixed(2);
}