/**
 * Moduł reklam
 * @class
 */
var Ads = function(){
};

Ads.prototype.setup = function(){
	var ads = (arguments.length && Array.prototype.slice.call(arguments)) || false;

	console.log('setup ads = ', ads);
	if (ads && ads.length === 1 && T.type(ads[0]) === 'array') {
		ads = ads[0];
	} else {
		console.log('ads setup false');
		this.present = false;
		return false;
	}
	this._list = ads;
	this.present = true;
	this.adsCounter = 0;
};

Ads.prototype.show = function(adName, callback, onError){
	var ad = T.getJSONByKey(this._list, 'name', adName);


	console.log('AD SHOW ADNAME ' + adName, ad, ad.working);

	if (!ad || !ad.working) {
		console.log('nie ad');
		
		if (T.type(onError) === 'function') {
			onError();
		} else if (T.type(callback) === 'function') {
			callback();
		}
		return false;
	} else {
		console.log('tak ad', ad.type);
		switch (ad.type) {
			case 'splash': this._showSplash(ad, callback, onError); break;
			case 'banner': this._getBannerHTML(ad, callback); break;
			case 'button': this._getButtonHTML(ad, callback); break;
			case 'background': this._getBackgroundSrc(ad, callback); break;
		}
		this.adsCounter += 1;
	}
};

Ads.prototype.hide = function(adName, callback){
	var ad = T.getJSONByKey(this._list, 'name', adName);

	if (!ad) {
		if (T.type(callback) === 'function') {
			callback();
		}
		return false;
	} else {
		switch (ad.type) {
			case 'splash': this._hideSplash(ad); break;
			case 'banner': break;
		}
	}
};

Ads.prototype._getBannerHTML = function(ad, callback){
	var bannerHTML = '<div id="' + ad.name + this.adsCounter + '" class="' + ad.name + ' ad_container"><div class="extWebView" data-href="' + ad.href + '" onclick="T.showWebPage(this.getAttribute(\'data-href\'), true);"><img src="' + ad.imageUrl + '" alt="" data-src="' + ad.imageUrl + '"></div></div>';
	console.log(ad.href);
	if (bannerHTML === "undefined") {
		bannerHTML = false;
	}
	
	if (T.type(callback) === 'function') {
		callback(bannerHTML, ad);
	}
};
Ads.prototype._getBackgroundSrc = function(ad, callback){
	var src = ad.imageUrl;
	console.log('backgroundSrc ' + ad.imageUrl);
	if (src === "undefined") {
		src = false;
	}
	
	if (T.type(callback) === 'function') {
		callback(src);
	}
};
Ads.prototype.reloadBanner = function(name, data){
	this._fetchFreshAd(T.config.get('adsReloadUrl').replace(/%AD_NAME%/, name.slice(0,-1)), function(ad){
		if (T.bool(ad)) {
			var _ad = document.getElementById(name);
			if (T.bool(_ad)) {
				_ad.querySelector('img').setAttribute('src', ad.imageUrl);
				_ad.querySelector('a').setAttribute('href', ad.href);
			}
		}
	}, data);
};

Ads.prototype._getButtonHTML = function(ad, callback){
	var bannerHTML = '<div id="' + ad.name + this.adsCounter + '" class="' + ad.name + ' ad-button-container"><div class="extWebView" data-href="' + ad.href + '"><img src="' + ad.imageUrl + '" alt="" data-src="' + ad.imageUrl + '"></div></div>';
	
	if (bannerHTML === "undefined") {
		bannerHTML = false;
	}
	
	if (T.type(callback) === 'function') {
		callback(bannerHTML);
	}
};

Ads.prototype._fetchFreshAd = function(url, callback, data){
	$.ajax({
		url: url + '&' + (new Date()).getTime(),
		dataType: 'json',
		data: data || false,
		type: 'post',
		success: function(d, t, x){
			if (T.type(callback) === 'function') {
				callback(d);
			}
		},
		error: function(xhr, errorType, e){
			console.log('Wystąpił błąd pobierania reklamy:(');
		}
	});
};

Ads.prototype._showSplash = function(ad, callback, onError){
	var self = this,
		splashDOM = document.createElement('div'),
		splashImgDOM = document.createElement('img'),
		countdown = null;

	countdown = function(){
		ad.startTime = new Date().getTime();
		if (T.type(callback) === 'function') {
			callback();
		}
	};
	splashDOM.setAttribute('id', ad.name);
	splashDOM.setAttribute('class', ad.name);
	splashImgDOM.setAttribute('src', ad.imageUrl);
	splashImgDOM.onclick = function(){
		T.showWebPage(ad.href), true;
	};
	splashImgDOM.onload = countdown;
	splashImgDOM.onerror = onError;
	
	splashDOM.appendChild(splashImgDOM);

	document.body.appendChild(splashDOM);
};

Ads.prototype._hideSplash = function(ad, callback){
	var minTime = ad.duration,
		diff = minTime - ((new Date()).getTime() - ad.startTime),
		splashDOM = document.getElementById(ad.name),
		fn = function(){;
			if (splashDOM) {
				console.log('wywalamy splash ad z doma');
				try{
					document.body.removeChild(splashDOM);
					} catch(e) {
						console.log(T.inspect(e));
					}
			}
		};

	console.log('HIDE SPLASH ADS')
	if (diff < 0) {
		fn();
	} else {
		setTimeout(fn, diff);
	}
};

var Ads = new Ads();