/*(function(window, document, undefined){*/
/**
 * Moduł do dodawania buttonów w css3
 * @class
 */
			var ButtonsCLS = function(){};

			ButtonsCLS.prototype = {
				/* helpers */
				helpers: {
					/**
					 * proste rozszerzanie
					 */
					ext: function ext(obj, def) {
						for (var n in def) {
							if (obj[n] === undefined) obj[n] = def[n];
						}
						return obj;
					},
					class2type: (function(){
						var types = "Boolean Number String Function Array Date RegExp Object".split(" "), tmp = [];
						for (var i = 0, j = types.length; i < j; i++) {
							tmp["[object " + types[i] + "]"] = types[i].toLowerCase();
						}
						return tmp;
					})(),

					typeOf: function typeOf(obj) {
						return obj == null ?
							String(obj) :
							this.class2type[Object.prototype.toString.call(obj)] || "object";
					},
					 /**
					 * funkcja zwracajaca obiekt DOM na podst selektora
					 */
					getDest: function getDest(where) {
						if (this.typeOf(where) === 'string')	{
							return document.querySelector(where);
						} else if (this.typeOf(where) === 'object') {
							return where;
						}
					}
				},
				/* ----*/
				buttonCount: 0,
				predefined: {
					share: {
						borderColor: "#141517",
						background: "linear-gradient(to bottom, rgb(251,251,251) 1%, rgb(184,184,187) 49%, rgb(236,236,237) 99%, rgb(207,208,209) 50%, rgb(189,191,194))",
						boxShadow: "0px 1px rgba(200, 200, 200, .3)",
						color: "#acacac",
						textShadow: "0px 1px rgba(255, 255, 255, .3)"
					},
					cancel: {
						borderColor: "#141517",
						background: "linear-gradient(to bottom, rgb(108,113,120) 1%, rgb(23,31,40) 49%, rgb(94,99,106) 99%, rgb(39,45,55) 50%, rgb(37,45,54))",
						boxShadow: "0px 1px rgba(200, 200, 200, .3)",
						color: "#fff",
						textShadow: "0px -1px rgba(0, 0, 0, .3)"
					}
				},
				global: {	
					display: "block",
					borderWidth: "3px", "borderStyle": "solid", "borderRadius": "12px",
					textAlign: "center", "fontFamily": "Helvetica", "fontSize": "22px", "fontWeight": "bold",
					lineHeight: "39px", "verticalAlign": "middle", "textDecoration": "none"
				},
				defaults: {
					color: '#000000', // kolor tekstu (#rrggbb, #rgb, rgba(r, g, b, a)
					fontSize: '22px', // rozmiar tekstu
					borderColor: '#141517', // kolor ramki
					background: 'linear-gradient(to bottom, rgb(251,251,251) 1%, rgb(184,184,187) 49%, rgb(236,236,237) 99%, rgb(207,208,209) 50%, rgb(189,191,194))', // kolejne kolory gradientu przycisku
					textShadow: '0px 1px rgba(255, 255, 255, .3', // połozenie i kolor cienia (#rrggbb, #rgb, rgba(r, g, b, a)
					height: '39px' // wysokość przycisku
				},
				/**
				 * nakładanie cssow na element przycisku
				 * @param	{dom object}	el	element, ktorego style beda modyfikowane
				 * @param	{object}	css	obiekt z właściwościami css do nałozenia na element
				 */
				applyCss: function(el, css){
					var s;
					/* TODO zamienić na jedna iteracje - łaczenie global+css */
					for (s in this.global) {
						el.style[s] = this.global[s];
					};
					for (s in css) {
						el.style[s] = css[s];
					};
/*
					// TODO - customowe style na active
					//document.querySelector('head').appendChild(document.createElement('style'));
					//document.styleSheets[document.styleSheets.length-1].insertRule('#css-button-' + this.buttonCount + ':active {' +
*/					document.styleSheets[0].insertRule('#css-button-' + this.buttonCount + ':active {' +
						'color: #fff !important;' +
						'background: linear-gradient(to bottom, rgb(93,125,192) 1%, rgb(34,96,221) 49%, rgb(112,151,233) 99%, rgb(57,113,224) 50%, rgb(36,98,222)) !important;' +
						'text-shadow: 0px -1px rgba(0, 0, 0, .3) !important;}', 0);
				},
				/**
				 * osadzanie przycisku w DOMie
				 * @param	{String}	caption	tekst przycisku
				 * @param	{DOM object|String}	where	kontener, w ktorym ma być osadzony przycisk
				 * @param	{object}	[options]	opcje przycisku (zamieniane potem na css)
				 */
				insert: function(caption, where, options){
					var div = null;
					where = this.helpers.getDest(where);
					caption = caption || 'Button';
					options = options || {};
					if (this.helpers.typeOf(options.style) === 'string') {
						options.style = this.predefined[options.style];
					}
					options.style = this.helpers.ext(options.style || {}, this.defaults);
					if (where) {
						btn = document.createElement('a');
						btn.innerHTML = caption;
						btn.href = '#';	
						btn.id = 'css-button-' + this.buttonCount;
						options._class && btn.setAttribute('class', options._class);
						options.data && btn.setAttribute('data-args', options.data);
						where.appendChild(btn);
						this.applyCss(btn, options.style);

						this.buttonCount++;
					}
				}/*//,*/
				/**
				 * dodawanie eventu do przycisku
				 * @param {String}	event	event nakładany na przycisk
				 * @action {Function}	action	akcja wykonana na danym evencie
				 */
			/*	//addEvent: function(event, action) {
					// TODO
			 	//}*/
			};

/*//			window.Buttons = new Buttons();
//		})(window, document);*/
var Buttons = new ButtonsCLS();