/*
 * Konfigura
 *
 */

/**
 * Moduł konfiguracji
 * @class
 */
var Konfigura = function(){
	
        this._defaults = false;
        this._config = false;
        // this._srcOffline = 'config/config-dev.json';
		this._srcOffline = 'config/config.json';
		this._src = Def && Def.config || 'http://config.app.gazeta.pl/config?plotek-fos';
};

/**
 * setDefaults
 * Ustawianie domyślnych opcji.
 * Jako argumenty może być podana para 'opcja': 'wartość' lub obiekt zawierający opcje konfiguracyjne
 */

Konfigura.prototype.setDefaults = function(){
    var defs = (arguments.length && Array.prototype.slice.call(arguments)) || false,
            defaults = {};
    if (!defs) {
            return false;
    }

    if ((defs instanceof Array) && defs.length) {
            switch (defs.length) {
                    case 1: 
                            if (T.type(defs[0]) === 'object') {
                                    defaults = defs[0];
                            }
                            break;
                    case 2:
                            if (T.type(defs[0]) === 'string') {
                                    defaults[defs[0]] = defs[1];
                            }
                            break;
            }
    }

    this._defaults = T.extend({}, this._defaults || {}, defaults);
};

Konfigura.prototype.fetch = function(complete, win, fail, offline, data){
    var self = this,
        src = offline ? this._srcOffline : this._src,
        cachedAppCfg = lscache.get('appconfig');

    if (!src) {
       return false;
    }
    console.log(src);
    
    if (offline && cachedAppCfg && T.isOnline()) {
        self._config = cachedAppCfg;
        win();
    } else {
        $.ajax({
            url: src + ((src.indexOf('?') === -1) ? '?' : '&') + (new Date()).getTime(),
			data: data || false,
			type: 'post',
            dataType: 'json',
            success: function(d, t, x){
                console.log('konfiguracja pobrana w trybie ' + (offline ? 'offline' : 'online'));
                self._config = d;
                if (T.type(win) === 'function') {
                    win();
                }
                if (!offline) {
                	lscache.set('appconfig', d);
                }
            },
            error: function(xhr, errorType, e){
                console.log('Konfigura fetch fail :( ' + self._src + '\npobieram z pliku');
                console.log(errorType);
                self._config = self._defaults;
                if (T.type(fail) === 'function') {
                   fail();
                }
                if (!offline) {
                   self.fetch(complete, win, fail, true);
                }
            },
            complete: function(){
                if (T.type(complete) === 'function') {
                        complete();
                }
            }
    	});
    }
    return this;
};

Konfigura.prototype._get = function(resource){
    var res = null;

    if (resource === 'config') { res = this._config; }
    else if (resource === 'defaults') { res = this._defaults; }
    else { return false; }

    return function(args){
            var configs = false;

            if (!T.bool(args)) {
                    configs = res;
            } else if (args.length === 1) {
                    configs = res[args[0]];
            } else if (args.length > 1) {
                    configs = {};
                    for (var a in args) {
                            if (T.bool(res[args[a]])) {
                                    configs[args[a]] = res[args[a]];
                            }
                    }
            }

            return configs;
    }
};

/**
 * getConfig
 */
Konfigura.prototype.get = function(){ return this._get('config')(Array.prototype.slice.call(arguments)); };

Konfigura.prototype.defaults = function(){ return this._get('defaults')(Array.prototype.slice.call(arguments)); };