T.namespace('Foremka').Controller.Article = (function(){
	var Base = T.namespace('Foremka').Base;
	var ViewBase = T.namespace('Foremka.View').Base;
	var View = T.namespace('Foremka.View').Article;

	/**
	 * Kontroler artykułów
	 * @namespace
	 * @class
	 */
	var self = Base.cls(Base, function() {
        this.sup("_constr");
    });
	
	/**
	 * czy widok jest już wyrenderowany
	 * @memberOf Controller.Article-self
	 * @type bool
	 */
	var last = {};
	
	/**
	 * wyczyszczenie artykułu
	 * @memberOf Controller.Article-self
	 */
	self.clear = function() {
		if (View.rendered) {
			View.$scroller.html('');
			View.rendered = false;
		}
	};
	
	/**
	 * wyrenderowanie artykułu
	 * @name render
	 * @memberOf Controller.Article-self
	 */
	self.render = function(item, noCache) {
		View.render(item);
		if (!noCache) {
			last = item;
		}
	};

	/**
	 * wyrenderowanie artykułu
	 * @name render
	 * @memberOf Controller.Article-self
	 */
	self.renderPrev = function(item) {
		View.render(last);
		T.namespace('Foremka.Controller.Favourites').isAdded(last.xx);
	};
	
	/**
	 * pokazanie artykułu
	 * @name show
	 * @memberOf Controller.Article-self
	 */
	self.show = function() {
		var articleTitle = View.$container.find('.artTitle')[0]; // wysokość tytułu
		if (articleTitle) {
			ViewBase.y = articleTitle.offsetHeight + articleTitle.offsetTop;
			ViewBase.articleScroller.scrollTo(0, -(ViewBase.y), 0);	// schowanie tytułu artykułu
		} else {
			ViewBase.y = 0;
			ViewBase.articleScroller.scrollTo(0, 0, 0);
		}
		setTimeout(function(){
			ViewBase.$container.addClass('articleOver');
			View.$container.addClass('show'); //nadanie klasy wywoła pokazanie się artykułu za pomocą animacji css
			View.rendered && View.imgLazyLoad(); // uruchomienie lazy load
		}, 10);
	};
	
	return self;
})();