T.namespace('Foremka').Controller = {};
T.namespace('Foremka').Controller.Base = (function () {
	var Base = T.namespace('Foremka').Base;
	var View = T.namespace('Foremka.View').Base;
	var Model = T.namespace('Foremka.Model').Base;
	
	/**
	 * Kontroler
	 * @namespace
	 * @class
	 */
	var self = Base.cls(Base, function () {
        this.sup("_constr");
    });
	
	/**
	 * timestamp najnowszego newsa
	 * @type number
	 */
	var lastNewsTS = 0;
	var pagination = {
		page : 1,
		results: 8
	};
	/**
	 * przeładowanie configu, reklam, i tła po powrocie do aplikacji (tylko iOS)
	 * @memberOf Controller.Base-self
	 */
	self.onResume = function () {
		T.config.fetch(function () {
	        console.log('fetch config!');
	    }, function () {    
			console.log('config OK!');
			View.$container.removeClass('promo');
			while (document.styleSheets[1].cssRules.length > 1) { // usuwanie styli odpowiedzialnych za banner reklamowy
				document.styleSheets[1].deleteRule(document.styleSheets[1].cssRules.length - 1);
			}
			var $bannerTop = $('#banner-top');
			if (T.bool($bannerTop)) {
				$bannerTop.remove(); // usunięcie reklamy jezeli istnieje
			}
			$('#viewport')[0].setAttribute('style', ''); // usunięcie stylu inline odpowiedzialnego za grafikę tła
			self.start(true);
	    }, function () {
	        console.log('config ERROR!');
	    }, false, T.namespace('Foremka').Base.screen);
	};
	
	/**
	 * start aplikacji
	 * @memberOf Controller.Base-self
	 * 
	 * @param {bool} [isResuming] informacja o tym, czy jest to czysty start, czy powrót z tła
	 */
	self.start = function (isResuming) {
		var $html = $('html'),
			$artScroller = View.$article.find('.scroller'),
			onError = null,
			$viewport = $('#viewport');

		H.rateUs(); // wywołanie funkcji odpowiedzialnej za prośbe o ocenę aplikacji
		
		if (!isResuming) {
		    lscache.remove('ForemkaData'); // usunięcie cache
			
			// prawidłowe wypozycjonowanie o określenie rozmiarów obrazków w artykułach 
			document.styleSheets[1].insertRule( 
					'#article .artText img, ' +
					'#articleTmp .artText img {' +
					'max-width: ' + T.namespace('Foremka.View').Index.$container[0].offsetWidth + 'px !important;' +
					'margin-left: -5px !important;}', 0);
			
			// zmiana koloru tła takich elementów jak lista artykułow, treść artykułu i ulubionych
			if (Def && Def.fgColor) {
				document.styleSheets[1].insertRule(
						'.fgColor {' +
						'background-color: rgb(' + Def.fgColor + ') !important;}', 1);
			}
			
			Buttons.insert('Facebook', '#share_options .facebook', {data: 'facebook', _class: 'share'});
	        Buttons.insert('Twitter', '#share_options .twitter', {data: 'twitter', _class: 'share'});
	        Buttons.insert('E-mail', '#share_options .mail', {data: 'email', _class: 'share'});
	        Buttons.insert('Anuluj', '#share_options .hide', {style: 'cancel', _class: 'hide'})
	        
			View.globalEvents();
			// pagination.results = Math.floor((T.namespace('Foremka').Base.screen.wo - 20) / 15);
		}
		
		// podmiana tła aplikacji
		if (Def && Def.bgImage) {
			$viewport.css('backgroundImage', Def.bgImage);
		}
		
		// podmiana koloru tła aplikacji
		if (Def && Def.bgColor) {
			$viewport.css('backgroundColor', 'rgb(' + Def.bgColor + ')');
		}
        Ads.setup(T.config.get('ads'));
        
        if (Ads.present) {
        	
        	/**
        	 * branding aplikacji (tło promocyjne)
        	 * 
        	 * @param {number} [top] offset górny, zależny od wymiarów bannera górnego
        	 */
        	var branding = function (top) {
        		Ads.show('ads-branding',  function (src) {
					if (src) { // jeżeli istniej źródło grafiki dodaj je jako tło
						$viewport.css({
							'backgroundImage' : 'url(' + src + ')',
							'backgroundRepeat' : 'no-repeat',
							'backgroundSize' : '100% 100%',
							'backgroundPosition' : 'left top'
						});
					} else { // jeżeli nie, sprawdź czy trzeba nałożyć tło nocne
			        	H.nightCheck(top);
					}
				});
        	};
        	Ads.show('ads-banner-top',  function (bannerHTML, ad) {
				if (bannerHTML) {
					if (Base.screen.wo - 20 !== ad.width) { // sprawdzenie czy szerokość reklamy odpowiada szerokści ekranu minus 10px marginesu z każdej strony (wymagania projektowe)
						var h = Math.ceil(ad.height * (Base.screen.wo - 20) / ad.width); // jeśli nie, to szerokść jest skalowana automatycznie, a wysokość trzeba przeliczyć
					} else {
						h = ad.height;
					}
					
					// wypozycjonowanie elementów w związku z pojawieniem się bannera gornego
					var $index = document.getElementById('index'),
						offsetTop = document.getElementById('header').offsetTop + h + 10;
					document.styleSheets[1].insertRule(
							'.promo #header {' +
							'top: ' + offsetTop + 'px;}', 1);
					document.styleSheets[1].insertRule(
							'.promo .view {' +
							'top: ' + ($index.offsetTop + h + 10) + 'px;}', 2);
					document.styleSheets[1].insertRule(
							'.promo .view.hover {' +
							'top: ' + ($index.offsetTop + h + 20) + 'px;}', 3);
					document.styleSheets[1].insertRule(
							'.promo #loader {' +
							'top: ' + ($index.offsetTop + h + 20) + 'px !important;}', 4);
					$viewport.append('<div id="banner-top">' + bannerHTML + '</div>');
					View.$container.addClass('promo');
					branding(offsetTop);
				} else {
					branding();
				}
			});
        	if (!isResuming) {
				Ads.show('ads-splash', function () {
					self.fetch(1, pagination.results * 2);
					T.hideSplash();
					Ads.hide('ads-splash');
				}, function () {
		        	T.hideSplash();
		        	self.fetch(1, pagination.results * 2);
				});
        	}
		} else {
        	H.nightCheck();
        	if (!isResuming) {
	        	T.hideSplash();
	        	self.fetch(1, pagination.results * 2);
        	}
		}
	};
	
	self.nextPage = function (callback, onError) {
		Model.fetch(T.config.get('source')['pagination'].replace(/%PAGE%/, ++pagination.page).replace(/%RESULTS%/, pagination.results), callback, onError);
	};
	/**
	 * pobranie danych z serwera
	 * @name fetch
	 * @memberOf Controller.Base-self
	 */
	self.fetch = function (page, results) {
		var page = page || pagination.page,
			results = results || pagination.results,
			onError = function () {
		    	Base.error = true;
		    	View.$container.addClass('error');
		    	
		    	//wyświetlenie danych offline'owych
		    	Model.fetch(T.config.get('sourceOffline'), function (item) {
			    	lastNewsTS = item.d;
				    View.$article.show();
			    	H.hideCssLoader();
				    T.namespace('Foremka.Controller.Article').show();
			    	T.namespace('Foremka.Controller.Article').render(item);
		    	});
		    };

    	H.showCssLoader();
		Model.fetch(T.config.get('source')['pagination'].replace(/%PAGE%/, page).replace(/%RESULTS%/, results), function (items) {
			++pagination.page;
	    	lastNewsTS = items[0].d; // zapamiętanie timestampa najnowszego newsa
	    	
    		lscache.set('ForemkaData', items);
	    	Base.error = false;
	    	View.$container.removeClass('error');
	    	View.$article.show();
	    	T.namespace('Foremka.View.Index').render(items);
	    }, onError);
	};
	
	/**
	 * odświeżenie danych
	 * @memberOf Controller.Base-self
	 */
	self.refresh = function () {
		var _ad = $('#banner-top > .ad_container');
		if (_ad.length > 0) {
		    Ads.reloadBanner(_ad.attr('id'), T.namespace('Foremka').Base.screen);
		}
		Base.refresh = true;
	    View.hideArticle();
	    View.hideFavourites();
		var onError = function () {
			setTimeout(function () {
				if (Base.error) {
					T.namespace('Foremka.Controller.Article').show();
				}
				H.hideCssLoader();
			}, 1000);
	    };
    	H.showCssLoader();
		Model.fetch(T.config.get('source')['refresh'].replace('_TS_', lastNewsTS), function (items) {
	    	Base.error = false;
	    	View.$container.removeClass('error');
	    	View.$article.show();
	    	if (items.length > 0) {
	    		lastNewsTS = items[0].d;
	    		
	    		var saved = lscache.get('ForemkaData', items);
	    		if (T.bool(saved)) { // dopisanie nowo pobranych danych
	    			items = items.concat(saved).slice(0, pagination.results * 2 - 1);
	    			pagination.page = 2;
	    		}
	    		lscache.set('ForemkaData', items);
	    		T.namespace('Foremka.View.Index').render(items);
	    	} else {
				H.hideCssLoader();
	    	}
	    }, onError);
	};
	return self;
})();