T.namespace('Foremka').Controller.Favourites = (function(){
	var Base = T.namespace('Foremka').Base;
	var View = T.namespace('Foremka.View').Favourites;
	var ViewBase = T.namespace('Foremka.View').Base;
	var Controller = T.namespace('Foremka.Controller').Base;
	
	/**
	 * Kontroler ulubionych
	 * @namespace
	 * @class
	 */
	var self = Base.cls(Base, function() {
        this.sup("_constr");
    });

	var data = lscache.get('ForemkaFavourites') || {},
		tmpContainer = ViewBase.$articleTmp;
	
	/**
	 * zapis ulubionych 
	 * @memberOf Controller.Favourites-self
	 */
	self.save = function(){
		lscache.set('ForemkaFavourites', data);
	};
	
	/**
	 * dodanie nowego artykułu do ulubionych
	 * @memberOf Controller.Favourites-self
	 * @param {number} id
	 */
	self.add = function(id){
		data[id] = {
			't': ViewBase.$article.find('.artTitle').text(),
			'tn': ViewBase.$article.data('tn'),
			'xx': ViewBase.$article.data('xx'),
			'u': ViewBase.$article.data('url') || false
		};
		ViewBase.articleScroller.scrollTo(0,1,200); // przeskrolowanie do góry artykułu
		tmpContainer.html(ViewBase.$article.find('.scroller').html()); // wykonanie kopii artykułu do tymczasowego artykułu (swego rodzaju "printscreen")
		setTimeout(function(){
			tmpContainer.show();
			setTimeout(function(){
				tmpContainer.addClass('anim');
			}, 100);
		}, 100);
	};
	
	/**
	 * usuwanie artykułu z ulubionych i zwraca informację czy pozotały jeszcze jakieś elementy na liście
	 * @memberOf Controller.Favourites-self
	 * @param {number} id
	 * @return {bool}
	 */
	self.remove = function(id){
		delete data[id];

		ViewBase.$container.removeClass('added');
		self.save();
		if ($.isEmptyObject(data)) { // jeżeli nie ma więcej elementów na liście to wyświetla komunikat o brku ulubionych
			View.$list.html(View.noFavourites);
			View.$container.addClass('empty');
			return false;
		}
		return true;
	};
	
	/**
	 * sprawdza czy dany artykuł jest dodany do ulubionych
	 * @memberOf Controller.Favourites-self
	 * @param {number} id 
	 * @return {bool}
	 */
	self.isAdded = function(id){
		if (data[id]){ // jeśli dodant to nadaje klasę
			ViewBase.$container.addClass('added');
			return true;
		} else {
			ViewBase.$container.removeClass('added');
			return false;
		}
	};

	self.getContent = function (xx) {
		T.namespace('Foremka.Model.Base').fetch(T.config.get('source')['article'].replace(/%SECTION_XX%/, 0).replace(/%XX%/, xx), function (data) {
			T.namespace('Foremka.View.Article').render(data, true);
			self.isAdded(xx);
		});
	};
	/**
	 * wyrenderowanie listy ulubionych
	 * @memberOf Controller.Favourites-self
	 * @name render
	 */
	self.render = function() {
		View.render(data);
	};
	return self;
})();