T.namespace('Foremka').Controller.Share = (function(){
	var Base = T.namespace('Foremka').Base;
	var Controller = T.namespace('Foremka.Controller').Base;
	var View = T.namespace('Foremka.View').Share;
	var ViewBase = T.namespace('Foremka.View').Base;
	var data = {};
	/**
	 * Kontroler udostepniania
	 * @namespace
	 * @class
	 */
	var self = Base.cls(Controller, function() {
        this.sup("_constr");
    });
	
	/**
	 * pokazanie okna/belki share
	 * @memberOf Controller.Share-self
	 */
	self.show = function(){
        data.url = unescape(ViewBase.$article.data('url')) || false;
        data.title = T.config.get('share') && T.config.get('share')['title'] || "Musisz to zobaczyć!";
        
        if (T.bool(data.url)) { // jeżeli sitnieje url do artykułu
			if (window.plugins && window.plugins.share) { // jeżeli jest plugin do share (android) to użyj natywnej funkcji udostępniania
				window.plugins.share.show({
					subject: data.title,
					text: data.url},
					function() {}, // Success function
					function() {T.alert('Share failed');} // Failure function
				);
			} else { // jeśli nie to pokaż belkę
				View.show();
			}
        }
	};
	
	/**
	 * schowanie belki share
	 * @memberOf Controller.Share-self
	 */
	self.hide = function(){
		View.hide();
	};
	
	/**
	 * udostępnienie treści
	 * @memberOf Controller.Share-self
	 * @param {string} service usługa za której pomocą informacje mają zostać udostępnione
	 */
	self.share = function(service){
		var shareUrl = '',
			shareText = data.title + " " + data.url;
		switch (service) {
			case "facebook":
				shareUrl = T.config.get('share') && T.config.get('share')['facebook'] || "http://m.facebook.com/sharer.php?u=_SHARE_TEXT_";
                break;
			case "twitter":
				shareUrl = T.config.get('share') && T.config.get('share')['twitter'] || "http://mobile.twitter.com/?status=_SHARE_URL_";
                break;
			case "email":
				T.sendEmail(data.title, data.url);
				break;
			case "other":
				T.mozillaShare(data.url);
				break;
			case "googlePlus":
				shareUrl = T.config.get('share') && T.config.get('share')['googlePlus'] || "http://m.google.com/app/plus/x/?v=compose&hideloc=1&content=_SHARE_TEXT_";
				break;
		}
		
		if (shareUrl){
			shareUrl = shareUrl.replace("_SHARE_TEXT_", encodeURIComponent(shareText)).replace("_SHARE_URL_", encodeURIComponent(data.url));
			T.showWebPage(shareUrl, true);
		}
	};
	return self;
})();