/**
 * Funkcje pomocnicze
 * @class
 */

var Helpers = {};

Helpers._longTitle = function (str) {
	return '<span>' + str.replace(/ /g, '</span><span>') + '</span>';
};
Helpers._check = function (hImg, hTitle, imgCont, title, elCont, contHeight) {
	var $elCont = null;

	if (hImg + hTitle > contHeight) {

		$elCont = $(elCont);

		if (Def && Def.shrinkFont) {
			$elCont.addClass('shrinkFont');
		} else {
			$elCont.addClass('long');

			if (hTitle > contHeight) {
				$elCont.addClass('smallerFont');
			}

			title.innerHTML = H._longTitle(title.textContent);
		}
	}
};
Helpers._imageDetect = function (imgCont, title, elCont, contHeight) {
	var img = imgCont.getElementsByTagName('img')[0] || false,
		_onLoad = null;
	
	if (img) {
		_onLoad = img.onload || img.onerror || function(){};
		if (img.width) {
			H._check(imgCont.offsetHeight, title.offsetHeight, imgCont, title, elCont, contHeight);
			_onLoad();
		} else {
			img.onload = function () {
				img.onload = null; img.onerror = null;
				H._check(imgCont.offsetHeight, title.offsetHeight, imgCont, title, elCont, contHeight);
				_onLoad();
			};
			img.onerror = function () {
				img.onload = null; img.onerror = null;
				H._check(imgCont.offsetHeight, title.offsetHeight, imgCont, title, elCont, contHeight);
				_onLoad();
			};
		}
	}
};
Helpers.titleCheck = function ($items, contHeight) {
	var i = 0, length = $items.length,
		images = $items.find('.img'),
		titles = $items.find('.title');

	for ( ; i < length; i++) {
		H._imageDetect(images[i], titles[i], $items[i], contHeight);
	}
};

/**
 * przypisanie gemius_id w zależności od danej platformy
 * @type {object|bool} 
 */
Helpers.gemiusData = (function(){
	if (Def && Def.gemius) {
		if (T.isIOS && Def.gemius.ios) {
			return Def.gemius.ios;
		} else if (T.isAndroid && Def.gemius.android) {
			return Def.gemius.android;
		}
	} else {
		return false;
	}
})();
/**
 * sprawdzenie czy istnieją gemius_id dla danej platformy, jeśli tak, przekazywany jest gemius_id dla danej akcji do Tools.gemiusHit();
 * @param {string} _type rodzaj akcji w zależności od której wybierany jest gemius_id
 */
Helpers.gemiusHit = function(action) {
	if (H.gemiusData) {
		T.gemiusHit(H.gemiusData[action]);
	}
};
/**
 * wysłanie danych do gemiusa
 * 
 * @param {bool} [isGallery] czy dany artykuł jest galerią
 */
Helpers.articleGemiusHit = function(isGallery) {
	if (isGallery) {
		H.gemiusHit('gallery');
	} else {
		H.gemiusHit('article');
	}
};
Helpers.articleAnalytics = function(isGallery) {
	if (isGallery) {
		T.analyticsHit('gallery');
	} else {
		T.analyticsHit('article');
	}
};
Helpers.fbShare = function (item) {
    var dialogOptions = {
			name: Def.name + ' - ' + item.t,
			link: item.u,
			picture: item.p || (item.c.p && item.c.p[0] && item.c.p[0].f) || '',
			caption: item.l,
			description: 'Wysłane z aplikacji mobilnej ' + Def.name + ' na FirefoxOS'
		};
    window.plugins.facebookConnect.dialog('feed', dialogOptions, function(response) {
        // console.log("FacebookConnect.dialog:" + JSON.stringify(response));
    });
};
/**
 * sprawdzenie czy swipe jest pionowy
 */
Helpers.isVerticalSwipe = function(x, y) {
    if (x < y && (Math.abs(x) < 50)) {
        return true;
    } else {
        return false;
    }
};
Helpers.gestTimeout = null;
Helpers.gestFunction = null;

/**
 * wyświetlenie użytkownikowi informacji o tym, że może wykonać swipe na zajawce
 */
Helpers.gestureTutorial = function() {
	var toShow = lscache.get(Def.name + 'GestureTut');
	
	
	if (!T.bool(toShow)) { // sprawdzenie czy jest potrzeba pokazania tutoriala. Nie jeśli użytkownik kiedykolwiek wykonał już swipe w aplikacji
		var el = document.createElement('div'),
			sneakPeak = $('#index').find('.sneakPeak')[0], // pierwsza zajawka
			fn = function(){
				lscache.set(Def.name + 'GestureTut', true);
				H.gestFunction = null;
				el.removeEventListener('touchend', fn);
				el.style.display = 'none';
				sneakPeak.removeChild(el);
			};
		
		el.id = 'gesture';
		el.style.width = sneakPeak.clientWidth + 'px';
		el.innerHTML = '<div style="min-height: ' + (sneakPeak.clientWidth - 50) + 'px;"><h2>Przesuń żeby przeglądać</h2></div>'
		H.gestTimeout = setTimeout(function() {
			el.addEventListener('touchend', fn);
			el.style.display = 'block';
		}, 6000); // po jakim okresie bezczynności użytkownika pokazać ekran pomocniczy
		
		H.gestFunction = function() {
			fn();
			clearTimeout(H.gestTimeout);
		}; // przypisanie funkcji do wywołania po swipe
		sneakPeak.appendChild(el);
	}
};
/**
 * dodanie tła (standardowego, sponsorskiego lub nocnego) w wersji androidowej
 * 
 * @param {Bool|String} [src] źródło tła
 * @param {Number} [top] offset górny (zmienny w zależności od tego czy wyświetlana jest reklama)
 */
Helpers.addAndroidBG = function(src, top) {
	var fgColor = Def && Def.fgColor || '255,255,255';
	
	if (src || (Def && (Def.bgImage || Def.bgColor))) {
		var height = Math.round(window.innerHeight * (T.pixelRatio < 1 ? 1 : T.pixelRatio)),
			offsetTop = top || 0,
			bg = src ? 'url(' + src + ')' : (Def.bgImage ? Def.bgImage : ('-webkit-gradient(linear,left bottom,left top,color-stop(0, rgb(' + Def.bgColor + ')),color-stop(1, rgb(' + Def.bgColor + ')))'));
	
		$('#viewport').css({
			'z-index' : '2',
			'background-image' : 'none',
			'background-color' : 'transparent'
		});
		$('#androidBG').css({
			'height' : height + 'px',
			'background-image' : bg,
			'background-repeat' : 'no-repeat',
			'background-size' : '100% 100%',
			'background-position' : 'left top'
		});
		document.styleSheets[1].insertRule(
				'.android.showed.promo #banner-top {' +
				'background-repeat: no-repeat;' +
				'background-size: 100% ' + height + 'px;' +
				'background-position: left top;' +
				'background-image: ' + bg + ';}', 0);
		document.styleSheets[1].insertRule(
				'.android.promo #banner-top {' +
				'background-color: transparent !important;}', 1);
		document.styleSheets[1].insertRule(
				'.android.showed #header {' +
				'background-size: ' + ($('#header')[0].clientWidth - 20) + 'px 10px, 100% ' + height + 'px;' +
				'background-position: 10px bottom, 0 -' + offsetTop + 'px;' +
			    'background-image: -webkit-gradient(linear,left bottom,left top,color-stop(0, rgb(' + fgColor + ')),color-stop(1, rgb(' + fgColor + '))), ' + bg + ' !important;}', 2);
	} else {
		document.styleSheets[1].insertRule(
				'.android.showed #header {' +
				'background-size: ' + ($('#header')[0].clientWidth - 20) + 'px 10px;' +
				'background-position: 10px bottom;' +
			    'background-image: -webkit-gradient(linear,left bottom,left top,color-stop(0, rgb(' + fgColor + ')),color-stop(1, rgb(' + fgColor + '))) !important;}', 0);
	}
};

/**
 * sprawdzenie czy jest konieczność wyświetlenia tła nocnego
 * @param {Number} [top] offset górny (zmienny w zależności od tego czy wyświetlana jest reklama). Przekazywany dalej do innej funkcji
 */
Helpers.nightCheck = function(top) {
	var $html = $('html'),
		d = (new Date()).getHours()*1;
	
	if (d >= 20 || d < 6) {
		$html.addClass('night'); // w przypadku iOS wystarczy nadać tylko klasę, reszta jest zdefiniowana przez css
	} else {
		$html.removeClass('night');
	}
};
/**
 * wyświetlenie alertu z prośbą o ocenę w markecie 
 * aplikacja wyświetli alert z prośbą o ocenę aplikacji po trzecim uruchomieniu programu
 */
Helpers.rateUs = function() {
	var toRate = lscache.get(Def.name + 'Rate'), // licznik || true
		setRate = function(){lscache.set(Def.name + 'Rate', toRate);}; // zapis licznika
	
	if (!T.bool(toRate)) {
		toRate = 2; setRate();
	} else if (typeof toRate === 'number') {
		toRate -= 1; setRate();
	}
	
	if (toRate === 0 && navigator.notification && navigator.notification.confirm) {
		var title = T.config.get('rate') && T.config.get('rate')['title'] || Def.name,
			url = T.config.get('rate') && (T.isIOS ? T.config.get('rate')['url'] : T.config.get('rate')['urlAnd']) || 'http://agora.pl',
			msg = T.config.get('rate') && (T.isIOS ? T.config.get('rate')['msg'] : T.config.get('rate')['msgAnd']) || 'Powiedz nam co sądzisz o ' + Def.name + ' na twoim smartfonie. Oceń nas',
			buttons = T.config.get('rate') && (T.isIOS ? T.config.get('rate')['buts'] : T.config.get('rate')['butsAnd']) || 'Teraz,Później,Nie przypominaj',
			fn = function(i) {
				if (i === 1) { // otwarcie strony z produktem do ocenienia
					toRate = true; setRate();
					T.showWebPage(url, true);
				} else if (i === 2) {
					toRate = 10; setRate(); // ponowne przypomninie za 10 otwarć aplikacji
				} else if (i === 3) {
					toRate = true; setRate(); // nie pokazywanie więcej alertu
				}
			};

		setTimeout(function(){
	        navigator.notification.confirm(msg, fn, title, buttons);
	    }, 10000); // wyświetlenie prośby po 10 sekundach od startu aplikacji
	}
};
/**
 * wyliczenie nowej wysokości metodą proporcji
 * @param {Number} w szerokość elementu
 * @param {Number} h wysokość elementu
 * @param {Number} contWidth szerokość kontenera, maksymalna szerokość elementu
 * 
 * @returns {Number} h wysokość elementu (stara lub nowa)
 */
Helpers.getHeight = function(w, h, contWidth){
	if (w > contWidth) {
		h = contWidth * h / w;
	}
	return h;
};
Helpers.deviceInfo = null;
Helpers.getOsVersion = function () {
	navigator.userAgent.match(/rv\:([0-9\.]+)/gi);
	return RegExp.$1 || 'unknown';
};
Helpers.getDeviceInfo = function () {

	if (H.deviceInfo === null) {
		H.deviceInfo = '&os=FirefoxOS&ver=' + H.getOsVersion();
	}
	return H.deviceInfo;
};

var $loader = null;
Helpers.showCssLoader = function(){
	$loader = $loader || $('#loader');

	$loader.show();
	$loader.addClass('fade');
};
Helpers.hideCssLoader = function(){
	$loader.removeClass('fade');
	setTimeout(function(){
		$loader.hide();
	}, 400);
};
var H = Helpers;