/**
 * jq.web.carousel - a carousel library for html5 mobile apps
 * @copyright AppMobi 2011 - AppMobi
 * 
 */
(function($) {
    var cache = [];
    $.fn.carousel = function(opts) {
        if (opts === undefined && this.length > 0) 
        {
            return cache[this[0].id] ? cache[this[0].id] : null;
        }
        var tmp = null,
            i = 0;

        for (i = 0; i < this.length; i++) {
            tmp = new carousel(this[i], opts);
            if (this[i].id)
                cache[this[i].id] = tmp;
        }
        return this.length === 1 ? tmp : this;
    };
    
    var carousel = (function() {
       
        var 
            translateOpen = "3d(",
            translateClose = ",0)";

        var carousel = function (containerEl, opts) {
            if (typeof containerEl === "string" || containerEl instanceof String) {
                this.container = document.getElementById(containerEl);
            } else {
                this.container = containerEl;
            }
            if (!this.container) {
                alert("Error finding container for carousel " + containerEl);
                return;
            }
            if (this instanceof carousel) {
                for (var j in opts) {
                    if (opts.hasOwnProperty(j)) {
                        this[j] = opts[j];
                    }
                }
            } else {
                return new carousel(containerEl, opts);
            }
            var 
                that = this,
                tmpHTML = this.container.innerHTML,
                pagingEl = null,
                el = document.createElement("div"),
                i = 0,
                hideElement = function (idx) {
                    if ( that.artList[idx] )
                        that.artList[idx].style.visibility = 'hidden';
                },
                showElement = function (idx) {
                    if ( that.artList[idx] )
                        that.artList[idx].style.visibility = 'visible';
                },
                hideImg = function (idx) {
                    if ( that.imgList[idx] )
                        that.imgList[idx].src = '';
                },
                showImg = function (idx) {
                    if ( that.imgList[idx] )
                        that.imgList[idx].setAttribute('src', that.imgList[idx].getAttribute('data-src'));
                },
                addToMemory = function (idx) {
                    if ( that.artList[idx] )
                        that.artList[idx].style.transform = 'translate3d(0,0,0)';
                },
                removeFromMemory = function (idx) {
                    if ( that.artList[idx] )
                        that.artList[idx].style.transform = 'none';
                };


            this.pagingDiv = this.pagingDiv ? document.getElementById(this.pagingDiv) : null;

            // initial setup
            this.container.style.overflow = "hidden";
            this.container.style['-moz-box-orient'] = "vertical";
            this.container.style['display'] = "-moz-box";
            this.container.style['-moz-box-orient'] = "vertical";
            // tmpHTML = this.container.innerHTML;
            this.container.innerHTML = "";
            // el = document.createElement("div");
            el.innerHTML = tmpHTML;
            // el.style.display = "-moz-box";
            // el.style['-moz-box-flex'] = 1;
            el.style.mozBackfaceVisiblity = "hidden";
            el.style.transformStyle = "preserve-3d";
            el.style.transitionTimingFunction = "linear";
            this.container.appendChild(el);
            this.el = el;
            this.refreshItems();
            el.addEventListener('touchmove', function(e) {
                that.touchMove(e);
            }, false);
            // lowEnd && el.addEventListener('touchmove', function(e) {
            //     that.touchMoveLowEnd(e);
            // }, false)
            el.addEventListener('touchend', function(e) {
                that.touchEnd(e);
            }, false);
            el.addEventListener('touchstart', function(e) {
                that.touchStart(e);
            }, false);
            window.addEventListener("orientationchange", function() {
                that.onMoveIndex(that.carouselIndex,0);
            }, false);

            this.myDivWidth = this.divWidth || numOnly(this.container.clientWidth);
            
            this.pagingDiv.style.left = 0;
            this.pagingDiv.style.transform = 'translate3d(0,0,0)';

            // this.moveBy = this.elRefresh * this.dotWidth;

            this.artList = document.querySelectorAll('#articlesList .sneakPeak');
            this.imgList = document.querySelectorAll('#articlesList .sneakPeak img');

            el.addEventListener('transitionend', function(e) {
                // if (that.toMemory) {
                //     if (that.goingNext) {
                //         addToMemory(that.carouselIndex + 1);
                //         removeFromMemory(that.carouselIndex - 1);
                //         // that.artList[that.carouselIndex + 1] && (that.artList[that.carouselIndex + 1].style.transform = 'translate3d(0,0,0)');
                //         // that.artList[that.carouselIndex - 1] && (that.artList[that.carouselIndex - 1].style.transform = 'none');
                //     } else {
                //         addToMemory(that.carouselIndex - 1);
                //         removeFromMemory(that.carouselIndex + 1);
                //         // that.artList[that.carouselIndex + 1] && (that.artList[that.carouselIndex + 1].style.transform = 'none');
                //         // that.artList[that.carouselIndex - 1] && (that.artList[that.carouselIndex - 1].style.transform = 'translate3d(0,0,0)');
                //     }
                // }

                if ( that.goingNext ) {
                    showImg(that.carouselIndex + 1);
                    showElement(that.carouselIndex + 2); 
                    hideElement(that.carouselIndex - 3);
                    hideImg(that.carouselIndex - 2);
                } else {  
                    showImg(that.carouselIndex - 1);
                    showElement(that.carouselIndex - 2); 
                    hideElement(that.carouselIndex + 3);
                    hideImg(that.carouselIndex + 2);
                }

                // that.artList[that.carouselIndex + 2] && (that.artList[that.carouselIndex + 2].style.visibility = 'hidden');
                // that.artList[that.carouselIndex + 1] && (that.artList[that.carouselIndex + 1].style.visibility = 'visible');
                // that.artList[that.carouselIndex] && (that.artList[that.carouselIndex].style.visibility = 'visible');
                // that.artList[that.carouselIndex - 1] && (that.artList[that.carouselIndex - 1].style.visibility = 'visible');
                // that.artList[that.carouselIndex - 2] && (that.artList[that.carouselIndex - 2].style.visibility = 'hidden');
            }, false);

            // Create the paging dots
            if (this.pagingDiv) {
                this.pagingDiv.innerHTML = "";
                for (i = 0; i < 8; i++) {
                    pagingEl = document.createElement("div");
                    pagingEl.id = this.container.id + "_" + i;
                    pagingEl.pageId = i;
                    if (i === 0) {
                        pagingEl.className = this.pagingCssNameSelected;
                    }
                    
                    this.pagingDiv.appendChild(pagingEl);
                    this.pagingDots.push(pagingEl);
                    // pagingEl = null;
                }
                this.pagingDiv.style.width = 8 * this.dotWidth + "px";
                this.pagingDiv.style.height = "25px";
            }
        };
        
        carousel.prototype = {
            startX: 0,
            startY: 0,
            dx: 0,
            dy: 0,
            myDivWidth: 0,
            myDivHeight: 0,
            cssMoveStart: 0,
            childrenCount: 0,
            carouselIndex: 0,
            vertical: false,
            horizontal: true,
            el: null,
            elementsWidth: null,
            divWidth: null,
            dotWidth: 15,
            movingElement: false,
            container: null,
            pagingDiv: null,
            pagingDots: [],
            pagingCssName: "carousel_paging",
            pagingCssNameSelected: "carousel_paging_selected",
            pagingCallback: null,
            pagingID: 0,
            lockMove: false,
            refreshed: true,
            
            //scrollable dots
            elRefresh: 0,
            dotsCounter: 1,
            scrollablePaging: false,
            // movedLeft: 0,
            // moveRight: 1,
            // moveBy: 0,
            
            //memory rules
            toMemory: false,
            goingNext: true,
            artList: [],
            
            getValueFromMatrix: function(matrix) {

                return matrix.split(',')[4]*1;
            },
            // handle the moving function
            touchStart: function(e) {
                this.lockMove=false;
                // if (event.touches[0].target && event.touches[0].target.type !== undefined) {
                //     var tagname = event.touches[0].target.tagName.toLowerCase();
                //     if (tagname === "select" || tagname === "input" || tagname === "button")  // stuff we need to allow
                //     {
                //         return;
                //     }
                // }
                if (e.touches.length === 1) {
                    
                    this.movingElement = true;
                    this.startY = e.touches[0].pageY;
                    this.startX = e.touches[0].pageX;
                    //e.preventDefault();
                    //e.stopPropagation();
                   
                    try {
                        // this.WebKitCSSMatrix.setMatrixValue(window.getComputedStyle(this.el, null).webkitTransform);
                        this.cssMoveStart = this.getValueFromMatrix(window.getComputedStyle(this.el, null).transform);
                    } catch (ex1) {
                        this.cssMoveStart = 0;
                    }
                }
            },
            touchMove: function(e) {
                // e.preventDefault();
                // e.stopPropagation();
                if(!this.movingElement)
                   return;
                if (e.touches.length > 1) {
                    return this.touchEnd(e);
                }
                
                var 
                    rawDelta = {
                        x: e.touches[0].pageX - this.startX,
                        y: e.touches[0].pageY - this.startY
                    },
                    movePos = null;

                T._touchesGlobal.x = e.touches[0].pageX;
                T._touchesGlobal.y = e.touches[0].pageY;
               
                if (!this.lockMove&&isHorizontalSwipe(rawDelta.x, rawDelta.y)) {
                     
                    movePos = {x: 0,y: 0};
                    this.dx = e.touches[0].pageX - this.startX;
                    this.dx += this.cssMoveStart;
                    e.preventDefault();
                    e.stopPropagation();
                    movePos.x = this.dx;
                } else
                   return this.lockMove = true;

                if (movePos)
                    this.moveCSS3(this.el, movePos);
            },
            touchEnd: function(e) {
                if (!this.movingElement) {
                    return;
                }
                // e.preventDefault();
                // e.stopPropagation();
                
                var 
                    runFinal = false,
                    endPos = this.getValueFromMatrix(window.getComputedStyle(this.el, null).transform),
                    totalMoved = 0,
                    currInd = 0,
                    movePos = {
                        x: 0,
                        y: 0
                    };

                if (endPos > 0) {
                    this.moveCSS3(this.el, movePos, "200");
                } else {
                    totalMoved = this.dx % this.myDivWidth / this.myDivWidth; // get a percentage of movement.
                    // Only need
                    // to drag 3% to trigger an event
                    currInd = this.carouselIndex;

                    if (endPos < this.cssMoveStart && totalMoved < -0.03) {
                        this.pagingDots[this.pagingID].className = this.pagingCssName;
                        currInd++; // move right/down
                        // this.moveRight++;
                        this.pagingID++;
                        this.goingNext = true;
                    } else if ((endPos > this.cssMoveStart && totalMoved > -0.97)) {
                        this.pagingDots[this.pagingID].className = this.pagingCssName;
                        currInd--; // move left/up
                        // this.moveRight--;
                        this.pagingID--;
                        this.goingNext = false;
                    }
                    if (currInd > (this.childrenCount - 1)) {
                        currInd = this.childrenCount - 1;
                        this.pagingID--;
                    }
                    if (currInd < 0) {
                        currInd = 0;
                    }
                    
                    movePos.x = (currInd * this.myDivWidth * -1);
                    
                    this.moveCSS3(this.el, movePos, "200");

                    if (this.carouselIndex != currInd)
                        runFinal = true;
                    this.carouselIndex = currInd;

                    if (this.pagingID > 7 || currInd === 0) {
                        this.pagingID = 0;
                    } else if (this.pagingID < 0) {
                        this.pagingID = 7;
                    }
                    this.pagingDots[this.pagingID].className = this.pagingCssNameSelected;
                }
              
                this.dx = 0;
                this.movingElement = false;
                this.startX = 0;
                this.dy = 0;
                this.startY = 0;

                if (runFinal && this.pagingCallback && typeof this.pagingCallback === "function")
                    this.pagingCallback(this.carouselIndex, this.childrenCount - 1, this.refreshed);
            },
            onMoveIndex: function (newInd, transitionTime) {

                var 
                    runFinal = false,
                    newTime = Math.abs(newInd - this.carouselIndex),
                    ind = newInd,
                    movePos = {
                        x: 0,
                        y: 0
                    },
                    time = transitionTime ? transitionTime : (50 + parseInt(newTime));

                this.myDivWidth = numOnly(this.container.clientWidth);

                if (ind < 0)
                    ind = 0;
                if (ind > this.childrenCount - 1)
                    ind = this.childrenCount - 1;
               
                movePos.x = (ind * this.myDivWidth * -1);
                
                this.moveCSS3(this.el, movePos, time);
                
                if (this.carouselIndex != ind)
                    runFinal = true;
                
                this.carouselIndex = ind;

                if (runFinal && this.pagingCallback && typeof this.pagingCallback === "function")
                    this.pagingCallback(currInd, this.childrenCount - 1);
            },
            
            moveCSS3: function(el, distanceToMove, time, timingFunction) {
                if (!time)
                    time = 0;
                else
                    time = parseInt(time);
                
                el.style.transform = "translate" + translateOpen + distanceToMove.x + "px, 0px" + translateClose;
                el.style.transitionDuration = time + "ms";
            },
            
            addItem: function(el, noRefresh) {
                var 
                    number = 1,
                    i = 0;

                if (el && el.nodeType) {
                    this.container.childNodes[0].appendChild(el);
                } else if ($.isArray(el)) {
                    number = el.length;
                    for (i = 0; i < number; i++) {
                        this.container.childNodes[0].appendChild(el[i]);
                    }
                }

                if (!noRefresh) {
                    this.refreshItems(number);
                } else {
                    this.refreshed = false;
                }
            },
            refreshItems: function(number) {
                var 
                    childrenCounter = 0,
                    that = this,
                    el = this.el,
                    n = el.childNodes[0],
                    widthParam = '',
                    heightParam = "100%",
                    elems = []
                    param = '',
                    i = 0;

                while (n) {
                    if (n.nodeType === 1) {
                        elems.push(n);
                        childrenCounter++;
                    }
                    n = n.nextSibling;
                }
                this.refreshed = true;
                
                param = (100 / childrenCounter) + "%";
                this.childrenCount = childrenCounter;
                widthParam = this.elementsWidth ? this.elementsWidth + "px" : parseFloat(100 / this.childrenCount) + "%";
                for (i = 0; i < elems.length; i++) {
                    elems[i].style.width = widthParam;
                    elems[i].style.height = "100%";
                }
                this.moveCSS3(el, {
                    x: 0,
                    y: 0
                });
                el.style.width = Math.ceil((this.childrenCount) * 100) + "%";
                el.style.height = "100%";
                el.style['min-height'] = "100%";
                if (number) {
                    this.onMoveIndex(this.carouselIndex, 1);
                } else {
                    this.onMoveIndex(this.carouselIndex);
                }
            
            }
        
        };
        return carousel;
    })();
    
    function isHorizontalSwipe(xAxis, yAxis) {
        var 
            X = xAxis,
            Y = yAxis,
            Z = Math.round(Math.sqrt(Math.pow(X,2)+Math.pow(Y,2))), //the distance - rounded - in pixels
            r = Math.atan2(Y,X), //angle in radians 
            swipeAngle = Math.round(r*180/Math.PI); //angle in degrees

        if ( swipeAngle < 0 )
            swipeAngle =  360 - Math.abs(swipeAngle);// for negative degree values

        if (((swipeAngle <= 215) && (swipeAngle >= 155)) || ((swipeAngle <= 45) && (swipeAngle >= 0)) || ((swipeAngle <= 360) && (swipeAngle >= 315))) { // horizontal angles with threshold
            return true; 
        } else {
            return false;
        }
    }
    
})(jq);