/**
 * $().swipe - a library to detect swipe events for jqMobi apps
 * Copyright 2011 - AppMobi 
 * Executes a callback function and passes in the direction return
 * @string (left,right,up,down)
 */ 
(function($) {
    var cache = [];
    $.fn["swipeListener"] = function(opts) {
        
        if (opts === undefined && this.length > 0) 
        {
            return cache[this[0].id] ? cache[this[0].id] : null;
        }
        for (var i = 0; i < this.length; i++) {
            tmp = new swipeListener(this[i], opts);
            if (this[i].id)
                cache[this[i].id] = tmp;
        }
        return this.length == 1 ? tmp : this;
    };
    var swipeListener = (function() {
        var swipeListener = function(elID, opts) {
            var that = this;
            if (typeof (elID) == "string")
                this.el = document.getElementById(elID);
            else
                this.el = elID
            if (!this.el) {
                alert("Error adding swipe listener for " + elID);
                return;
            }
            this.el.addEventListener('touchmove', function(e) {
                that.touchMove(e);
            }, false);
            this.el.addEventListener('touchend', function(e) {
                that.touchEnd(e);
            }, false);
            for (j in opts) {
                this[j] = opts[j];
            }
        };
        
        swipeListener.prototype = {
            startX: 0,
            startY: 0,
            movingX: 0,
            movingY: 0,
            vthreshold: 40,
            hthreshold: 70,
            movingElement: false,
            swipeDirection: {
                up: false,
                down: false,
                left: false,
                right: false
            },
            callBack: null,
            
            cancel: function() {
                this.startX = 0;
                this.startY = 0;
                this.movingX = 0;
                this.movingY = 0;
                this.movingElement = false;
                this.swipeDirection = {
                    up: false,
                    down: false,
                    left: false,
                    right: false
                };
            },
            touchStart: function(event) {
            	if (event.touches[0].target && event.touches[0].target.type !== undefined) {
                    var tagname = event.touches[0].target.tagName.toLowerCase();
                    if (tagname === "select" || tagname === "input" || tagname === "button")  // stuff we need to allow
                    {
                        return;
                    }
                }
                if (event.touches.length == 1) {
                    this.movingElement = true;
                    this.startX = event.touches[0].pageX;
                    this.startY = event.touches[0].pageY;

                    if (T.isIOS || ((T.isAnd3 || T.isAnd4) && !this.noPrevent)) {
                        event.preventDefault();
                    }
                }
            },
            touchMove: function(event) {
                if (this.movingElement == false) {
                    this.touchStart(event);
                }
                if (T.isIOS || ((T.isAnd3 || T.isAnd4) && !this.noPrevent)) {
                    event.preventDefault();
                }
                if (event.touches.length > 1 || !this.movingElement) {
                    this.cancel();
                    return;
                }
                this.movingX = event.touches[0].pageX - this.startX;
                this.movingY = event.touches[0].pageY - this.startY;
            },
            touchEnd: function(event) {
                if (!this.movingElement) {
                    return;
                }
                if (T.isIOS || ((T.isAnd3 || T.isAnd4) && !this.noPrevent)) {
                    event.preventDefault();
                }
                var swiped = false,
                	xAbs = Math.abs(this.movingX),
                	yAbs = Math.abs(this.movingY);
                this.swipeDirection = {};
                if (xAbs > this.hthreshold && yAbs > this.vthreshold) {
                	swiped = false;
                } else if (xAbs > this.hthreshold && xAbs > yAbs) {
                    this.swipeDirection.right = this.movingX > 0;
                    this.swipeDirection.left = this.movingX < 0;
                    swiped = true;
                } else if (yAbs > this.vthreshold && yAbs > xAbs) {
                    this.swipeDirection.up = this.movingY < 0;
                    this.swipeDirection.down = this.movingY > 0;
                    swiped = true;
                }
                if (swiped && typeof (this.callBack == "function"))
                    this.callBack(this.swipeDirection);
                
                this.cancel();
            }
        };
        return swipeListener;
    })();
   
})(jq);