T.namespace('Foremka').Model = {};
T.namespace('Foremka').Model.Base = (function(){
	var Base = T.namespace('Foremka').Base;
	/**
	 * Model
	 * @namespace
	 * @class
	 */
	var self = Base.cls(Base, function(a) {
        this.sup("_constr");
    });
	
	/**
	 * wysłanie zapytania do serwera
	 * @memberOf Model.Base-self
	 * @name fetch
	 * @param {string} source
	 * @param {function} [onSuccess]
	 * @param {function} [onError]
	 * @param {string|array|object|bool} [args="false"]
	 * @param {string} [type="get"] POST || GET
	 * @param {string} [dataType="json"]
	 */
	self.fetch = function(source, onSuccess, onError, args, type, dataType) {
		var url = source + '?ts=' + (new Date()).getTime() + '&resolution=' + Base.screen.w + 'x' + Base.screen.h + H.getDeviceInfo(); // dopisanie rozdzielczości ekranu do urla
		// alert(url);
		$.ajax({
			url: url,
			data: args || false,
			type: type || 'get',
			dataType: dataType || 'json',
			success: function(d, t, x){
				//online
				if (dataType && dataType.toLowerCase() !== 'json') {
					d = {'data': d};
				}
				if (d && (T.type(onSuccess) === 'function')) {
					onSuccess(d);
				}
			},
			error: function(xhr,e){
				console.log(e);
				// offline
				if (T.type(onError) === 'function') {
					onError();
				}
			}
		});
	};

	return self;
})();