/**
 * Narzędzia uniwersalne
 * @class
 */
var Tools = {};

Tools.isTouch = 'ontouchstart' in window;
Tools.isAndroid = navigator.userAgent.indexOf('Android') >= 0;
Tools.isIOS = navigator.userAgent.indexOf('iPhone') >= 0 || navigator.userAgent.indexOf('iPad') >= 0 || navigator.userAgent.indexOf('iPod') >= 0;
Tools.isMobile = navigator.userAgent.indexOf('Mobile') >= 0 || Tools.isAndroid || Tools.isIOS;
Tools.isAnd4 = Tools.isAndroid && navigator.userAgent.match(/Android 4\./);
Tools.isAnd3 = Tools.isAndroid && navigator.userAgent.match(/Android 3\./);
Tools.timeDifference = 0;
Tools.pixelRatio = window.devicePixelRatio || 1;

Tools.gemiusHit = function(gemius_id){
	if(gemius_id && Tools.isMobile){
		(new Image()).src = 'http://gazeta.hit.gemius.pl/redot.gif?id=' + gemius_id;
	}
};

Tools.analyticsId = null;
Tools.analyticsStart = function () {
	if (window.plugins && (window.plugins.analytics || window.plugins.googleAnalyticsPlugin)) {
		if (T.isAndroid) {
			T.analyticsId = Def && Def.analytics && Def.analytics.android || null;
			window.plugins.analytics.start(T.analyticsId, function(){console.log("Start: success");}, function(){console.log("Start: failure");});
		} else if (T.isIOS) {
			T.analyticsId = Def && Def.analytics && Def.analytics.ios || null;
			window.plugins.googleAnalyticsPlugin.startTrackerWithAccountID(T.analyticsId);
		}
	}
};
Tools.analyticsHit = function (action) {
	if (T.analyticsId) {
		if (T.isAndroid) {
			window.plugins.analytics.trackPageView(action, function(){console.log("Track: success");}, function(){console.log("Track: failure");});
		} else if (T.isIOS) {
			window.plugins.googleAnalyticsPlugin.trackPageview("/" + action);
		}
	}
};
Tools.namespace = function(name, base) {
    var parent = base || window,
    list = name.split('.'), val;
    for (var i = 0, len = list.length, val = list[i]; i < len; i++) {
    	if (!((val = list[i]) in parent)) {
    		parent[val] = {};
    	}
    	parent = parent[val];
    }
    return parent;
};

Tools.convertImage = function(img, format){
	return img.substring(0, img.length - 5) + format + img.substr(-4);
};

/**
 * Rozszerzanie funkcji bazowe o podane funkcje.
 * @param	{function}	primitive	funkcja bazowa, która będzie rozszerzana. Domyślnie wykonywana jest ostatnia.
 * @param	{function|array}	fn	funkcja lub lista funkcji o które będziemy rozszerzać
 * @param	{boolean}	[reverse]	flaga mówiąca, że funkcja bazowa wykonuje się pierwsza
 * @return	{function}	nowa funkcja
 */
Tools.funFactory = function(){
	var args = [].splice.call(arguments, 0)
		, baseFn = args[0]
		, reverse = T.type(args[args.length-1]) === 'boolean' && args[args.length - 1]
		, fns = args.slice(1, args.length - (T.type(args[args.length-1]) === 'boolean' ? 1 : 0));
	
	if (Tools.type(baseFn) !== 'function') {
		return false;
	}
	if (Tools.type(fns) !== 'array') {
		fns = [fns];
	};
	return function(){
		reverse && baseFn();
		_.each(fns, function(fn){
			if (Tools.type(fn) === 'function') {
				fn();
			}
		});
		reverse || baseFn();
	};
};

Tools.Stack = (function(){
	var _states = [];
	return {
		push: function(state){
			for(var i=0; i< _states.length; i++){
				if(_states[i] === state){
					_states.splice(i,1);
				}
			}
			_states.push(state);
		},
		pop: function(){
			return _states.pop();
		}
	};
})();

Tools.checkConnection = function() {
	var networkState = navigator.network.connection.type;

    var states = {};
    states[Connection.UNKNOWN]  = 'unknown';
    states[Connection.ETHERNET] = 'ethernet';
    states[Connection.WIFI]     = 'wifi';
    states[Connection.CELL_2G]  = '2g';
    states[Connection.CELL_3G]  = '3g';
    states[Connection.CELL_4G]  = '4g';
    states[Connection.NONE]     = 'none';

	return states[networkState];
};
Tools.timeoutLoader = null;

Tools.showLoader = function(options){
	clearTimeout(Tools.timeoutLoader);
	var headerHeight = parseInt($('#header').height(),10);
	var viewHeight = window.innerHeight - headerHeight;
	if(navigator.notificationEx){
		navigator.notificationEx.loadingStart({viewY: headerHeight, viewHeight:viewHeight, backgroundOpacity:0.3});
	}else{
		$("#loader").show();
	}
};

Tools.hideLoader = function(options){
	Tools.timeoutLoader = setTimeout(function(){
		if(navigator.notificationEx){
			navigator.notificationEx.loadingStop();
		}else{
			$("#loader").hide();
		}
	}, 500);
};

Tools.showSplash = function(options) {
	$("#splash").show();
};

Tools.hideSplash = function(options) {
	$("#splash").hide();
};

Tools.showWebPage = function(url, external){
	if(window.plugins && window.plugins.childBrowser){
		if (external){
			window.plugins.childBrowser.openExternal(url)
		} else {
			window.plugins.childBrowser.showWebPage(url);
		}
	}else{
		try {
			var openURL = new MozActivity({
			    name: "view",
			    data: {
			        type: "url", // Possibly text/html in future versions
			        url: url
			    }
			});
		} catch(e) {
			console.log("can't open url: " + url);
		}
	}
};

Tools.mozillaShare = function(url) {
	try {
		var shared = new MozActivity({
			name: "share",
			data: {
			    number: 1,
			    text: url
			}
			});
	} catch (e){

	}

};

Tools.beep = function(times){
	if(navigator.notification && navigator.notification.beep){
		navigator.notification.beep(times);
	}else{
		console.log("can't beep");
	}
};

Tools.vibrate = function(milliseconds){
	if(navigator.notification && navigator.notification.vibrate){
		navigator.notification.vibrate(milliseconds);
	}else{
		console.log("can't vibrate");
	}
};

Tools.badge = {};
Tools.badge.clear = function(){
	if(window.plugins && window.plugins.badge){
		plugins.badge.clear();
	}else{
		console.log("can't clear badge");
	}
};

Tools.notification = {};
Tools.notification.clear = function(){
	if(window.plugins && window.plugins.localNotification){
		plugins.localNotification.cancelAll();
	}else{
		console.log("can't clear localNotification");
	}
};

Tools.notification.add = function(options){
	if(window.plugins && window.plugins.localNotification){
		plugins.localNotification.add(options);
	}else if(window.plugins && window.plugins.statusBarNotification){
		var id = options.id || 1;
		window.plugins.statusBarNotification.notify(options.title, options.message, id);
	}else{
		console.log("can't add localNotification");
	}
};

Tools.sendEmail = function(subject, body, recipients) {
	if(window.plugins && window.plugins.emailComposer){
		window.plugins.emailComposer.showEmailComposer(subject, body, recipients);
	}else{
		try {
			new MozActivity({
				name: "new",
				data: {
					type: "mail",
				    number: 1,
				    url: "mailto:?subject=" + encodeURIComponent(subject) + '&body=' + encodeURIComponent(body)
				}
			});
		} catch (e){

		}
	}
};

Tools.exitApp = function(){
	navigator.app.exitApp();
};

Tools.valuer = function(toValue){
	var prohibited = 'ą ś ż ź ę ć ń ó ł'.split(' ').concat(' ')
	,	changes    = 'a s z z e c n o l _'.split(' ')
	,	value      = toValue.toLowerCase();
	for (var i = 0, j = prohibited.length; i < j; i++) {
		value = value.replace((new RegExp(prohibited[i], 'g')), changes[i]);
	}
	return value;
};

Tools.mobileEvent = function(event){	
	var map = {
		'click': 'touchend',
		'mouseup': 'touchend',
		'mousedown': 'touchstart'
	};
	if(Tools.isTouch){
		return map[event] || event;
	}
	return event;
};

Tools.syncTime = function(callback) {
	var timeServer = 'http://json-time.appspot.com/time.json?tz=Europe/Warsaw';

	T.showLoader();
	$.ajax({
		url: timeServer,
		type: 'get',
		dataType: 'json',
		success: function(d){
			var tmpDate = (new Date(d.datetime)).getTime();
			var currentDate = (new Date()).getTime();
			Tools.timeDifference = tmpDate - currentDate;
			console.log("Zsynchronizowano czas");
		},
		complete: function(){
           if (Tools.type(callback) === 'function') {
				callback();
			}
        },
		error: function(){
			console.log("Nie zsynchronizowano czasu");
		}
	});
};

Tools.getCurrentDate = function() {
	return new Date((new Date()).getTime() + Tools.timeDifference);
};

Tools.parseDate = function(timestamp){
    var day = 0,
    	hour = 0,
    	mins = 0,
    	secs = 0;
			
	timestamp = Math.floor(timestamp/1000);
	secs = timestamp % 60;
	timestamp = Math.floor(timestamp/60);
	mins = timestamp % 60;
	timestamp = Math.floor(timestamp/60);
	hour = timestamp % 24;
	day = Math.floor(timestamp/24);
			
    return {days: day, hours: hour, mins: mins, secs: secs}; 
};

Tools.purePullToRefresh = function(view, callback) {
	var $cont = view.$container,
		tmp = $cont.html(),
		$el = null,
		elOffset = 73,
		bodyDOM = document.body;
	
	//if (!$cont.find('.pullDown').length) {
	//	$cont.html('<div class="scroller">' + pullDown + '<div class="content">' + tmp + '</div></div>');
	//}
	
	$el = $cont.find('.pullDown');
	
	$cont.bind('touchstart', function(){
		console.log('start pull...');
		$el.removeClass('loading');
	});
	$cont.bind('touchmove', function(){
		var top = bodyDOM.scrollTop;
		console.log(top);
		if (top < 515) {
			$el.addClass('flip');
			$el.find('.text').html('PUŚĆ ABY ODŚNIEŻYĆ...');
		} else if (top > 515) {
			$el.removeClass('flip');
			$el.find('.text').html('W DÓŁ ABY ODŚNIEŻYĆ...');
		}
	});
	$cont.bind('touchend', function(){
		setTimeout(function(){

			var top = bodyDOM.scrollTop;
			console.log(top);
			if (top < 515) {
				$el.addClass('flip');
				$el.find('.text').html('PUŚĆ ABY ODŚNIEŻYĆ...');
			} else if (top > 515) {
				$el.removeClass('flip');
				$el.find('.text').html('W DÓŁ ABY ODŚNIEŻYĆ...');
			}
			
			

			if ($el.hasClass('flip')) {
				$el.addClass('loading');
				view[callback]();
				$el.removeClass('flip');
				$el.find('.text').html('TRWA ODŚNIEŻANIE...');
				$el.find('.lastUpdate').html('ostatnia aktualizacja ' + H.parseDate(T.getCurrentDate()));
				// IMPORTANT! do scrollerHandler.refresh() on the end 
				setTimeout(function(){
					bodyDOM.scrollTop = elOffset;
				}, 1000);
			}
		}, 500)
		
	});
};

Tools.pullToRefresh = function(view, callback, opts){
	var $cont = view.$container,
		$el = null,
		elOffset = 73;
	//$cont.html('<div class="scroller">' + pullDown + '<div class="content">' + tmp + '</div></div>');

	$el = $cont.find('.pullDown');

	return {
		options: {
			hideScrollbar: true,
			topOffset: 73,
			bounce: true,
			useTransition: true
		},
		methods: {
			onRefresh: function () {
				var $el = view.$container.find('.pullDown');
				if ($el.hasClass('loading')) {
					$el.removeClass('loading');
					$el.find('.text').html('W DÓŁ ABY ODŚNIEŻYĆ...');
				}
				if (opts.methods && T.type(opts.methods.onRefresh) === 'function') {
					opts.methods.onRefresh();
				}
			},
			onScrollMove: function () {
				var $el = view.$container.find('.pullDown');
				if (view.scrollerHandler.y > (5) && !$el.hasClass('flip')) {
					$el.addClass('flip');
					$el.find('.text').html('PUŚĆ ABY ODŚNIEŻYĆ...');
					view.scrollerHandler.minScrollY = 0;
				} else if (view.scrollerHandler.y < (5) && $el.hasClass('flip')) {
					$el.removeClass('flip');
					$el.find('.text').html('W DÓŁ ABY ODŚNIEŻYĆ...');
					view.scrollerHandler.minScrollY = -elOffset;
				}
				if (opts.methods && T.type(opts.methods.onScrollMove) === 'function') {
					opts.methods.onScrollMove();
				}
			},
			onScrollEnd: function () {
				var $el = view.$container.find('.pullDown');
				if ($el.hasClass('flip')) {
					view[callback]();
					$el.addClass('loading');
					$el.removeClass('flip');
					$el.find('.text').html('TRWA ODŚNIEŻANIE...');
					$el.find('.lastUpdate').html('ostatnia aktualizacja ' + H.parseDate(T.getCurrentDate()));
					// IMPORTANT! do scrollerHandler.refresh() on the end 
				}
				if (opts.methods && T.type(opts.methods.onScrollEnd) === 'function') {
					opts.methods.onScrollEnd();
				}
			}
		}
	};
	
};
Tools.fbIsChecking = false;
Tools.fbLogin = function() {
	if (T.isIOS) {
		window.plugins.shareKit.facebookConnect();
	};
};

Tools.fbLogout = function() {
	if (T.isIOS) {
		 window.plugins.shareKit.logoutFromFacebook();
		 console.log('Wylogowano');
	};
};

Tools.fbStatus = function(callback, options) {
	if (T.isIOS) {
		window.plugins.shareKit.isLoggedToFacebook(function(result){
            if (T.type(callback) === 'function') {
				callback(result, options);
			}
		});
	};
};
Tools.fbInit = function() {
	  FB.init({
		    appId  : '',
		    xfbml  : true
		  });
};
Tools.fbAddLike = function(url){
//	url = encodeURI(url);
//	return	'<fb:like class="likeContainer" href="' + url + '" send="false" layout="button_count" width="100" show_faces="false" font=""></fb:like>';
//	return '<iframe src="https://www.facebook.com/plugins/like.php?href=' + url + '&amp;send=false&amp;layout=button_count&amp;width=450&amp;show_faces=false&amp;action=like&amp;colorscheme=light&amp;font=arial&amp;height=21&amp;appId=251818734852590" scrolling="no" frameborder="0" style="border:none; overflow:hidden; width:450px; height:21px;" allowTransparency="true"></iframe>';
	return '<div class="fb-like" data-href="' + url + '" data-send="false" data-layout="button_count" data-width="120" data-show-faces="false" data-font="arial"></div>';
};

Tools.fbRefresh = function(container) {
	var timeLimit = 0, loop = null, $frame = $(container + ' .fbLike > .likeContainer');
    
    loop = function(status) {
		console.log('FB status: ' + status);
        if (status === 1) {
            T.fbIsChecking = false;
            $frame.attr('src', $frame.attr('src'));
            $frame.siblings().remove();
            T.alert('Zalogowano');
        } else if (timeLimit > 180) {
            T.fbIsChecking = false;
            console.log('Upłynął limit czasu');
        } else {
            timeLimit = timeLimit + 1;
            console.log(timeLimit);
            console.log('Waiting');
            setTimeout(function(){
                T.fbStatus(loop, container);
            },1000);
        }   
    };
    
    if (T.fbIsChecking === false) {
        T.fbStatus(loop, container);
        T.fbIsChecking = true;
    }
};

/* jQuery based */
Tools.class2type = {};

(function(){
	var types = "Boolean Number String Function Array Date RegExp Object".split(" ");
	for (var i = 0, j = types.length; i < j; i++) {
		Tools.class2type["[object " + types[i] + "]"] = types[i].toLowerCase();	
	}	
})();

Tools.toString = Object.prototype.toString;

Tools.type = function(obj) {
	return obj == null ?
		String(obj) :
		Tools.class2type[Tools.toString.call(obj)] || "object";
};

Tools.isPlainObject = function( obj ) {
	if ( !obj || jQuery.type(obj) !== "object" || obj.nodeType || jQuery.isWindow( obj ) ) {
		return false;
	}
	if ( obj.constructor &&
		!Object.prototype.hasOwnProperty.call(obj, "constructor") &&
		!Object.prototype.hasOwnProperty.call(obj.constructor.prototype, "isPrototypeOf") ) {
		return false;
	}

	var key;
	for ( key in obj ) {}

	return key === undefined || Object.prototype.hasOwnProperty.call( obj, key );
};

Tools.extend = function() {
	var options, name, src, copy, copyIsArray, clone,
	target = arguments[0] || {},
	i = 1,
	length = arguments.length,
	deep = false;

	// Handle a deep copy situation
	if ( typeof target === "boolean" ) {
		deep = target;
		target = arguments[1] || {};
		// skip the boolean and the target
		i = 2;
	}
	
	// Handle case when target is a string or something (possible in deep copy)
	if ( typeof target !== "object" && Tools.type(target) !== 'function' ) {
		target = {};
	}
	
	// extend jQuery itself if only one argument is passed
	if ( length === i ) {
		target = this;
		--i;
	}
	
	for ( ; i < length; i++ ) {
		// Only deal with non-null/undefined values
		if ( (options = arguments[ i ]) != null ) {
			// Extend the base object
			for ( name in options ) {
				src = target[ name ];
				copy = options[ name ];
	
				// Prevent never-ending loop
				if ( target === copy ) {
					continue;
				}
	
				// Recurse if we're merging plain objects or arrays
				if ( deep && copy && ( Tools.isPlainObject(copy) || (copyIsArray = (Tools.type(copy) === 'array')) ) ) {
					if ( copyIsArray ) {
						copyIsArray = false;
						clone = src && (Tools.type(src) === 'array') ? src : [];
	
					} else {
						clone = src && Tools.isPlainObject(src) ? src : {};
					}
	
					// Never move original objects, clone them
					target[ name ] = Tools.extend( deep, clone, copy );
	
				// Don't bring in undefined values
				} else if ( copy !== undefined ) {
					target[ name ] = copy;
				}
			}
		}
	}
	
	// Return the modified object
	return target;
};
/* end of jquery based tools */

Tools.getJSONByKey = function(jsonArr, key, value){
	var json = [], i = 0, j = jsonArr.length;

	while (i < j) {
		if (jsonArr[i][key] == value) {
			json.push(jsonArr[i]);
		}
		i += 1;
	}
	if (json.length === 1) json = json[0];
	return (T.bool(json) ? json : false);
};

Tools.inArrayByKey = function(jsonArr, key, value){
	var found = -1, i = 0, j = jsonArr.length;
	while (found == -1 && i < j) {
		if (jsonArr[i] != null) found = jsonArr[i][key] == value ? i : found;
		i += 1;
	}
	return found;
};

Tools.getObjKey = function(obj){
	//console.log(obj);
	if (Tools.type(obj) !== 'object') return false;
	var keys = [];
	for (var key in obj) {
		keys[keys.length] = key;
	}
	return keys.length == 1 ? keys[0] : keys;
};

Tools.log = function(){
	var args = [].splice.call(arguments, 0), msg = args.join(' ').replace('\n', '<br>');
	//$('#console').prepend('<li>'+msg+'</li>');
	console.log.apply(console, args);
	if (Tools.bool(window.debug)) window.debug.log(args);
};
Tools.confirm = function(msg, callback, but1, but2, title, timeout) {
    timeout = T.bool(timeout) ? timeout : 2000;
	if (navigator.notification && navigator.notification.confirm) {
		navigator.notification.confirm(
		        msg,
                function(index){
                    if (index === 1) {
                        setTimeout(callback, timeout);
                    }
                },
                title || Def && Def.name || 'Komunikat',
		        but1 + ',' + but2
		    );
	} else {
		if (window.confirm(msg)){
			callback();
		}
	}
};
Tools.simpleConfirm = function(msg, callback, title, but) {
	if (navigator.notification && navigator.notification.alert) {
		but = but || 'OK';
		title = title || Def && Def.name || 'Komunikat';
		navigator.notification.alert(
		        msg,
		        function(){if (typeof callback == 'function'){setTimeout(callback,2000);}},
		        title,
		        but
		    );	
	} else {
		if (window.confirm(msg)){
			callback();
		}
	}
};
Tools.alert = function(msg, title){
    var title = Def && Def.name || 'Komunikat';
	if (navigator.notification) {
		if (T.bool(title)) {
			navigator.notification.alert(msg ,function(){}, title);
		} else {
			navigator.notification.alert(msg);
		}
	} else {
		alert(msg);
	}
	//Tools.log(msg);
};

Tools.inspect = function(obj){
	var text = [];
	for(var key in obj){
		text[text.length] = key + ' = ' + obj[key];
	}
	return text.join(', ');
};

/* obsluga systemu plikow */
/* przyklad uzycia
 * 	T.writeToFile('plik.txt', 'zawartosc testowa', function(){
		T.readFile('plik.txt');
	})
 * 
 */
Tools.prepareFile = function(file, win, fail) {
	if (!window.requestFileSystem) { console.log('nie ma requestfilesystem!'); fail(); return false; }
    console.log('prepare file');
	window.requestFileSystem(LocalFileSystem.PERSISTENT, 0, function(fileSystem){
                             console.log('preapre file before getfile');
        fileSystem.root.getFile(file, {create: true}, win, fail);
	}, fail);
	return true;
};

Tools.writeToFile = function(file, content, win, fail){
	var fail = fail || function(evt){ (evt && T.log('Błąd zapisu pliku: ' + Tools.inspect(evt))) || T.log('Błąd zapisu pliku ' + file); }
		, win = win || function(){ T.log('Zapisano plik ' + file + '.'); };
	return !Tools.prepareFile(file, function(fileEntry){
		fileEntry.createWriter(function(writer) {
			writer.onwrite = win;
			writer.write(content);
	    }, fail);
	}, fail) && fail();
};

Tools.readFile = function(file, win, fail){
    console.log('read file before start');
	var fail = fail || function(){ T.log('Błąd odczytu pliku ' + file + '.'); }
	, win = win || function(content){ T.log('Odczytano z pliku ' + file + ': ' + content + ' EOF'); };
    console.log('read file started');
	return Tools.prepareFile(file, function(fileEntry){
		fileEntry.file(function(file){
                       console.log('file entry callback');
			var reader = new FileReader();
	        reader.onloadend = function(evt) {
	            win(evt.target.result);
	        };
	        reader.readAsText(file);
		}, fail);
	}, fail);
};

Tools.getSettings = function(key, onSuccess, onError) {
	if (Tools.isIOS && window.plugins.applicationPreferences) {
		window.plugins.applicationPreferences.get(key, 
			function(value){
          		console.log("Value of " + key + " is " + value);
				if (T.type(onSuccess) === 'function') {
					onSuccess(value, key);
				}
			}, 
			function(error){
				console.log(error);
				if (T.type(onError) === 'function') {
					onError(key);
				} else {
					T.setSettings(key, 1, onSuccess, onError);
				}
			}
		);
	} else {
		var savedKey = document.getElementsByTagName("title")[0].innerHTML + key;
		var value = lscache.get(T.url2filename(savedKey));
		
		if (value !== null) {
      		console.log("Value of " + key + " is " + value);
      		if (T.type(onSuccess) === 'function') {
				onSuccess(value, key);
			}
		} else {
			if (T.type(onError) === 'function') {
				onError(key);
			} else {
				T.setSettings(key, 1, onSuccess, onError);
			}
		}
	}
};

Tools.setSettings = function(key, value, onSuccess, onError) {
	if (Tools.isIOS && window.plugins.applicationPreferences) {
		window.plugins.applicationPreferences.set(key, value, 
			function(){
              	console.log("New value of " + key + " is " + value);
				if (T.type(onSuccess) === 'function') {
					onSuccess(value, key);
				}
			}, 
			function(error){
				console.log(error); 
				if (T.type(onError) === 'function') {
					onError(key, value);
				}
			}
		);
	} else {
		var savedKey = document.getElementsByTagName("title")[0].innerHTML + key;
		lscache.set(T.url2filename(savedKey), value);
		console.log("New value of " + key + " is " + value);
		if (T.type(onSuccess) === 'function') {
			onSuccess(value, key);
		}
	}
};

Tools.url2filename = function(url){
	return url.replace('https://', 'HTTPS_').replace('http://', 'HTTP_').replace(/\//g, '_SLASH_').replace(/\./g, '_DOT_').replace(/%/g, '_PROC_').replace(/\?/g, '_PYT_').replace(/&/g, '_AMP_').replace(/\:/g, '_COLON_');
};

Tools.filename2url = function(filename){
	return filename.replace(/HTTPS_/g, 'https://').replace(/HTTP_/g, 'http://').replace(/_SLASH_/g, '/').replace(/_DOT_/g, '.').replace(/_PROC_/g,'%').replace(/_PYT_/g,'?').replace(/_AMP_/,'&').replace(/_COLON_/g, ':');
};

Tools.bool = function(v){
	var vType = Tools.type(v)
		, ret = false;
	switch (vType) {
		case 'undefined': 
			ret = false; 
			break; 
		case 'boolean': 
			ret = v; 
			break;
		case 'string':
			if (v.toLowerCase() === 'false' || v === '' || v === 'null') {
				ret = false;
			} else {
				ret = true;
			}
			break;
		case 'number':
			ret = true;
			break;
		case 'array':
			if (v.length === 0) {
				ret = false;
			} else { 
				ret = true;
			}
			break;
		case 'object':
			var i = 0, k = null;
			for (k in v) {
				i++;
			}
			ret = i ? true : false;
			break;
		case 'function':
			ret = true;
			break;
	};
	
	return ret;
};

Tools.config = new Konfigura();
Tools.version = new Verszion();

Tools.preloadImages = function(){
	var imgs = Array.prototype.splice.call(arguments, 0),
		i = 0, j = imgs.length, 
		ratio = parseFloat(window.devicePixelRatio),
		path = 'img/';

	switch (ratio) {
		case 0.75: 	path += '0.75x'; break;
		case 1: 	path += '1.0x'; break;
		case 1.5: 	path += '1.5x'; break;
		case 2: 	path += '2.0x'; break;
	}

	path += '/';

	for (; i < j; i++) {
		(new Image()).src = path + imgs[i];
	}
};
Tools.lz = function(number) {
	if (number < 10) {
		return "0" + number;
	} else {
		return number;
	}
};
Tools.isOnline = function() {
	return navigator.onLine;
};
Tools._touchesGlobal = {};

var T = Tools;

if (typeof(Number.prototype.toRad) === "undefined") {
	Number.prototype.toRad = function() {
		return this * Math.PI / 180;
	};
}
// console
var console = console || {log:function(){}};