/*
 * Verszion
 *
 */

var Verszion = function() {
	this._defaults = false;
	this._appVersion = Def && Def.version || '1.0.0'; //current app version
	this._appVersionArray = this._appVersion.split('.');
	this._showTimeout = 5000; //when bottom bar with info about softUpdate should show
	this._hideTimeout = 10000; //when bottom bar with info about softUpdate should hide
};

/**
 * setDefaults
 * Ustawianie domyślnych opcji.
 * Jako argumenty może być podana para 'opcja': 'wartość' lub obiekt zawierający opcje konfiguracyjne
 * kod z config.js od Łukasz Rozbicki
 */

Verszion.prototype.setDefaults = function() {
	var defs = (arguments.length && Array.prototype.slice.call(arguments)) || false,
		defaults = {};
	if (!defs) {
		return false;
	}

	if ((defs instanceof Array) && defs.length) {
		switch (defs.length) {
			case 1: 
				if (T.type(defs[0]) === 'object') {
					defaults = defs[0];
				}
				break;
			case 2:
				if (T.type(defs[0]) === 'string') {
					defaults[defs[0]] = defs[1];
				}
				break;
		}
	}

	this._defaults = T.extend({}, this._defaults || {}, defaults);
};
/**
 * 
 * @returns {String} return current app version
 */
Verszion.prototype.currentVersion = function() {
	return this._appVersion;
};

/**
 * show bottom bar with info about soft update
 */
Verszion.prototype.softUpdate = function() {
	var that = this;
	return function() {
		console.log('soft update');
		var updateBar = document.createElement('div'),
			$updateBar = $(updateBar),
			closeLabel = document.createElement('span'),
			$closeLabel = $(closeLabel),
			timeoutID = null,
			updateData = that._defaults && that._defaults.softUpdate,
			updateStyle = that._defaults && that._defaults.style,
			href = updateData && updateData.href || 'http://agora.pl/',
			text = updateData && updateData.text || 'Pobierz nową wersję aplikacji';
		
		updateBar.id = 'verszion';
	
		if (updateStyle && updateStyle.box) {
			$updateBar.css(updateStyle.box);
		}
		closeLabel.className = 'closeLabel';
	
		if (updateStyle && updateStyle.close) {
			$closeLabel.css(updateStyle.close);
		}
		updateBar.innerHTML = '<span data-href="' + href + '">' + text + '</span>';
		document.body.appendChild(updateBar);
		var elHeight = updateBar.clientHeight + updateBar.clientTop + "px";
		$updateBar.css({
			'-webkit-transform' : 'translate3d(0,' + elHeight + ',0)'
		});
		closeLabel.textContent = updateData && updateData.closeText || 'ukryj';
		updateBar.appendChild(closeLabel);
		setTimeout(function(){
			$updateBar.css({
				'-webkit-transition-duration': '1s',
				'-webkit-transform' : 'translate3d(0,0,0)'
			});
			
			closeLabel.addEventListener('click', function(){
				clearTimeout(timeoutID);
				$updateBar.css({
					'-webkit-transform' : 'translate3d(0,' + elHeight + ',0)'
				});
			}, false);
			
			updateBar.firstChild.addEventListener('click', function(evt){
				clearTimeout(timeoutID);
				if(window.plugins && window.plugins.childBrowser){
					window.plugins.childBrowser.showExternalWebPage(evt.srcElement.getAttribute('data-href'));
				} else {
					window.location.href = evt.srcElement.getAttribute('data-href');
				}
			}, false);
	
			timeoutID = setTimeout(function(){
				$updateBar.css({
					'-webkit-transform' : 'translate3d(0,' + elHeight + ',0)'
				});
			}, that._defaults && that._defaults.whenHide || that._hideTimeout);
			
		}, that._defaults && that._defaults.whenShow || that._showTimeout);
	};
};

/**
 * show bottom bar with info about hard update
 */
Verszion.prototype.hardUpdate = function() {
	console.log('hard update');
	var onConfirm = null,
		state = false,
		updateData = this._defaults && this._defaults.hardUpdate,
		url = updateData && updateData.href || 'http://agora.pl/',
		title = updateData && updateData.title || 'Nowa wersja aplikacji';
		text = updateData && updateData.text || 'Aby kontynuować korzystanie z aplikacji, musisz pobrać jej najnowszą wersję';
	
	if (navigator.notification && navigator.notification.confirm) {
		onConfirm = function(state) {
			if (state === 1) {
				if(window.plugins && window.plugins.childBrowser){
					window.plugins.childBrowser.showExternalWebPage(url);
				} else {
					window.location.href = url;
				}
			}
		};
	    navigator.notification.confirm(
	        text,
	        onConfirm,
	        title,
	        'Pobierz,Nie teraz'
	    );
	} else {
		state = confirm(title + '\n' + text);
		if (state) {
			if(window.plugins && window.plugins.childBrowser){
				window.plugins.childBrowser.showExternalWebPage(url);
			} else {
				window.location.href = url;
			}
		}
	}
};
/**
 * 
 * @param options
 * example: 
 * 	{	
 * 		ver: '1.5.8', //info about current version in market
 * 		softUpdate: { //if there is no soft update, then 'softUpdate' should be false not object, or shouldn't exist
 * 			href: 'http://market.blablabla.com/ournewapp', //url to the market
 * 			text: 'You must update your app', //alert message
 *          closeText: 'ukryj', //hide bottom bar text
 *          whenShow: 5000, //when bottom bar should show (default: 5000)
 *          whenHide: 10000, //when bottom bar should show (default: 10000)
 *          style: {
 *          	box: { //new style for bottom bar
 *          		'color': '#000'
 *          	},
 *          	close: { //new style for close label at bottom bar
 *          		'font-size': '12px'
 *          	}
 *          }
 * 		},
 * 		hardUpdate: { //if there is no soft update, then 'hardUpdate' should be false not object, or shouldn't exist
 * 			href: 'http://market.blablabla.com/ournewapp', //url to the market
 * 			title: 'There is an update!', //alert title
 * 			text: 'You must update your app' //alert message
 * 		}
 *  }
 *  
 * @returns {Boolean} if hardUpdate is necessary return false, otherwise return true
 * 
 */
Verszion.prototype.checkVersion = function(options) {
	if (options) {
		this.setDefaults(options);
	}
	var newVer = this._defaults && this._defaults.ver && this._defaults.ver.split('.'),
		currentVer = this._appVersionArray;
		
	if ((newVer[0] > currentVer[0]) || ((newVer[0] === currentVer[0]) && (newVer[1] > currentVer[1]))) {
		this.hardUpdate();
		return false;
	} else if ((newVer[0] === currentVer[0]) && (newVer[1] === currentVer[1]) && (newVer[2] > currentVer[2])) {
		return this.softUpdate();
	} else {
		console.log('no new version');
		return true;
	}
};