T.namespace('Foremka').View.Article = (function(){
	var Base = T.namespace('Foremka').Base;
	var View = T.namespace('Foremka.View').Base;
	/**
	 * Widok artykułu
	 * @namespace
	 * @class
	 */
	var self = Base.cls(Base, function() {
        this.sup("_constr");
    });
	
	self.container = "#article";
	
	/**
	 * obiekt jQuery
	 * @memberOf View.Article-self
	 * @type {object}
	 */
	self.$container = View.$article;
	
	self.$scroller = self.$container.find('.scroller');
	
	var elWidth = self.$container[0].offsetWidth - 10, // szerokość artykułu
		ARTICLE_IMGS = [], // lista obrazków w artykule
		IMG_LAZY_LOADED = 0; // licznik załadowanych obrazków
	
	/**
	 * lazy load
	 * @memberOf View.Article-self
	 * @param {bool} [limit] czy zatrzymać ładowanie zdjęć po załadowaniu pierwszego z listy 
	 */
	self.imgLazyLoad = function(limit){
		if (ARTICLE_IMGS[IMG_LAZY_LOADED]) {
			var img = document.getElementById(ARTICLE_IMGS[IMG_LAZY_LOADED]),
				fn = function(){
					IMG_LAZY_LOADED += 1;
					img.removeAttribute('data-preload');
					if (!limit) {
						self.imgLazyLoad();
					}
				};
				
			if (img && !img.src) {
				img.onload = fn;
				img.onerror = function(){
					img.setAttribute('data-preload', 'error');
					img.removeAttribute('src');
					img.style.display = 'none';
					fn();
				};
				img.src = img.getAttribute('data-src');
				img.removeAttribute('data-src');
			}
		}
	};
	
	/**
	 * przygotowanie struktury dla artykułu który jest galerią
	 * @memberOf View.Article-self
	 * @param {array} item lista zdjęć i parametrów je opisujących
	 * 
	 * @return {string} html struktura galerii
	 */
	self.gallery = function(item) {
		var i = 0,
			html = [];

		Base.isGallery = true;
		
		html.push('<ul id="galleryList">');
		for (;i < item.length; i++) {
			html.push('<li class="element">');
			if (item[i].t) { // czy zdjęcie posiada tytuł
				html.push('<h3 class="elTitle">' + item[i].t + '</h3>');
			}
			if (item[i].f) { // czy istnieje zdjęcie galeriowe
				if (/[?]([0-9]+)x([0-9]+)/.test(item[i].f)) { // czy znamy wymiary zdjęcia
					html.push('<img id="IMG_' + i + '" data-preload="true" data-src="' + item[i].f + '" style="width:' + RegExp.$1 + 'px; height:' + H.getHeight(RegExp.$1, RegExp.$2, self.$scroller[0].offsetWidth) + 'px;" />');
				} else {
					html.push('<img id="IMG_' + i + '" data-preload="true" data-src="' + item[i].f + '" />');
				}
				ARTICLE_IMGS.push('IMG_' + i); // wrzucenie zdjęcia do listy obrazków
			}
			if (item[i].d) { // czy istnieje opis zdjęcia
				html.push('<div class="artText">' + item[i].d + "</div>");	
			}
			html.push('</li>');
		}
		html.push('</ul>');

		return html.join('');	
	};
	
	/**
	 * wyrenderowanie artykułu
	 * @name render
	 * @memberOf View.Article-self
	 */
	self.render = function(item) {
		var html = [];
		
		// ustawienie domyślnych wartości parametrów
		self.rendered = false;
		Base.isGallery = false;
		ARTICLE_IMGS = [];
		IMG_LAZY_LOADED = 0;

		html.push('<h2 class="artTitle">' + item.t + '</h2>');
		if (T.bool(item.l)){ // czy jest lead artykuły
			html.push('<div class="artLead">' + item.l + "</div>");	
		}
		if (item.c.p.length > 1) { // jeżeli liczba elementów jest większa niż jeden to artykuł jest galerią
			if (T.bool(item.c.t)){ // czy jest treść artykuły
				html.push('<div class="artText">' + item.c.t + "</div>");	
			}
			html.push(self.gallery(item.c.p));
		} else {
			if (item.c.p[0] && item.c.p[0].f) { // czy jest zdjęcie galeriowe
				if (/[?]([0-9]+)x([0-9]+)/.test(item.c.p[0].f)) { // czy znamy wymiary zdjęcia galeriowego
					html.push('<img id="IMG_0" data-preload="true" data-src="' + item.c.p[0].f + '" style="width:' + RegExp.$1 + 'px; height:' + H.getHeight(RegExp.$1, RegExp.$2, self.$scroller[0].offsetWidth) + 'px;" />');
				} else {
					html.push('<img id="IMG_0" data-preload="true" data-src="' + item.c.p[0].f + '" />');
				}
				ARTICLE_IMGS.push('IMG_0'); // wrzuć zdjęcie do listy obrazkóws
			}
			if (T.bool(item.c.t)){ // czy jest treść artykuły
				html.push('<div class="artText">' + item.c.t + "</div>");	
			}
		}
		
		self.$container.data('xx', item.x); // zapisanie xx zdjęcia (potrzebne do mechanizmu ulubionych)
		self.$container.data('tn', item.c.p[0] && item.c.p[0].tn || null); // zapisanie miniaturki zdjęcia (potrzebne do mechanizmu ulubionych)
		if (item.u) { // czy jest url zdjęcia
			self.$container.data('url', escape(item.u)); // zapisanie urla do artykułu (potrzebne do mechanizmu ulubionych)
		}
		self.$scroller.html('<div>' + html.join('') + '</div>'); 

		if (self.$container.hasClass('show')) {
			self.imgLazyLoad();	
		}
	
		self.$container.find('div.video').singleTap(function(e){
			var $el = $(this);
			
			if (T.bool($el.data('url'))) {
				T.showWebPage(unescape($el.data('url')), true);
			}
		});

		View.articleScroller.refresh(true);
		self.rendered = true;
		
	};
	return self;
})();