T.namespace('Foremka').View = {};
T.namespace('Foremka').View.Base = (function(){
	var Base = T.namespace('Foremka').Base;
	/**
	 * Widok
	 * @namespace
	 * @class
	 */
	var self = Base.cls(Base, function() {
        this.sup("_constr");
    });
	self.name = 'base view';
	self.container = "html";
	self.$container = $(self.container);
	self.$article = $('#article');
	self.$articleTmp = $('#articleTmp');
	self.$favourites = $('#favourites');
	self.body = $('body')[0];
	T.moving = false; //czy artykuł jest w ruchu (idzie za palcem użytkownika) 
	
	/**
	 * ukrywanie artykuły
	 * @memberOf View.Base-self
	 */
	self.hideArticle = function(){
		self.$container.removeClass('showed');
		self.$article.addClass('dragout');
		self.$article.removeClass('show');
		self.$container.removeClass('articleOver');
	};
	
	/**
	 * ukrywanie ulubionych
	 * @memberOf View.Base-self
	 */
	self.hideFavourites = function(){
		self.$container.removeClass('showed');
		self.$favourites.addClass('dragout');
		self.$favourites.removeClass('show');
		self.$container.removeClass('favourites');
	};
	
	/**
	 * kontrola ulubionych
	 * @memberOf View.Base-self
	 */
	self.favouritesControl = function(){
		if (self.$container.hasClass('favourites')) {
			self.hideFavourites();
		} else if (self.$container.hasClass('articleOver')) {
			self.hideArticle();
		} else {
			T.namespace('Foremka.Controller').Favourites.render();
			self.$container.addClass('favourites');
			self.$favourites.addClass('show');
		}
	};
	
	self.y = 0;
	
/**
	 * zunifikowany scroller artykułu
	 * @memberOf View.Base-self
	 * @type {object}
	 */
	self.articleScroller = (function(){
		var _scroller = document.getElementById('article').getElementsByClassName('scroller')[0];

		return {
			"enabled": true,
			"enable": function(){
				_scroller.style.overflowY = 'auto';
				self.articleScroller.enabled = true;
			},
			"disable": function(){
				_scroller.style.overflowY = 'hidden';
				self.articleScroller.enabled = false;
			},
			"refresh": function(){},
			"scrollTo": function(x, y, time){y = -1*y; self.y = y; _scroller.scrollTop = y},
			"y": function(){return _scroller.scrollTop}
		};
	})();
	
	/**
	 * zunifikowany scroller ulubionych
	 * @memberOf View.Base-self
	 * @type {object}
	 */
	self.favouritesScroller = (function(){
		return {
			"refresh": function(){},
			"scrollTo": function(x, y, time){y = -1*y; self.y = y; self.body.scrollTop = y}
		};
	})();
	
	/**
	 * globalne eventy
	 * @memberOf View.Base-self
	 */
	self.globalEvents = function(){
		
		/**
		 * akcja do wykonania po animacji kontenera artykułu
		 */
		var onEndArticle = function(){
			if (!T.moving) { // jeżeli artykuł nie "idzie za palcem"
				if (self.$container.hasClass('articleOver')){
					self.$container.addClass('showed');
					Base.refresh = false;
					H.articleAnalytics(Base.isGallery);
				} else {
					self.$article.removeClass('dragout');
					if (Base.favourites || Base.error && !Base.refresh) {
						self.favouritesControl();
					}
				}
			}
		};
		
		/**
		 * akcja do wykonania po animacji kontenera ulubionych 
		 */
		var onEndFavourites = function(){
			if (self.$container.hasClass('favourites')){
				self.$container.addClass('showed');
				setTimeout(function(){
					if (Base.favourites) {
						T.namespace('Foremka.Controller.Article').renderPrev();
						Base.favourites = false;
					}
				}, 10);
			} else {
				self.$favourites.removeClass('dragout');
				if (Base.favourites || Base.error && !Base.refresh) {
					T.namespace('Foremka.Controller.Article').show();
				} 
			}
		};
		
		self.$article.bind("animationend", onEndArticle, false);
		self.$favourites.bind("animationend", onEndFavourites, false);
		self.$articleTmp.bind("transitionend", function(){
			self.$container.addClass('added');
			self.$articleTmp.hide();
			self.$articleTmp.html('');
			self.$articleTmp.removeClass('anim');
			T.namespace('Foremka.Controller.Favourites').save();
		}, false);
		$('#header .logo').tap(function(){
			if (Base.error) { //jeżeli offline to logo działa jako refresh
				T.namespace('Foremka.Controller.Base').refresh();
			} else if (self.$container.hasClass('favourites')) { // jeżeli jesteśmy w ulubionych to chowa ulubione
				self.hideFavourites();
			} else {
				self.hideArticle();
			}
		});
		$('.button.favourites').tap(self.favouritesControl);
		$('.button.favouritesAdd').tap(function(){
			if (self.$container.hasClass('added')){
				T.namespace('Foremka.Controller').Favourites.remove(self.$article.data('xx'));
			} else {
				T.namespace('Foremka.Controller').Favourites.add(self.$article.data('xx'));
			}
		});
		$('.button.refresh').tap(T.namespace('Foremka.Controller.Base').refresh);
		$('.button.share').tap(function(){T.namespace('Foremka.Controller.Share').show()});
		$('#share_container .hide').tap(function(){T.namespace('Foremka.Controller.Share').hide()});
		$('#share_container .share').tap(function(e){
			var service = $(this).data('args');
			T.namespace('Foremka.Controller.Share').share(service);
		});
		
		/**
		 * obsługa zsuwania artykułu, ruch idący "za palcem"
		 */
		// var touch = {};
		// var abs = 0;
		// self.$article.bind('touchstart', function(e) {
		// 	touch.x = e.touches[0].pageX;
		// 	touch.y = e.touches[0].pageY;
	 //    }, false).bind('touchmove', function(e){
		// 	if (self.articleScroller.y() === 0) { //jeżeli artykuł jest już przescrollowany do góry
  //              touch.x2 = e.touches[0].pageX;
  //              touch.y2 = e.touches[0].pageY;
  //              if (T.moving) { // czy jest już w ruchu
  //                  if (touch.y1 < touch.y2) { // czy pozycja artykułu nie wróciła do wyjściowej
	 //    			  abs = touch.y2 - touch.y1;
  //                     self.$article.css('transform', 'translate3d(0,' + abs + 'px,0)');
  //                   } else if (!self.articleScroller.enabled){ // czy scroller jest wyłączony
  //                      T.moving = false;
  //                      self.articleScroller.enable();
  //                      self.$article.attr('style', '');
  //                      touch.x1 = null;
  //                      touch.y1 = null;
  //                   }
  //              } else if (!T.bool(touch.x1) && !T.bool(touch.y1)) { //ustawienie x1 i y1 potrzebne do określenia rodzaju swipe
		//            touch.x1 = e.touches[0].pageX;
		//            touch.y1 = e.touches[0].pageY;
  //              } else {
  //                  if ((touch.y1 < touch.y2) && H.isVerticalSwipe((touch.x2 - touch.x), (touch.y2 - touch.y))) { //czy swipe jest pionowy
  //                      self.articleScroller.disable(); //wyłącz scroll
  //               	   self.$article.css({'transitionDuration': '0s', 'transition-delay': '0s'}); //ustaw opóźnienie i czas trwania animacji na 0s aby animacja była płynna
  //               	   T.moving = true;
  //                  }
	 //    	   }
	 //    	}
		// }, false).bind('touchend', function(e) {
		// 	if (T.moving){ //czy był ruch
				
		// 		//ustaw domyslne wartości parametrów
		// 		T.moving = false;
		// 		self.articleScroller.enable();
		// 		self.$article.attr('style', '');
		// 		touch.x1 = null;
		// 		touch.y1 = null;
		// 		if (abs > 100) { //czy ruch był wystarczająco długi na schowanie artykułu
	 //        		if (Base.error) { //gdy offline to zrób refresh 
	 //        			T.namespace('Foremka.Controller.Base').refresh();
	 //        		} else {
	 //        			self.hideArticle();
	 //        		}
		// 		}
		// 	}
	 //    }, false);
		
		self.$article.swipeListener({
	        callBack: function(dir){
	        	if (dir.down && (self.articleScroller.y() === 0)) {
	        		if (Base.error) {
	        			T.namespace('Foremka.Controller.Base').refresh();
	        		} else {
	        			self.hideArticle();
	        		}
	        	}
	        },
	        noPrevent: true
		});
		
		self.$article.doubleTap(function(){
			if (Base.error) { // jeżeli błąd to podwójne tapnięcie 
    			T.namespace('Foremka.Controller.Base').refresh();
    		} else {
    			self.hideArticle();
    		}
		});
	};
	
	return self;
})();