T.namespace('Foremka').View.Favourites = (function(){
	var Base = T.namespace('Foremka').Base;
	var View = T.namespace('Foremka.View').Base;
	/**
	 * Widok ulubionych
	 * @namespace
	 * @class
	 */
	var self = Base.cls(Base, function() {
        this.sup("_constr");
    });
	
	self.container = "#favourites";
	self.$container = View.$favourites;
	self.$list = $('#favouritesList');
	
	/**
	 * komunikat do wyświetlenie w przypadku pustej listy artykułów
	 * @memberOf View.Favourites-self
	 */
	self.noFavourites = '<h1>Zbieraj ulubione<br/> artykuły i galerie.</h1>';
	
	/**
	 * wyrenderowanie listy ulubionych
	 * @name render
	 * @memberOf View.Favourites-self
	 * @param {object} items lista ulubionych
	 */
	self.render = function(items) {
		var html = [];
		
		if (T.bool(items)) { // czy są zapisane jakieś artykuły
			html.push('<h2 class="viewTitle">Ulubione</h2>');
			self.$container.removeClass('empty');
			for (var i in items) { // wypisanie ulubionych
				item = items[i];
				html.push('<li class="favourite" data-xx="' + item.xx + '" ' + (T.bool(item.u) ? 'data-url="' + item.u + '"' : '') + '>');
				html.push('	<div class="remove"></div>');
				if (item.tn) {
					html.push('	<div class="img"><img src="' + item.tn + '" /></div>');
				}
				html.push(' <div><h2 class="title">' + item.t + '</h2></div>');
				html.push('</li>');
			}
		} else { // jeżeli nie to wyświetl komunikat o braku ulubionych i nadaj odpowiednią klasę
			html.push(self.noFavourites);
			self.$container.addClass('empty');
		}
		self.$list.html('<div>' + html.join('') + '</div>');
		
		/**
		 * nadanie eventów tapnięcia na elementy na liście.
		 * tapnięcie otwiera webview
		 */
		self.$container.find('.favourite').tap(function(e){
			if (e.target.className !== 'remove') {
				var $el = $(this),
					xx = $el.data('xx');
				
				if (T.bool(xx)) {
					Base.favourites = true;
					T.namespace('Foremka.View.Base').hideFavourites();
					T.namespace('Foremka.Controller.Favourites').getContent(xx);
				}
			}
		});
		
		/**
		 * nadanie eventów usuwania artykułów z listy ulubionych
		 */
		self.$container.find('.favourite .remove').tap(function(e){
			var $el = $(e.target.parentNode),
				isMore = true;
			isMore = T.namespace('Foremka.Controller.Favourites').remove($el.data('xx'));
			if (isMore) { // czy istnieją jeszcze jakieś artykuły na liście
				$el.remove();
			};
		});
	};
	return self;
})();