T.namespace('Foremka').View.Index = (function(){
	var Base = T.namespace('Foremka').Base;
	var View = T.namespace('Foremka.View').Base;
	/**
	 * Widok listy zajawek
	 * @namespace
	 * @class
	 */
	var self = Base.cls(Base, function() {
        this.sup("_constr");
    });
	
	self.container = "#index";
	self.$container = $(self.container);
	self.$list = $('#articlesList');
	
	/**
	 * pokazanie artykułu 
	 * @memberOf View.Index-self
	 */
	self.showArticle = function(){
		T.namespace('Foremka.Controller.Article').show();
	};
	
	/**
	 * wyrenderowanie listy artykułów
	 * @name render
	 * @memberOf View.Index-self
	 * @param {array} items lista artykułów
	 */
	self.render = function(items) {
		var html = [],
			item = null,
			i = 0,
			isReady = true,
			timeoutID = 0,
			perPage = items.length / 2,
			length = items.length, // liczba artykułów
			_carousel = null,
			newSneakPeak = null,
			contSize = { // wymiary kontenera pojedynczej zajawki
				"w" : self.$container[0].offsetWidth,
				"h" : self.$container[0].offsetHeight 		
			},
			$sneakPeakList = null,
			sneakPeakHeight = 0,
			indexPhoto = null;

		//wypisanie zajawek
		for (i = 0; i < length; i++) {
			item = items[i];
			indexPhoto = item.p || item.c.p[0].f; //zdjęcie indeksowe, jak nie ma to pierwsze z galerii
			html.push('<div class="sneakPeak">');
			if (T.bool(indexPhoto)) { //czy zajawka ma zdjęcie
				if (item.c.p.length > 1){ //czy zajawka jest galerią
					html.push('	<div class="img isGallery">');
					html.push('	<div></div>');
					html.push('		<img src="' + indexPhoto + '" data-src="' + indexPhoto + '" />');
					html.push('	</div>');
					html.push(' <span class="title gallery">' + item.t + '</span>');
				} else {
					html.push('	<div class="img">');
					html.push('		<img src="' + indexPhoto + '" data-src="' + indexPhoto + '" />');
					html.push('	</div>');
					html.push(' <span class="title">' + item.t + '</span>');
				}
			} else {
				html.push(' <span class="title">' + item.t + '</span>');
			}
			html.push('</div>');
		}
		
		self.$list.html(html.join(''));
		
		/**
		 * generowanie nowych zajawek
		 * @param {object} item parametry artykułu
		 * 
		 * @return {DOMelement}
		 */
		newSneakPeak = function (item) {
			var el = document.createElement('div'),
				$el = $(el);
			indexPhoto = item.p || item.c.p[0].f;

			el.className = 'sneakPeak';
			if (T.bool(indexPhoto)) {
				if (item.c.p.length > 1){
					el.innerHTML = '<div class="img isGallery"><div></div><img src="' + indexPhoto + '" data-src="' + indexPhoto + '"/></div><span class="title gallery">' + item.t + '</span>';
				} else {
					el.innerHTML = '<div class="img"><img src="' + indexPhoto + '" data-src="' + indexPhoto + '" /></div><span class="title">' + item.t + '</span>';
				}
			} else {
				el.innerHTML = '<span class="title">' + item.t + '</span>';
			}
			
			$el.swipeListener({ //nadanie callbacków na gest swipe na zajawce
		        callBack: function(dir){
		        	if (dir.up && !(dir.left || dir.right)) {
		        		self.showArticle();
			    	}
		        }
			});
			$el.tap(function (e) {
				self.showArticle();
			});
			return el;
		};
		
		//stworzenie karuzeli z listy zajawek
		_carousel = self.$list.carousel({
			elementsWidth: contSize.w, //szerokość jednej zajawki
			pagingDiv: "carousel_dots", //kontener na doty
			elNumber: items.length, //liczba wszystkich zajawek (nie tylko tych wyświetlonych)
			toMemory: true, //czy wrzucać zajawki do pamięci
			dotWidth: 15, //szerokość jednej kropki
			scrollablePaging: true, //czy kropki mają być scrollowane
			elRefresh: length / 2,
			/**
			 * callback po zmianie zajawki
			 * @param {number} idx id zajawki
			 * @param {number} last ostatni element na liście
			 * @param {bool} refreshed czy lista została już odświeżona
			 */
			pagingCallback: function (idx, last, refreshed) {
				H.gestFunction && H.gestFunction();
				T.namespace('Foremka.Controller').Favourites.isAdded(items[idx].x); //czy nowa zajawka jest w ulubionych
				clearTimeout(timeoutID); // wyczyszczenie timeoutu od preloadu artykułu

				if (isReady && (idx+1 > perPage) && (idx+1 + perPage >= ++last)) {

					isReady = false;
					T.namespace('Foremka.Controller.Base').nextPage(function (articles) {

						items = items.concat(articles);
						var i = 0,
							length = articles.length,
							newItems = [];

						for ( ; i < length; i++) {
							newItems[newItems.length] = newSneakPeak(articles[i]);
						}
						if (newItems.length) {
							_carousel.addItem(newItems);
							_carousel.artList = document.querySelectorAll('#articlesList .sneakPeak');
							_carousel.imgList = document.querySelectorAll('#articlesList .sneakPeak img');

							H.titleCheck($(Array.prototype.slice.call(_carousel.artList, -1 * newItems.length)), sneakPeakHeight);
						}
						isReady = true;
					}, function () { isReady = true; });
				}
				
				T.namespace('Foremka.Controller.Article').clear(); //wyczyszczenie kontenera artykułu (skasowanie treści poprzedniego artykułu)
				
				//timeout na preload artykułu
				timeoutID = setTimeout(function () {
					T.namespace('Foremka.Controller.Article').render(items[idx]);
				}, 1000);
			}
		});
	    $sneakPeakList = $('.sneakPeak');
		$sneakPeakList.swipeListener({
	        callBack: function (dir) {
	        	if (dir.up && !(dir.left || dir.right)) {
	        		self.showArticle();
		    	}
	        }
		}).tap(function (e) {
			self.showArticle();
		});

		T.namespace('Foremka.Controller.Article').render(items[0]); 	//preload pierwszego artykułu
		T.namespace('Foremka.Controller').Favourites.isAdded(items[0].x); //czy pierwszy artykuł jest w ulubionych

		$sneakPeakList[0].style.visibility = 'visible';
		$sneakPeakList[1].style.visibility = 'visible';
		$sneakPeakList[2].style.visibility = 'visible';
		var _imgToLoad = $sneakPeakList.find('img')[0];

		if (T.bool(_imgToLoad)) {
			if (_imgToLoad.width > 0) {
				H.hideCssLoader();
			} else {
				_imgToLoad.onload = function () {
					H.hideCssLoader();
				};
				_imgToLoad.onerror = function () {
					H.hideCssLoader();
				};
			}
		} else {
			H.hideCssLoader();			
		}
		sneakPeakHeight = $sneakPeakList[0].offsetHeight;

		H.titleCheck($sneakPeakList, sneakPeakHeight);
		H.gestureTutorial(); //przygotowanie tutoriala do gestów
	};
	return self;
})();