var allGameplayData =
{
	"playerAiTypes" : [
		{
			"type" : "smart",
			"returnRates": [
				{
				 	returnRate: 0.02,
				 	fold: 0.5,
				 	raise: 0.05, // Bluff
				 	call: 0.45,
				 	minRaiseFactor: 2, // Small Blind multiplier, must be atleast 2!
				 	maxRaiseFactor: 2
				},
				{
				 	returnRate: 0.1,
				 	fold: 0.5,
				 	raise: 0.0,
				 	call: 0.5,
				 	minRaiseFactor: 2, // Small Blind multiplier, must be atleast 2!
				 	maxRaiseFactor: 2
				},
				{
					returnRate: 0.5,
					fold: 0.3,
					raise: 0.05, // Bluff
					call: 0.65,
					minRaiseFasctor: 2, // Small Blind multiplier, must be atleast 2!
					maxRaiseFactor: 2
				},
				{
					returnRate: 2,
					fold: 0,
					raise: 0.35,
					call: 0.65,
					minRaiseFactor: 2, // Small Blind multiplier, must be atleast 2!
					maxRaiseFactor: 2
				},
				{
					returnRate: 5,
					fold: 0,
					raise: 0.5,
					call: 0.5,
					minRaiseFactor: 2, // Small Blind multiplier, must be atleast 2!
					maxRaiseFactor: 4
				},
				{
					returnRate: 10, // Very big chances of winning
					fold: 0,
					raise: 0.7,
					call: 0.3,
					minRaiseFactor: 4, // Small Blind multiplier, must be atleast 2!
					maxRaiseFactor: 6
				}
			],
			"stackProtection": {
				bigBlindNum: 1,
				minimalHandStrength: 0.3
			}

		},
		
		{
			"type" : "dumb",
			"returnRates": [
				{
				 	returnRate: 0.02,
				 	fold: 0.2,
				 	raise: 0.3,
				 	call: 0.5,
				 	minRaiseFactor: 2, // Small Blind multiplier, must be atleast 2!
				 	maxRaiseFactor: 2
				},
				{
					returnRate: 5,
					fold: 0.2,
					raise: 0.2,
					call: 0.6,
					minRaiseFactor: 2, // Small Blind multiplier, must be atleast 2!
					maxRaiseFactor: 2
				},
				{
					returnRate: 8, // Very big chances of winning
					fold: 0.1,
					raise: 0.3,
					call: 0.6,
					minRaiseFactor: 2, // Small Blind multiplier, must be atleast 2!
					maxRaiseFactor: 4
				}
			],
			"stackProtection": {
				bigBlindNum: 1,
				minimalHandStrength: 0.1
			}

		},
		
		{
			"type" : "coward",
			"returnRates": [
				{
				 	returnRate: 1,
				 	fold: 0.6,
				 	raise: 0.0, // Bluff
				 	call: 0.4,
				 	minRaiseFactor: 2, // Small Blind multiplier, must be atleast 2!
				 	maxRaiseFactor: 2
				},
				{
					returnRate: 5,
					fold: 0.1,
					raise: 0.0,
					call: 0.9,
					minRaiseFactor: 2, // Small Blind multiplier, must be atleast 2!
					maxRaiseFactor: 4
				},
				{
					returnRate: 10, // Very big chances of winning
					fold: 0,
					raise: 0,
					call: 1,
					minRaiseFactor: 2, // Small Blind multiplier, must be atleast 2!
					maxRaiseFactor: 4
				}
			],
			"stackProtection": {
				bigBlindNum: 1,
				minimalHandStrength: 0.4
			}

		},
		
		{
			"type" : "cautious",
			"returnRates": [
				{
				 	returnRate: 1,
				 	fold: 0.5,
				 	raise: 0.0, 
				 	call: 0.5,
				 	minRaiseFactor: 2, // Small Blind multiplier, must be atleast 2!
				 	maxRaiseFactor: 2
				},
				{
				 	returnRate: 3,
				 	fold: 0.2,
				 	raise: 0.4,
				 	call: 0.4,
				 	minRaiseFactor: 2, // Small Blind multiplier, must be atleast 2!
				 	maxRaiseFactor: 2
				},
				{
					returnRate: 6,
					fold: 0,
					raise: 0.5, 
					call: 0.5,
					minRaiseFactor: 2, // Small Blind multiplier, must be atleast 2!
					maxRaiseFactor: 2
				},
				{
					returnRate: 10, // Very big chances of winning
					fold: 0,
					raise: 0.6,
					call: 0.4,
					minRaiseFactor: 2, // Small Blind multiplier, must be atleast 2!
					maxRaiseFactor: 4
				}
			],
			"stackProtection": {
				bigBlindNum: 1,
				minimalHandStrength: 0.4
			}

		},
		
		{
			"type" : "daring",
			"returnRates": [
				{
				 	returnRate: 0.05,
				 	fold: 0.2,
				 	raise: 0.2, // Bluff
				 	call: 0.6,
				 	minRaiseFactor: 2, // Small Blind multiplier, must be atleast 2!
				 	maxRaiseFactor: 2
				},
				{
					returnRate: 1,
					fold: 0,
					raise: 0.5,
					call: 0.5,
					minRaiseFactor: 2, // Small Blind multiplier, must be atleast 2!
					maxRaiseFactor: 2
				},
				{
					returnRate: 6,
					fold: 0,
					raise: 0.6,
					call: 0.4,
					minRaiseFactor: 2, // Small Blind multiplier, must be atleast 2!
					maxRaiseFactor: 4
				},
				{
					returnRate: 10, // Very big chances of winning
					fold: 0,
					raise: 0.7,
					call: 0.3,
					minRaiseFactor: 4, // Small Blind multiplier, must be atleast 2!
					maxRaiseFactor: 4
				}
			],
			"stackProtection": {
				bigBlindNum: 1,
				minimalHandStrength: 0.2
			}

		}

	]
}

var allCharacters = {
	"characters": [
		{
			"name": "alfred",
			"type": "cautious",
			"image": "images/characters/alfred.jpg"
		},
		{
			"name": "bob",
			"type": "smart",
			"image": "images/characters/bob.jpg"
		},
		{
			"name": "bruce",
			"type": "dumb",
			"image": "images/characters/bruce.jpg"
		},
		{
			"name": "carl",
			"type": "daring",
			"image": "images/characters/carl.jpg"
		},
		{
			"name": "chuck",
			"type": "dumb",
			"image": "images/characters/chuck.jpg"
		},
		{
			"name": "dina",
			"type": "smart",
			"image": "images/characters/dina.jpg"
		},
		{
			"name": "don",
			"type": "coward",
			"image": "images/characters/don.jpg"
		},
		{
			"name": "frank",
			"type": "cautious",
			"image": "images/characters/frank.jpg"
		},
		{
			"name": "fred",
			"type": "smart",
			"image": "images/characters/fred.jpg"
		},
		{
			"name": "garth",
			"type": "daring",
			"image": "images/characters/garth.jpg"
		},
		{
			"name": "johnny",
			"type": "coward",
			"image": "images/characters/johnny.jpg"
		},
		{
			"name": "lilly",
			"type": "smart",
			"image": "images/characters/lilly.jpg"
		},
		{
			"name": "max",
			"type": "dumb",
			"image": "images/characters/max.jpg"
		},
		{
			"name": "moe",
			"type": "daring",
			"image": "images/characters/moe.jpg"
		},
		{
			"name": "nelson",
			"type": "cautious",
			"image": "images/characters/nelson.jpg"
		},
		{
			"name": "norman",
			"type": "coward",
			"image": "images/characters/norman.jpg"
		},
		{
			"name": "parker",
			"type": "daring",
			"image": "images/characters/parker.jpg"
		},
		{
			"name": "sam",
			"type": "smart",
			"image": "images/characters/sam.jpg"
		},
		{
			"name": "sheena",
			"type": "coward",
			"image": "images/characters/sheena.jpg"
		},
		{
			"name": "sheryl",
			"type": "smart",
			"image": "images/characters/sheryl.jpg"
		},
		{
			"name": "steve",
			"type": "cautious",
			"image": "images/characters/steve.jpg"
		},
		{
			"name": "tina",
			"type": "daring",
			"image": "images/characters/tina.jpg"
		},
		{
			"name": "tyler",
			"type": "smart",
			"image": "images/characters/tyler.jpg"
		},
		{
			"name": "walter",
			"type": "smart",
			"image": "images/characters/walter.jpg"
		},
		{
			"name": "wendy",
			"type": "dumb",
			"image": "images/characters/wendy.jpg"
		},
	]
}

function GameplayDB() {}

GameplayDB.prototype.getGameplayData = function() {
	return allGameplayData;
}

GameplayDB.prototype.getCharacterData = function() {
	return allCharacters;
}