var Lights = {
    _delay: 100,
    _blinkTimeout: null,
    _isRed: false,
    _stepBlink: 0,
    _started: false,

    get menuButton() {
        return document.getElementById('main');
    },

    get canvas() {
        return document.getElementById('canvas');
    },

    /**
     * Initialize app
     */
    init: function() {
//        this.menuButton.addEventListener('click', this.start.bind(this));
        this.canvas.addEventListener('touchstart', this.toggle.bind(this));
    },

    /**
     * Hide application menu
     */
    menuHide: function() {
//        this.menuButton.style.display = 'none';
    },

    /**
     * Show application menu
     */
    menuShow: function() {
//        this.menuButton.style.display = 'block';
    },

    /**
     * Blink
     */
    blink: function() {
        this._stepBlink++;
        this._isRed = this._stepBlink % 4 ? !this._isRed : this._isRed;
        /**
         * Every 2nd step should be shown black screen
         */
        if (this._stepBlink % 2) {
            this.canvas.style.backgroundColor = '#000000';
            //Black screen should be show less time
            this._delay = this._delay / 2;
        } else {
            //Color should be shown longer
            this._delay = this._delay * 2;
            if (this._isRed) {
                this.canvas.style.backgroundColor = '#0000ff';
            } else {
                this.canvas.style.backgroundColor = '#ff0000';
            }
        }
        // Prevent overflow
        if (this._stepBlink >= 1000) {
            this._stepBlink = 0;
        }
        this._blinkTimeout = window.setTimeout(this.blink.bind(this), this._delay);
    },

    /**
     * Toggle lights
     */
    toggle: function() {
        if (this._started) {
            this.stop();
        } else {
            this.start();
        }
    },

    /**
     * Start blinking
     */
    start: function() {
        this.menuHide();
        //Run blink
        this.blink();
        this._started = true;
    },

    /**
     * Stop blinking
     */
    stop: function() {
        this._started = false;
        this.menuShow();
        this.reset();
    },

    /**
     * Reset settings. Unlock screen
     */
    reset: function() {
        //make canvas white
        this.canvas.style.backgroundColor = 'transparent';
        //Check timeout
        if (this._blinkTimeout) {
            window.clearTimeout(this._blinkTimeout);
        }
    }
};

/**
 * Initialize lights
 */
Lights.init();

/**
 * On hide handler
 */
document.addEventListener('visibilitychange', function() {
    Lights.stop();
});

/**
 * Exit handler
 */
window.addEventListener('beforeunload', function() {
    Lights.stop();
});