//////////////////////////////
///////    MODELS     ////////
//////////////////////////////

window.People = Backbone.Model.extend({
	urlRoot: "http://memefight.net/_polistweet/people" + "?callback=?", 	// ADD JSONP SUPPORT
	idAttribute: "user_screen"
});
window.PeopleCollection = Backbone.Collection.extend({
	model: People,
	url: "http://memefight.net/_polistweet/people" + "?callback=?" 	// ADD JSONP SUPPORT
});
window.Feed = Backbone.Model.extend({
	urlRoot: "http://memefight.net/_polistweet/tweets" + "?callback=?", 	// ADD JSONP SUPPORT
});
window.FeedCollection = Backbone.Collection.extend({
	model: Feed,
  initialize: function (options) { this.page = (options && options.page) ? options.page : 1; },
	url: "http://memefight.net/_polistweet/tweets/" + this.page + "?callback=?" 	// ADD JSONP SUPPORT
});
window.FeedBestCollection = Backbone.Collection.extend({
	model: Feed,
  initialize: function (options) { this.page = (options && options.page) ? options.page : 1; },
	url: function () { return "http://memefight.net/_polistweet/tweets/best/" + this.page + "?callback=?"; } 	// ADD JSONP SUPPORT
});
window.FeedPeopleCollection = Backbone.Collection.extend({
	model: Feed,
  initialize: function (options) { 
    if (options && options.politico) { this.politico = options.politico; }
    this.page = (options && options.page) ? options.page : 1; 
  },
	url: function () { return "http://memefight.net/_polistweet/tweets/user/" + this.politico + "/" + this.page + "?callback=?"; } 	// ADD JSONP SUPPORT
});


//////////////////////////////
///////    VIEWS      ////////
//////////////////////////////

window.InfoView = Backbone.View.extend({
  initialize:  function () { this.render(); },
  render:      function () { $(this.el).html(this.template()); return this; },
  afterRender: function () { this.delegateEvents(); }
});

window.FeedListView = Backbone.View.extend({
  initialize: function (options) {
    this.options = options || {};
    this.isLoading = false;
    this.render();
  },
  render: function () {
    var self = this;
    var feed = self.model.models;
    
    if (self.model.page==1) {
      $(this.el).html('<ul class="table-view custom-table-cell-streched" id="elenco_feed"></ul>');
    }
    for (var i = 0; i < feed.length; i++) {
      var politico = (this.options.peopleList) ? _.findWhere(this.options.peopleList.models, {id:feed[i].attributes.user_screen}) : "";
      var item = new FeedListItemView({model: feed[i], politico: politico});
  		//console.log(item);
  		$('#elenco_feed', self.el).append(item.render().el);
    }
    $("#content").off("scroll");
    $("#content").on("scroll" , function () {
      if( !self.isLoading && $("#content").scrollTop() > 0.5 * $("#content ul").height() ) {
        self.model.page += 1; // Load next page
        self.loadPage();
      }
    });
    return this;
  },
  loadPage: function () {
    var self = this;
    self.isLoading = true;
    self.model.fetch({cache: true, expires: 60*5 /* 5 minuti */,
      success: function(){
        self.render();
        self.isLoading = false;
    }});
  },
  afterRender: function () { this.delegateEvents(); }
});

window.FeedBestListView = Backbone.View.extend({
  initialize: function (options) {
    this.options = options || {};
    this.isLoading = false;
    this.render();
  },
  render: function () {
    var self = this;
    var feed = self.model.models;
    
    if (self.model.page==1) {
      $(this.el).html('<ul class="table-view custom-table-cell-streched" id="elenco_feed"></ul>');
    }
    for (var i = 0; i < feed.length; i++) {
      var politico = (this.options.peopleList) ? _.findWhere(this.options.peopleList.models, {id:feed[i].attributes.user_screen}) : "";
      var item = new FeedListItemView({model: feed[i], politico: politico});
  		$('#elenco_feed', self.el).append(item.render().el);
    }
    $("#content").off("scroll");
    $("#content").on("scroll" , function () {
      if( !self.isLoading && $("#content").scrollTop() > 0.5 * $("#content ul").height() ) {
        self.model.page += 1; // Load next page
        self.loadPage();
      }
    });
    return this;
  },
  loadPage: function () {
    var self = this;
    self.isLoading = true;
    self.model.fetch({cache: true, expires: 60*5 /* 5 minuti */,
      success: function(){
        self.render();
        self.isLoading = false;
    }});
  },
  afterRender: function () { this.delegateEvents(); }
});

window.FeedPeopleListView = Backbone.View.extend({
  initialize: function (options) {
    this.options = options || {};
    this.isLoading = false;
    this.render();
  },
  render: function () {
    var self = this;
    var feed = self.model.models;
    
    if (self.model.page==1) {
      $(this.el).html('<ul class="table-view custom-table-cell-streched" id="elenco_feed"></ul>');
    }
    var politico = (this.options.peopleList) ? _.findWhere(this.options.peopleList.models, {id:this.options.politico}) : "";
    for (var i = 0; i < feed.length; i++) {
      var item = new FeedListItemView({model: feed[i], politico: this.options.politico});
  		$('#elenco_feed', self.el).append(item.render().el);
    }
    $("#content").off("scroll");
    $("#content").on("scroll" , function () {
      if( !self.isLoading && $("#content").scrollTop() > 0.5 * $("#content ul").height() ) {
        self.model.page += 1; // Load next page
        self.loadPage();
      }
    });
    return this;
  },
  loadPage: function () {
    var self = this;
    self.isLoading = true;
    self.model.fetch({cache: true, expires: 60*5 /* 5 minuti */,
      success: function(){
        self.render();
        self.isLoading = false;
    }});
  },
  afterRender: function () { this.delegateEvents(); }
});

window.FeedListItemView = Backbone.View.extend({
  tagName:     "li",
  className:   "table-view-cell media",
  events: {
    "click .tweet_text"   : "share",
    "click .tweet_user"   : "link_people",
    "click .media-object" : "link_people"
  },
  initialize: function (options) {
      this.options = options || {};
      this.render();
  },
  render:      function () { 
 		// PULISCO IL TWEET
    //console.log(this.model.attributes.tweet);
    this.model.attributes.tweet_pulito = this.model.attributes.tweet;
    // HASHTAG
    var regex = /(^|\s)#(\w*[a-zA-Z_]+\w*)/g;
    this.model.attributes.tweet_pulito = this.model.attributes.tweet_pulito.replace(regex, '$1<span class="tweet_mention">#$2</span>');
    // USERS
    var regex = /(^|\s)@(\w*[a-zA-Z_]+\w*)/g;
    this.model.attributes.tweet_pulito = this.model.attributes.tweet_pulito.replace(regex, '$1<span class="tweet_mention">@$2</span>');
    // LINKS
    var regex = /\b([a-zA-Z]+:\/\/[\w_.\-]+\.[a-zA-Z]{2,6}[\/\w\-~.?=&%#+$*!]*)\b/i;
    this.model.attributes.tweet_pulito = this.model.attributes.tweet_pulito.replace(regex, "");

    // SALTO I TWEET VUOTI ( FATTI SOLO DI LINK ) E SENZA IMMAGINI
    if (this.model.attributes.tweet_pulito == "" && this.model.attributes.media == "") {
      //console.log("vuoto "+this.model.attributes.tweet);
      $(this.el).removeClass("table-view-cell");
    } else {
      this.model.attributes.user  = (this.options.politico) ? this.options.politico.attributes.user  : this.model.attributes.user_screen;
      this.model.attributes.thumb = (this.options.politico) ? this.options.politico.attributes.thumb : "";
      $(this.el).html(this.template(this.model.toJSON())); 
    }
    return this; 
  },
  afterRender: function () { this.delegateEvents(); },
  share: function () {
    // AGGIORNO I LIKE
    $.get("http://www.whiletrue.it/polistweet/tweets/like/"+this.model.attributes.id);
    
    var link = 'https://twitter.com/'+this.model.attributes.user_screen+'/status/'+this.model.attributes.id;
    // ESCAPE PER LE VIRGOLETTE
    var tweet_to_share = this.model.attributes.tweet.replace(/"/g, "\"");
    // GENERO IL PULSANTE SHARE
    if (window.plugins && window.plugins.socialsharing) {
      window.plugins.socialsharing.share(tweet_to_share, 'Tweet da '+this.model.attributes.user_screen, '', link);
    }
  },
  link_people: function () {
    utils.gotoAnimate('#content', '#people/'+this.model.attributes.user_screen);
  }
});

window.PeopleListView = Backbone.View.extend({
    initialize: function (options) {
        this.options = options || {};
        this.render();
    },
    render: function () {
      var self = this;
      var feed = self.model.models;
      
      if (!isNaN(self.options.id)) {
        var item_model = _.findWhere(feed, {id:parseInt(self.options.id)});
        var item = new FeedItemView({model: item_model});
        //console.log(item.model.toJSON());
        $(this.el).html(item.render().el);
      } else {
        $(this.el).html('<ul class="table-view" id="elenco_feed"></ul>');
        for (var i = 0; i < feed.length; i++) {
          var item = new PeopleListItemView({model: feed[i]});
      		$('#elenco_feed', self.el).append(item.render().el);
        }
      }
      return this;
    },
    afterRender: function () { this.delegateEvents(); }
});

window.PeopleListItemView = Backbone.View.extend({
    tagName:     "li",
    className:   "table-view-cell media",
    initialize:  function () { this.render(); },
    render:      function () { $(this.el).html(this.template(this.model.toJSON())); return this; },
    afterRender: function () { this.delegateEvents(); }
});


//////////////////////////////
///////    ROUTER     ////////
//////////////////////////////

var AppRouter = Backbone.Router.extend({
	routes: {
	    ""                  : "home",
	    "likes"             : "likes",
	    "people"            : "people",
	    "people/:user_screen" : "people",
	    "info"              : "info"
	},
	initialize: function () {
    this.headerView = new HeaderView();
    $('#header').html(this.headerView.el);
    
    // ISTANZIO IL MODELLO DEI POLITICI
    if (!this.peopleList)   { this.peopleList   = new PeopleCollection(); }
    if (!this.feedList)     { this.feedList     = new FeedCollection(); }
    if (!this.feedBestList) { this.feedBestList = new FeedBestCollection(); }
    // RINFRESCO SUBITO I POLITICI
    //this.peopleList.fetch({cache: true, expires: 60*5 /* 5 minuti */ });
	},
  home: function () {
    var self = this;
    
    $("#content").html('<div class="text-center"><img src="images/loading.gif" alt="loading" title="loading" class="loading" /></div>');

    // RINFRESCO I POLITICI
    self.peopleList.fetch({cache: true, expires: 60*5 /* 5 minuti */,
      success: function(){  
        self.feedList.page = 1;
        self.feedList.fetch({cache: true, expires: 60*5 /* 5 minuti */,
          success: function(){
            $("#content").html(new FeedListView({model: self.feedList, peopleList: self.peopleList}).el);
        }});
      }
    });

    self.headerView.selectMenuItem('home');
  },
  likes: function () {
    var self = this;
    
    $("#content").html('<div class="text-center"><img src="images/loading.gif" alt="loading" title="loading" class="loading" /></div>');

    // RINFRESCO I POLITICI
    self.peopleList.fetch({cache: true, expires: 60*5 /* 5 minuti */ });

    self.feedBestList.page = 1;
    self.feedBestList.fetch({cache: true, expires: 60*5 /* 5 minuti */,
      success: function(){
        $("#content").html(new FeedBestListView({model: self.feedBestList, peopleList: self.peopleList}).el);
    }});
    self.headerView.selectMenuItem('likes');
  },
  people: function (user_screen) {
    var self = this;

    $("#content").html('<div class="text-center"><img src="images/loading.gif" alt="loading" title="loading" class="loading" /></div>');

    if (user_screen != undefined) {
      // RINFRESCO I POLITICI
      self.peopleList.fetch({cache: true, expires: 60*5 /* 5 minuti */ });
  
      var feedPeople     = new FeedPeopleCollection({politico:user_screen});
      feedPeople.fetch({cache: true, expires: 60*5,
        success: function(){
          var politico = (self.peopleList) ? _.findWhere(self.peopleList.models, {id:user_screen}) : "";
          $("#content").html(new FeedPeopleListView({model: feedPeople, politico:politico}).el);
      }});
      self.headerView.selectMenuItem('people_single');
    } else {
      self.peopleList.fetch({cache: true, expires: 60*5,
        success: function(){
          $("#content").html(new PeopleListView({model: self.peopleList}).el);
      }});
      self.headerView.selectMenuItem('people');
    }
  },
  info: function () {
    if (!this.infoView) { this.infoView = new InfoView(); }
    $('#content').html(this.infoView.el);
    this.headerView.selectMenuItem('info');
  }
});



function startEverything () {
  utils.loadTemplate(['HeaderView', 'FeedListItemView', 'PeopleListItemView', 'InfoView'], function() {
    app = new AppRouter();
    Backbone.history.start();
    
    // GESTIONE SWIPE
    $('#content').hammer({
      drag_lock_to_axis: true
    }).on("dragright", function(event) {
      event.gesture.stopDetect();
      if (Backbone.history.fragment == "")       { utils.gotoAnimate("#content", "#info"); }
      else if (Backbone.history.fragment == "info")   { utils.gotoAnimate("#content", "#people"); }
      else if (Backbone.history.fragment == "people") { utils.gotoAnimate("#content", "#likes"); }
      else if (Backbone.history.fragment == "likes")  { utils.gotoAnimate("#content", "#"); }
      else { /* POLITICO */ window.history.back(); }
    }).on("dragleft", function(event) {
      event.gesture.stopDetect();
      if (Backbone.history.fragment == "")            { utils.gotoAnimate("#content", "#likes"); }
      else if (Backbone.history.fragment == "info")   { utils.gotoAnimate("#content", "#"); }
      else if (Backbone.history.fragment == "people") { utils.gotoAnimate("#content", "#info"); }
      else if (Backbone.history.fragment == "likes")  { utils.gotoAnimate("#content", "#people"); }
      else { /* POLITICO */ window.history.back(); }
    });
    
    app.on("all",function(route, router) {
      // RIPORTO LO SCROLL VERTICALE A ZERO
      $('#content').animate({ scrollTop: 0 }, 'fast');
    });
  });
}

function init() {
  document.addEventListener("deviceready", startEverything, false); 
  //$(function() { startEverything(); });
}

window.onload = init;