function openTaskList() {
	$("#main-page").css({"left": "-100%"});
	$("#task-list-page").css({"left": "0%"});
}
function closeTaskList() {
	$("#main-page").css({"left": "0%"});
	$("#task-list-page").css({"left": "100%"});
}
function openSummaryList() {
	PM.updateSummary();
	$("#task-list-page").css({"left": "-100%"});
	$("#task-summary-page").css({"left": "0%"});
}
function closeSummaryList() {
	$("#task-list-page").css({"left": "0%"});
	$("#task-summary-page").css({"left": "100%"});
}
function showPomodoro() {
	$("#start-button").css({"display": "none"});
	$("#running-pomodoro").css({"display": "block"});
}
function hidePomodoro() {
	$("#running-pomodoro").css({"display": "none"});
	$("#start-button").css({"display": "block"});
}
function toggleTaskItemSelection(a) {
	ja = $(a);
	vm = ko.dataFor(a);
	if (ja.hasClass("selected-task-item")) {
		ja.removeClass("selected-task-item");
		vm.Selected(false);
		hideTaskListFooter();
	} else {
		others = ja.siblings(".task-item");
		others.removeClass("selected-task-item");				
		others.each(function(i, e) { ko.dataFor(e).Selected(false); });
		ja.addClass("selected-task-item");
		vm.Selected(true);
		showTaskListFooter();
	}
}
function showTaskListFooter() {
	$("#task-list-footer").css({"bottom": "0px"});
}
function hideTaskListFooter() {
	$("#task-list-footer").css({"bottom": "-46px"});
}
function openConfigPage() {
	$("#main-page").css({"left": "-100%"});
	$("#config-page").css({"left": "0%"});
}
function closeConfigPage() {
	$("#config-page").css({"left": "100%"});
	$("#main-page").css({"left": "0%"});
}
function redirectToPaypal() {
	return new MozActivity({
		name: "view",
		data: {
			type: "url",
			url: "http://polei.ro/pomodoro/paypal.htm"
		}
	});
}
function sendMail() {
	return new MozActivity({
		name: "new",
		data: {
			type: "mail",
			url: "mailto:yuri.oliveira@gmail.com?subject=Pomodoro%20Feedback"
		}
	});
}
$(function() {
	$(".checkbox-item").children("div").click(function() { 
		$(this).siblings("input").click();
	});
	
	$("#sendmail-button").click(sendMail);
	$("#paypal-button").click(redirectToPaypal);
	$("#openconfig-button").click(openConfigPage);
	$("#opentask-button").click(openTaskList);
	$("#closetask-button").click(closeTaskList);
	$("#opensummary-button").click(openSummaryList);
	$("#closeconfig-button").click(closeConfigPage);
	$("#closesummary-button").click(closeSummaryList);
	
	PM = new PomodoroManager();
	PM.init();
});