/**
 * funciones.js funciones de hermes rutas online lite
 * 
 * @projectDescription    Libreria Javascript para pomodoro.
 * @author Juan Luis Estevez juanlu@mosaico-web.com.com
 * @version 1.0
 * @copyright Mosaico-web 2013. 
 */

var pomodoro = 25 * 60;
var pausaCorta = 5 * 60;
var pausaLarga = 15 * 60;
var tiempoRestante;
var contadorActual;
var regresivaActual;
var tiempoActual;
var tiempoTotal;
var tituloActual = "";
var lite = true;
var nPruebas = 0;

/**
 * Indica cuando esta preparado el dispositivo
 */
$(document).on("ready", iniciar);
/**
 * Función de inicio de la aplicacion
 */
function iniciar() {
    variablesLocal();
    //iniciarNativo();
}

function variablesLocal() {
    if (localStorage.getItem("pomodoro") !== null) {
        pomodoro = localStorage.getItem("pomodoro");
        pausaCorta = localStorage.getItem("pausaCorta");
        pausaLarga = localStorage.getItem("pausaLarga");
    }
    $('#tPomodoro').val(pomodoro / 60);
    $('#tCorta').val(pausaCorta / 60);
    $('#tLarga').val(pausaLarga / 60);
}

function idioma() {
    var script = document.createElement('script');
    var lenguaje = navigator.language.substring(2, 0);
    switch (lenguaje) {
        case"es":
            script.src = 'js/lang/es.js';
            break;
        case"en":
            script.src = 'js/lang/en.js';
            break;
        case"fr":
            script.src = 'js/lang/fr.js';
            break;
        case"de":
            script.src = 'js/lang/de.js';
            break;
        case"it":
            script.src = 'js/lang/it.js';
            break;
        case"pt":
            script.src = 'js/lang/pt.js';
            break;
        default:
            script.src = 'js/lang/en.js';
    }
    script.type = 'text/javascript';
    script.defer = true;
    script.id = 'Traduc'; // Esto es para poder borrar el objeto despues for removal
    // Ahora se inserta el objeto creado en el elemento HEAD del html
    var head = document.getElementsByTagName('head').item(0);
    head.appendChild(script);
}

/**
 * Realiza la cuenta atras desde el tiempo seleccionado
 * @returns boolean
 */
function cuentaAtras() {
    console.log(tiempoRestante);
    if (tiempoRestante >= 1000) {
        tiempoActual = new Date();
        tiempoActual = tiempoActual.getTime();
        tiempoRestante = tiempoTotal - tiempoActual;
        var formato = new Date(tiempoRestante);
        var reloj = dameHora(formato);
    } else {
        window.clearInterval(regresivaActual);
        document.title = tituloFinal;
        $('#accion').html(tituloFinal.toUpperCase());
        console.log('llegamos al final');
        finalizar();
        var reloj = "00:00";
    }
    /*var miliSeguntos = tiempo * 1000;*/
    $('.tiempo').html(reloj);
    document.title = reloj;    
}

/**
 * Inicia la cuenta a tras y marca el tiempo de inicio
 */
function iniciaCuentaAtras() {
    tiempoActual = new Date();
    tiempoActual = tiempoActual.getTime();
    tiempoRestante = contadorActual * 1000;
    tiempoTotal = tiempoActual + tiempoRestante;
    regresivaActual = window.setInterval(cuentaAtras, 250);
}

/**
 * Función de inicio
 */
$(function() {
    idioma();
    /**
     * Asigna función al boton Pomodoro
     */
    $("#bPomodoro").click(tiempoPomodoro);
    /**
     * Función que controla el click en corto
     */
    $("#bCorto").click(tiempoCorto);
    /**
     * Función que controla el click en largo
     */
    $("#bLargo").click(tiempoLargo);
    /**
     * Función que controla el click en Parar
     */
    $("#bParar").click(para);
    /**
     * Función pra controlar el click en aceptar
     */
    $("#bAceptar").click(function() {
        grabarVariablesLocal();
    });
    /**
     * Función pra controlar el click en aceptar
     */
    $("#bCancelar").click(function() {
        location.href = "#principal";
        $('#accion').html(tituloActual.toUpperCase());
    });
    
    $("#bMenuSalir, #bSalir2").click(salir);
    /**
     * Pulsar Logo
     */
    $("#logo, #url, #web, #bMenuWww").click(function() {
        console.log('Vamos a abrir la web');
        abreWeb("http://www.mosaico-web.com");
    });
    /**
     * pulsa email
     */
    $(".email, #bMenuEmail, #bEmail").click(enviaCorreo);
    /**
     * función boton intro
     * @param {Event} event description
     */
    $('#formulario input').keydown(function(event) {
        if (event.which === 8) {
            return;
        }
        if (event.which === 13) {
            event.preventDefault();
            switch ($(this)[0].id) {
                case 'tPomodoro':
                    $('#tCorta').focus();
                    break;
                case 'tCorta':
                    $('#tLarga').focus();
                    break;
                case 'tLarga':
                    $('#bAceptar').focus();
                    grabarVariablesLocal();
                    break;
            }
        }
        if (event.which < 48 || event.which > 57) {
            event.preventDefault();
        }
        if (this.value.length >= 2) {
            event.preventDefault();
            return false;
        }
    });
    ajustarTamano();
});

function tiempoPomodoro() {
    window.clearInterval(regresivaActual);
    contadorActual = pomodoro;
    var miliSeguntos = contadorActual * 1000;
    var formato = new Date(miliSeguntos);
    var reloj = dameHora(formato);
    tituloActual = tituloPomodoro.toUpperCase();
    $('#accion').html(tituloActual);
    $('#timerPosition').html(reloj);
    iniciaCuentaAtras();
}

function tiempoCorto() {
    window.clearInterval(regresivaActual);
    contadorActual = pausaCorta;
    var miliSeguntos = contadorActual * 1000;
    var formato = new Date(miliSeguntos);
    var reloj = dameHora(formato);
    tituloActual = tituloCorto.toUpperCase();
    $('#accion').html(tituloActual);
    $('#timerPosition').html(reloj);
    iniciaCuentaAtras();
}

function tiempoLargo() {
    window.clearInterval(regresivaActual);
    contadorActual = pausaLarga;
    var miliSeguntos = contadorActual * 1000;
    var formato = new Date(miliSeguntos);
    var reloj = dameHora(formato);
    tituloActual = tituloLargo.toUpperCase();
    $('#accion').html(tituloActual);
    $('#timerPosition').html(reloj);
    iniciaCuentaAtras();
}

function para() {
    tituloActual = tituloParar.toUpperCase();
    $('#accion').html(tituloActual);
    window.clearInterval(regresivaActual);
    $('.tiempo').html("00:00");
}

/**
 * Dvuelve la hora formateada
 * @param formato DATE
 * @returns {String}
 */
function dameHora(formato) {
    var minutos;
    var segundos;
    if (formato.getMinutes() < 10) {
        minutos = "0" + formato.getMinutes();
    } else {
        minutos = formato.getMinutes();
    }
    if (formato.getSeconds() < 10) {
        segundos = "0" + formato.getSeconds();
    } else {
        segundos = formato.getSeconds();
    }

    return minutos + ":" + segundos;
}

/**
 * Ajusta tamaño de la pantalla segun dispositivo
 */
function ajustarTamano() {
    var tamano = $('body').width();
    //console.log('tamaño ' + tamano);
    if ((tamano >= 300) && (tamano <= 400)) {
        $('body').css('font-size', '34%');
    } else if (tamano === 1280) {
        $('body').css('font-size', '100%');
    } else if (tamano === 1024) {
        $('body').css('font-size', '80%');
    } else if ((tamano >= 700) && (tamano <= 850)) {
        $('body').css('font-size', '50%');
    } else if ((tamano >= 600) && (tamano <= 700)) {
        $('body').css('font-size', '50%');
    } else if ((tamano >= 400) && (tamano <= 600)) {
        $('body').css('font-size', '50%');
    } else if ((tamano >= 200) && (tamano <= 300)) {
        $('body').css('font-size', '20%');
    }
}

/**
 * Muestra los errores por consola
 */
function error() {
    console.log(errorAceleremetro);
}

/** acciones */

/**
 * Rellena los campos de formulario de configuración 
 */
function rellenaConfigurar() {
    $('#tCorta').val(pausaCorta / 60);
    $('#tLarga').val(pausaLarga / 60);
    $('#tPomodoro').val(pomodoro / 60);
}

/**
 * Asigna valor a las localstorage
 * Muestra el reloj de nuevo
 */
function grabarVariablesLocal() {
    pausaCorta = $('#tCorta').val() * 60;
    pausaLarga = $('#tLarga').val() * 60;
    pomodoro = $('#tPomodoro').val() * 60;
    localStorage.setItem("pausaCorta", pausaCorta);
    localStorage.setItem("pausaLarga", pausaLarga);
    localStorage.setItem("pomodoro", pomodoro);
    para();
    $('#accion').html(tituloInicial.toUpperCase());
    history.back();
}

/**
 * Muestra la publicidad grande
 */
function abrePublicidad() {
    $("#mascara").show();
    $("#granPublicidad").show();
}

/**
 * Muestra el mensaje de versión lite
 */
function abreLite() {
    $("#mascara").show();
    $("#proVersion").show();
}



/**
 * Oculta la publicidad grande
 */
function cierraPublicidad() {
    if (nPruebas === 3) {
        abrePro();
        salir();
    }
    $("#mascara").hide();
    $("#proVersion").hide();
}


/**
 * Función para efectuar traducciones
 * @returns {Void}
 */
function traducir() {
    //asignar nombres a los elementos del interface
    tituloActual = tituloInicial.toUpperCase();
    $("#accion").html(tituloInicial.toUpperCase());
    $("#bCortoTexto").html(botonCorta);
    $("#bLargoTexto").html(botonLarga);
    $("#bPararTexto").html(botonParar);
    $("#bAceptar").html(botonAceptar);
    $("#bCancelar").html(botonCancelar);
    $("#labelCorta").html(tituloCorto);
    $("#labelLarga").html(tituloLargo);
    $("#labelVibracion").html(labelVibracion);
    $("#configurarTitulo").html(labelTiempos);
    $(".unidades").html("(" + minutos + ")");
    $("#bAceptarAcerca").html(botonAceptar);
    $("#programador").html(programador);
    $("#diseno").html(diseno);
    $("#traduccion").html(traduccion);
    $("#bConfigurar").html(configuracion);
    $("#bAcercaDe").html(acercaDe);
    $("#bMenuEmail").html('E-mail');
    $("#bMenuWww").html('www');
    $("#bMenuSalir").html(cerrar);
}


function nada() {
    //console.log('hola');
}